/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.bean.BaseRemoteStore;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ADMRemoteStore
extends BaseRemoteStore {
    private static final Log logger = LogFactory.getLog(ADMRemoteStore.class);
    private static final String SURF_CONFIG = "surf-config";
    private static final Pattern USER_PATTERN_1 = Pattern.compile(".*/components/.*\\.user~(.*)~.*");
    private static final Pattern USER_PATTERN_2 = Pattern.compile(".*/pages/user/(.*?)(/.*)?$");
    private static final Pattern SITE_PATTERN_1 = Pattern.compile(".*/components/.*\\.site~(.*)~.*");
    private static final Pattern SITE_PATTERN_2 = Pattern.compile(".*/pages/site/(.*?)(/.*)?$");
    private NodeService nodeService;
    private NodeService unprotNodeService;
    private FileFolderService fileFolderService;
    private NamespaceService namespaceService;
    private SiteService siteService;
    private ContentService contentService;
    private HiddenAspect hiddenAspect;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setUnprotectedNodeService(NodeService nodeService) {
        this.unprotNodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    @Override
    protected void lastModified(final WebScriptResponse res, String store, final String path) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                if (fileInfo == null) {
                    throw new WebScriptException("Unable to locate file: " + encpath);
                }
                Writer out = res.getWriter();
                out.write(Long.toString(fileInfo.getModifiedDate().getTime()));
                out.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("lastModified: " + Long.toString(fileInfo.getModifiedDate().getTime())));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void getDocument(final WebScriptResponse res, String store, final String path) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                block17: {
                    String encpath = BaseRemoteStore.encodePath(path);
                    FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                    if (fileInfo == null || fileInfo.isFolder()) {
                        res.setStatus(404);
                        return null;
                    }
                    try {
                        ContentReader reader = ADMRemoteStore.this.contentService.getReader(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
                        if (reader == null || !reader.exists()) {
                            throw new WebScriptException("No content found for file: " + encpath);
                        }
                        String mimetype = reader.getMimetype();
                        if (mimetype == null || mimetype.length() == 0) {
                            mimetype = "application/octet-stream";
                            int extIndex = encpath.lastIndexOf(46);
                            if (extIndex != -1) {
                                String ext = encpath.substring(extIndex + 1);
                                String mt = (String)ADMRemoteStore.this.mimetypeService.getMimetypesByExtension().get(ext);
                                if (mt != null) {
                                    mimetype = mt;
                                }
                            }
                        }
                        res.setContentType(mimetype);
                        res.setContentEncoding(reader.getEncoding());
                        res.setHeader("Last-Modified", Long.toString(fileInfo.getModifiedDate().getTime()));
                        res.setHeader("Content-Length", Long.toString(reader.getSize()));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("getDocument: " + fileInfo.toString()));
                        }
                        try {
                            reader.getContent(res.getOutputStream());
                        }
                        catch (SocketException e1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                            }
                        }
                        catch (ContentIOException e2) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                            }
                        }
                        catch (Throwable err) {
                            if (err.getCause() instanceof SocketException) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                                }
                                break block17;
                            }
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)err.getMessage());
                            }
                            res.setStatus(500);
                        }
                    }
                    catch (AccessDeniedException ae) {
                        res.setStatus(401);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void hasDocument(final WebScriptResponse res, String store, final String path) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                Writer out = res.getWriter();
                out.write(Boolean.toString(fileInfo != null && !fileInfo.isFolder()));
                out.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("hasDocument: " + Boolean.toString(fileInfo != null && !fileInfo.isFolder())));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void createDocument(WebScriptResponse res, String store, String path, InputStream content) {
        try {
            this.writeDocument(path, content);
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        catch (FileExistsException feeErr) {
            res.setStatus(409);
        }
    }

    @Override
    protected void createDocuments(WebScriptResponse res, String store, InputStream in) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(in);
            Element docEl = document.getDocumentElement();
            Transformer transformer = (Transformer)ADMRemoteStore.transformer.get();
            for (Node n = docEl.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Element)) continue;
                String path = ((Element)n).getAttribute("path");
                Document doc = documentBuilder.newDocument();
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof Element)) continue;
                    doc.appendChild(doc.importNode(child, true));
                    break;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(512);
                transformer.transform(new DOMSource(doc), new StreamResult((OutputStream)out));
                out.close();
                this.writeDocument(path, new ByteArrayInputStream(out.toByteArray()));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        catch (FileExistsException feeErr) {
            res.setStatus(409);
        }
        catch (Exception e) {
            logger.error((Object)e);
            res.setStatus(500);
        }
    }

    private void writeDocument(final String path, final InputStream content) {
        final String encpath = ADMRemoteStore.encodePath(path);
        final int off = encpath.lastIndexOf(47);
        if (off != -1) {
            String runAsUser = AuthenticationUtil.getFullyAuthenticatedUser();
            String userId = null;
            Matcher matcher = USER_PATTERN_1.matcher(path);
            if (matcher.matches()) {
                userId = matcher.group(1);
            } else {
                matcher = USER_PATTERN_2.matcher(path);
                if (matcher.matches()) {
                    userId = matcher.group(1);
                }
            }
            if (userId != null && userId.equals(runAsUser)) {
                runAsUser = AuthenticationUtil.getSystemUserName();
            }
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() throws Exception {
                    FileInfo parentFolder = ADMRemoteStore.this.resolveNodePath(encpath, true, false);
                    if (parentFolder == null) {
                        throw new IllegalStateException("Unable to aquire parent folder reference for path: " + path);
                    }
                    FileInfo fileInfo = ADMRemoteStore.this.fileFolderService.create(parentFolder.getNodeRef(), encpath.substring(off + 1), ContentModel.TYPE_CONTENT);
                    HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(1, 1.0f);
                    aspectProperties.put(ContentModel.PROP_IS_INDEXED, false);
                    ADMRemoteStore.this.unprotNodeService.addAspect(fileInfo.getNodeRef(), ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
                    ContentWriter writer = ADMRemoteStore.this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.guessMimetype(fileInfo.getName());
                    writer.putContent(content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("createDocument: " + fileInfo.toString()));
                    }
                    return null;
                }
            }, (String)runAsUser);
        }
    }

    @Override
    protected void updateDocument(WebScriptResponse res, String store, String path, InputStream content) {
        String encpath = ADMRemoteStore.encodePath(path);
        FileInfo fileInfo = this.resolveFilePath(encpath);
        if (fileInfo == null || fileInfo.isFolder()) {
            res.setStatus(404);
            return;
        }
        try {
            ContentWriter writer = this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
            writer.putContent(content);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updateDocument: " + fileInfo.toString()));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
    }

    @Override
    protected void deleteDocument(WebScriptResponse res, String store, String path) {
        String encpath = ADMRemoteStore.encodePath(path);
        FileInfo fileInfo = this.resolveFilePath(encpath);
        if (fileInfo == null || fileInfo.isFolder()) {
            res.setStatus(404);
            return;
        }
        try {
            NodeRef fileRef = fileInfo.getNodeRef();
            this.nodeService.addAspect(fileRef, ContentModel.ASPECT_TEMPORARY, null);
            this.nodeService.deleteNode(fileRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("deleteDocument: " + fileInfo.toString()));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
    }

    @Override
    protected void listDocuments(final WebScriptResponse res, String store, final String path, final boolean recurse) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() throws Exception {
                res.setContentType("text/plain;charset=UTF-8");
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveNodePath(encpath, false, true);
                if (fileInfo == null || !fileInfo.isFolder()) {
                    res.setStatus(404);
                    return null;
                }
                try {
                    ADMRemoteStore.this.outputFileNodes(res.getWriter(), fileInfo, ADMRemoteStore.this.aquireSurfConfigRef(encpath, false), "*", recurse);
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                finally {
                    res.getWriter().close();
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void listDocuments(final WebScriptResponse res, String store, final String path, final String pattern) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() throws Exception {
                String filePattern;
                res.setContentType("text/plain;charset=UTF-8");
                if (pattern == null || pattern.length() == 0) {
                    filePattern = "*";
                } else {
                    StringBuilder buf = new StringBuilder(pattern.length());
                    StringTokenizer t = new StringTokenizer(pattern, "*");
                    while (t.hasMoreTokens()) {
                        buf.append(BaseRemoteStore.encodePath(t.nextToken()));
                        if (!t.hasMoreTokens()) continue;
                        buf.append('*');
                    }
                    filePattern = buf.toString().replace("\\", "\\\\");
                }
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveNodePath(encpath, filePattern, false, true);
                if (fileInfo == null || !fileInfo.isFolder()) {
                    res.setStatus(404);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("listDocuments() pattern: " + filePattern));
                }
                try {
                    ADMRemoteStore.this.outputFileNodes(res.getWriter(), fileInfo, ADMRemoteStore.this.aquireSurfConfigRef(encpath + "/" + filePattern, false), filePattern, false);
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                finally {
                    res.getWriter().close();
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private FileInfo resolveFilePath(String path) {
        return this.resolveNodePath(path, false, false);
    }

    private FileInfo resolveNodePath(String path, boolean create, boolean isFolder) {
        return this.resolveNodePath(path, null, create, isFolder);
    }

    private FileInfo resolveNodePath(String path, String pattern, boolean create, boolean isFolder) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving path: " + path));
        }
        FileInfo result = null;
        if (path != null) {
            ArrayList<String> pathElements = new ArrayList<String>(4);
            StringTokenizer t = new StringTokenizer(path, "/");
            if (t.countTokens() >= 3) {
                t.nextToken();
                t.nextToken();
                while (t.hasMoreTokens()) {
                    pathElements.add(t.nextToken());
                }
                NodeRef surfConfigRef = this.aquireSurfConfigRef(path + (pattern != null ? "/" + pattern : ""), create);
                try {
                    if (create) {
                        result = FileFolderUtil.makeFolders((FileFolderService)this.fileFolderService, (NodeRef)surfConfigRef, isFolder ? pathElements : pathElements.subList(0, pathElements.size() - 1), (QName)ContentModel.TYPE_FOLDER);
                    } else if (surfConfigRef != null) {
                        result = this.fileFolderService.resolveNamePath(surfConfigRef, pathElements);
                    }
                }
                catch (FileNotFoundException fnfErr) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private NodeRef aquireSurfConfigRef(String path, boolean create) {
        boolean debug = logger.isDebugEnabled();
        String userId = null;
        String siteName = null;
        if (debug) {
            Matcher matcher = USER_PATTERN_1.matcher(path);
            if (matcher.matches()) {
                userId = matcher.group(1);
            } else {
                matcher = USER_PATTERN_2.matcher(path);
                if (matcher.matches()) {
                    userId = matcher.group(1);
                } else {
                    matcher = SITE_PATTERN_1.matcher(path);
                    if (matcher.matches()) {
                        siteName = matcher.group(1);
                    } else {
                        matcher = SITE_PATTERN_2.matcher(path);
                        if (matcher.matches()) {
                            siteName = matcher.group(1);
                        }
                    }
                }
            }
        } else {
            Matcher matcher = SITE_PATTERN_1.matcher(path);
            if (matcher.matches()) {
                siteName = matcher.group(1);
            } else {
                matcher = SITE_PATTERN_2.matcher(path);
                if (matcher.matches()) {
                    siteName = matcher.group(1);
                }
            }
        }
        NodeRef surfConfigRef = null;
        if (siteName != null) {
            NodeRef siteRef;
            if (debug) {
                logger.debug((Object)("...resolved site path id: " + siteName));
            }
            if ((siteRef = this.getSiteNodeRef(siteName)) != null) {
                surfConfigRef = this.getSurfConfigNodeRef(siteRef, create);
            }
        } else {
            if (debug) {
                if (userId != null) {
                    logger.debug((Object)("...resolved user path id: " + userId));
                } else {
                    logger.debug((Object)"...resolved to generic path.");
                }
            }
            surfConfigRef = this.getSurfConfigNodeRef(this.getRootNodeRef(), create);
        }
        return surfConfigRef;
    }

    private NodeRef getSurfConfigNodeRef(NodeRef rootRef) {
        return this.getSurfConfigNodeRef(rootRef, false);
    }

    private NodeRef getSurfConfigNodeRef(NodeRef rootRef, boolean create) {
        NodeRef surfConfigRef = this.unprotNodeService.getChildByName(rootRef, ContentModel.ASSOC_CONTAINS, SURF_CONFIG);
        if (create && surfConfigRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"'surf-config' folder not found under path, creating...");
            }
            QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)SURF_CONFIG);
            HashMap<QName, String> properties = new HashMap<QName, String>(1, 1.0f);
            properties.put(ContentModel.PROP_NAME, SURF_CONFIG);
            ChildAssociationRef ref = this.unprotNodeService.createNode(rootRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, properties);
            surfConfigRef = ref.getChildRef();
            this.hiddenAspect.hideNode(ref.getChildRef());
        }
        return surfConfigRef;
    }

    private NodeRef getRootNodeRef() {
        return this.siteService.getSiteRoot();
    }

    private NodeRef getSiteNodeRef(String shortName) {
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        return siteInfo != null ? siteInfo.getNodeRef() : null;
    }

    private void outputFileNodes(Writer out, FileInfo fileInfo, NodeRef surfConfigRef, String pattern, boolean recurse) throws IOException {
        boolean debug = logger.isDebugEnabled();
        HashMap<NodeRef, String> nameCache = new HashMap<NodeRef, String>();
        PagingResults files = this.fileFolderService.list(fileInfo.getNodeRef(), true, false, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
        for (FileInfo file : files.getPage()) {
            StringBuilder displayPath = new StringBuilder(64);
            NodeRef ref = this.unprotNodeService.getPrimaryParent(file.getNodeRef()).getParentRef();
            while (!ref.equals((Object)surfConfigRef)) {
                String name = (String)nameCache.get(ref);
                if (name == null) {
                    name = (String)((Object)this.unprotNodeService.getProperty(ref, ContentModel.PROP_NAME));
                    nameCache.put(ref, name);
                }
                displayPath.insert(0, '/');
                displayPath.insert(0, name);
                ref = this.unprotNodeService.getPrimaryParent(ref).getParentRef();
            }
            out.write("/alfresco/site-data/");
            out.write(URLDecoder.decode((String)displayPath.toString()));
            out.write(URLDecoder.decode((String)file.getName()));
            out.write(10);
            if (!debug) continue;
            logger.debug((Object)("   /alfresco/site-data/" + displayPath.toString() + file.getName()));
        }
    }
}

