/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketException;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.bean.BaseRemoteStore;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AVMRemoteStore
extends BaseRemoteStore {
    private static final Log logger = LogFactory.getLog(AVMRemoteStore.class);
    private String rootPath = "/";
    private AVMService avmService;
    private SearchService searchService;

    public void setRootPath(String rootPath) {
        if (rootPath == null || rootPath.length() == 0) {
            throw new IllegalArgumentException("Root path must be specified.");
        }
        this.rootPath = rootPath;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    protected void lastModified(WebScriptResponse res, String store, String path) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            throw new WebScriptException("Unable to locate AVM file: " + avmPath);
        }
        Writer out = res.getWriter();
        out.write(Long.toString(desc.getModDate()));
        out.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AVMRemoteStore.lastModified() " + Long.toString(desc.getModDate())));
        }
    }

    @Override
    protected void getDocument(final WebScriptResponse res, String store, final String path) throws IOException {
        final String avmPath = this.buildAVMPath(store, path);
        final AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    ContentReader reader = AVMRemoteStore.this.avmService.getContentReader(-1, avmPath);
                    if (reader == null) {
                        throw new WebScriptException("No content found for AVM file: " + avmPath);
                    }
                    String mimetype = reader.getMimetype();
                    if (mimetype == null || mimetype.length() == 0) {
                        mimetype = "application/octet-stream";
                        int extIndex = path.lastIndexOf(46);
                        if (extIndex != -1) {
                            String ext = path.substring(extIndex + 1);
                            mimetype = AVMRemoteStore.this.mimetypeService.getMimetype(ext);
                        }
                    }
                    res.setContentType(mimetype);
                    res.setContentEncoding(reader.getEncoding());
                    res.setHeader("Last-Modified", Long.toString(desc.getModDate()));
                    res.setHeader("Content-Length", Long.toString(reader.getSize()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.getDocument() " + mimetype + " of size: " + reader.getSize()));
                    }
                    try {
                        reader.getContent(res.getOutputStream());
                    }
                    catch (SocketException e1) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Client aborted stream read:\n\tnode: " + avmPath + "\n\tcontent: " + reader));
                        }
                    }
                    catch (ContentIOException e2) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Client aborted stream read:\n\tnode: " + avmPath + "\n\tcontent: " + reader));
                        }
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                catch (AVMNotFoundException avmErr) {
                    res.setStatus(404);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void hasDocument(WebScriptResponse res, String store, String path) throws IOException {
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        Writer out = res.getWriter();
        out.write(Boolean.toString(desc != null));
        out.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AVMRemoteStore.hasDocument() " + Boolean.toString(desc != null)));
        }
    }

    @Override
    protected void createDocument(final WebScriptResponse res, final String store, final String path, final InputStream content) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String avmPath = AVMRemoteStore.this.buildAVMPath(store, path);
                try {
                    String[] parts = AVMNodeConverter.SplitBase((String)avmPath);
                    String[] dirs = parts[0].split("/");
                    String parentPath = dirs[0] + "/" + dirs[1];
                    for (int index = 2; index < dirs.length; ++index) {
                        String dirPath = parentPath + "/" + dirs[index];
                        if (AVMRemoteStore.this.avmService.lookup(-1, dirPath) == null) {
                            AVMRemoteStore.this.avmService.createDirectory(parentPath, dirs[index]);
                        }
                        parentPath = dirPath;
                    }
                    AVMRemoteStore.this.avmService.createFile(parts[0], parts[1], content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.createDocument() " + avmPath + " of size: " + AVMRemoteStore.this.avmService.lookup(-1, avmPath).getLength()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                catch (AVMExistsException avmErr) {
                    res.setStatus(409);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void createDocuments(final WebScriptResponse res, final String store, final InputStream in) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    HashSet<String> checkedPaths = new HashSet<String>(16);
                    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = documentBuilder.parse(in);
                    Element docEl = document.getDocumentElement();
                    Transformer transformer = (Transformer)AVMRemoteStore.transformer.get();
                    for (Node n = docEl.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (!(n instanceof Element)) continue;
                        String avmPath = AVMRemoteStore.this.buildAVMPath(store, ((Element)n).getAttribute("path"));
                        String[] parts = AVMNodeConverter.SplitBase((String)avmPath);
                        String[] dirs = parts[0].split("/");
                        String parentPath = dirs[0] + "/" + dirs[1];
                        for (int index = 2; index < dirs.length; ++index) {
                            String dirPath = parentPath + "/" + dirs[index];
                            if (!checkedPaths.contains(dirPath)) {
                                if (AVMRemoteStore.this.avmService.lookup(-1, dirPath) == null) {
                                    AVMRemoteStore.this.avmService.createDirectory(parentPath, dirs[index]);
                                }
                                checkedPaths.add(dirPath);
                            }
                            parentPath = dirPath;
                        }
                        Document content = documentBuilder.newDocument();
                        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (!(child instanceof Element)) continue;
                            content.appendChild(content.importNode(child, true));
                            break;
                        }
                        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                        transformer.transform(new DOMSource(content), new StreamResult((OutputStream)out));
                        out.close();
                        AVMRemoteStore.this.avmService.createFile(parts[0], parts[1], (InputStream)new ByteArrayInputStream(out.toByteArray()));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("AVMRemoteStore.createDocument() " + avmPath + " of size: " + AVMRemoteStore.this.avmService.lookup(-1, avmPath).getLength()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                catch (AVMExistsException avmErr) {
                    res.setStatus(409);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void updateDocument(final WebScriptResponse res, String store, String path, final InputStream content) {
        final String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    ContentWriter writer = AVMRemoteStore.this.avmService.getContentWriter(avmPath, true);
                    writer.putContent(content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.updateDocument() " + avmPath + " of size: " + AVMRemoteStore.this.avmService.lookup(-1, avmPath).getLength()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void deleteDocument(final WebScriptResponse res, String store, String path) {
        final String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor desc = this.avmService.lookup(-1, avmPath);
        if (desc == null) {
            res.setStatus(404);
            return;
        }
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    AVMRemoteStore.this.avmService.removeNode(avmPath);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("AVMRemoteStore.deleteDocument() " + avmPath));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void listDocuments(WebScriptResponse res, String store, String path, boolean recurse) throws IOException {
        res.setContentType("text/plain;charset=UTF-8");
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor node = this.avmService.lookup(-1, avmPath);
        if (node == null) {
            res.setStatus(404);
            return;
        }
        try {
            this.traverseNode(res.getWriter(), store, node, recurse);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AVMRemoteStore.listDocuments() " + path + " Recursive: " + recurse));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        finally {
            res.getWriter().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void listDocuments(WebScriptResponse res, String store, String path, String pattern) throws IOException {
        res.setContentType("text/plain;charset=UTF-8");
        String avmPath = this.buildAVMPath(store, path);
        AVMNodeDescriptor node = this.avmService.lookup(-1, avmPath);
        if (node == null) {
            res.setStatus(404);
            return;
        }
        if (pattern == null || pattern.length() == 0) {
            pattern = "*";
        }
        try {
            Writer out = res.getWriter();
            int cropPoint = store.length() + this.rootPath.length() + 1;
            StringBuilder buf = new StringBuilder(pattern.length() + 8);
            StringTokenizer t = new StringTokenizer(pattern, "*");
            while (t.hasMoreTokens()) {
                buf.append(AVMRemoteStore.encodePath(t.nextToken()));
                if (!t.hasMoreTokens()) continue;
                buf.append('*');
            }
            String encpattern = buf.toString().replace("\\", "\\\\");
            boolean encoded = encpattern.length() != pattern.length();
            SortedMap listing = this.avmService.getDirectoryListing(node, encpattern);
            for (AVMNodeDescriptor n : listing.values()) {
                if (!n.isFile()) continue;
                String p = n.getPath().substring(cropPoint);
                out.write(encoded ? URLDecoder.decode((String)p) : p);
                out.write("\n");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AVMRemoteStore.listDocuments() " + path + " Pattern: " + pattern));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
        }
        finally {
            res.getWriter().close();
        }
    }

    private String buildAVMPath(String store, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return store + ":" + this.rootPath + (path != null ? AVMRemoteStore.encodePath(path) : "");
    }

    private void traverseNode(Writer out, String store, AVMNodeDescriptor node, boolean recurse) throws IOException {
        int cropPoint = store.length() + this.rootPath.length() + 1;
        SortedMap listing = this.avmService.getDirectoryListing(node);
        for (AVMNodeDescriptor n : listing.values()) {
            if (n.isFile()) {
                out.write(n.getPath().substring(cropPoint));
                out.write("\n");
                continue;
            }
            if (!recurse || !n.isDirectory()) continue;
            this.traverseNode(out, store, n, recurse);
        }
    }
}

