/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.post;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.blogs.AbstractBlogWebScript;
import org.alfresco.repo.web.scripts.blogs.BlogPostLibJs;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BlogPostGet
extends AbstractBlogWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, BlogPostInfo blog, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (blog == null) {
            throw new WebScriptException(404, "Blog Post Not Found");
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeRef node = blog.getNodeRef();
        Map<String, Object> item = BlogPostLibJs.getBlogPostData(node, this.services);
        model.put("item", item);
        model.put("post", blog);
        model.put("externalBlogConfig", BlogPostLibJs.hasExternalBlogConfiguration(node, this.services));
        int contentLength = -1;
        String arg = req.getParameter("contentLength");
        if (arg != null) {
            try {
                contentLength = Integer.parseInt(arg);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        model.put("contentLength", contentLength);
        return model;
    }
}

