/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.posts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.web.scripts.blogs.AbstractBlogWebScript;
import org.alfresco.repo.web.scripts.blogs.BlogPostLibJs;
import org.alfresco.repo.web.scripts.blogs.posts.BlogPostsNewGet;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.blog.BlogService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractGetBlogWebScript
extends AbstractBlogWebScript {
    private static final Log log = LogFactory.getLog(AbstractGetBlogWebScript.class);

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nonSiteContainer, BlogPostInfo blog, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PagingRequest pagingReq = this.parsePagingParams(req);
        Date fromDate = this.parseDateParam(req, "fromDate");
        Date toDate = this.parseDateParam(req, "toDate");
        String tag = req.getParameter("tag");
        tag = tag == null || tag.length() == 0 ? null : URLDecoder.decode((String)tag);
        if (((Object)((Object)this)).getClass().equals(BlogPostsNewGet.class)) {
            long oneDayInMilliseconds = 86400000L;
            long sevenDaysInMilliseconds = 604800000L;
            fromDate = new Date(System.currentTimeMillis() - 604800000L);
            String numDays = (String)req.getServiceMatch().getTemplateVars().get("numdays");
            if (numDays != null) {
                Integer numDaysInt = Integer.parseInt(numDays);
                fromDate = new Date(System.currentTimeMillis() - (long)numDaysInt.intValue() * 86400000L);
            }
        }
        PagingResults<BlogPostInfo> blogPostList = this.getBlogPostList(site, nonSiteContainer, fromDate, toDate, tag, pagingReq);
        NodeRef container = nonSiteContainer;
        if (container == null) {
            container = site.getNodeRef();
        }
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Retrieved ").append(blogPostList.getPage().size()).append(" blog posts in page.");
            log.debug((Object)msg.toString());
        }
        this.createFtlModel(req, model, container, pagingReq, blogPostList);
        return model;
    }

    protected void createFtlModel(WebScriptRequest req, Map<String, Object> model, NodeRef node, PagingRequest pagingReq, PagingResults<BlogPostInfo> blogPostList) {
        HashMap<String, Object> blogPostsData = new HashMap<String, Object>();
        Pair totalResultCount = blogPostList.getTotalResultCount();
        blogPostsData.put("total", totalResultCount.getFirst());
        blogPostsData.put("pageSize", pagingReq.getMaxItems());
        blogPostsData.put("startIndex", pagingReq.getSkipCount());
        blogPostsData.put("itemCount", blogPostList.getPage().size());
        ArrayList<Map<String, Object>> blogPostDataSets = new ArrayList<Map<String, Object>>(blogPostList.getPage().size());
        for (BlogPostInfo postInfo : blogPostList.getPage()) {
            Map<String, Object> data = BlogPostLibJs.getBlogPostData(postInfo.getNodeRef(), this.services);
            blogPostDataSets.add(data);
        }
        blogPostsData.put("items", blogPostDataSets);
        model.put("data", blogPostsData);
        String contentLengthStr = (String)req.getServiceMatch().getTemplateVars().get("contentLength");
        int contentLength = contentLengthStr == null ? -1 : Integer.parseInt(contentLengthStr);
        model.put("contentLength", contentLength);
        model.put("blog", node);
        model.put("externalBlogConfig", BlogPostLibJs.hasExternalBlogConfiguration(node, this.services));
    }

    private PagingRequest parsePagingParams(WebScriptRequest req) {
        return ScriptPagingDetails.buildPagingRequest((WebScriptRequest)req, (int)1000);
    }

    private Date parseDateParam(WebScriptRequest req, String paramName) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String dateStr = (String)templateVars.get(paramName);
        if (dateStr == null) {
            dateStr = req.getParameter(paramName);
        }
        Date result = null;
        if (dateStr != null) {
            result = new Date(Long.parseLong(dateStr));
        }
        return result;
    }

    private PagingResults<BlogPostInfo> getBlogPostList(SiteInfo site, NodeRef nonSiteContainer, Date fromDate, Date toDate, String tag, PagingRequest pagingReq) {
        if (tag == null || tag.trim().isEmpty()) {
            return this.getBlogResultsImpl(site, nonSiteContainer, fromDate, toDate, pagingReq);
        }
        BlogService.RangedDateProperty dateRange = new BlogService.RangedDateProperty(fromDate, toDate, ContentModel.PROP_CREATED);
        if (site != null) {
            return this.blogService.findBlogPosts(site.getShortName(), dateRange, tag, pagingReq);
        }
        return this.blogService.findBlogPosts(nonSiteContainer, dateRange, tag, pagingReq);
    }

    protected abstract PagingResults<BlogPostInfo> getBlogResultsImpl(SiteInfo var1, NodeRef var2, Date var3, Date var4, PagingRequest var5);
}

