/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.posts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.blogs.AbstractBlogWebScript;
import org.alfresco.repo.web.scripts.blogs.BlogPostLibJs;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BlogPostsPost
extends AbstractBlogWebScript {
    private static final Log log = LogFactory.getLog(BlogPostsPost.class);
    private TaggingService taggingService;

    public void setTaggingService(TaggingService taggingService) {
        this.taggingService = taggingService;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, BlogPostInfo blog, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        boolean isDraft;
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (site == null && nodeRef != null) {
            this.ensureTagScope(nodeRef);
        }
        JsonParams jsonPostParams = this.parsePostParams(json);
        BlogPostInfo post = this.createBlogPost(jsonPostParams, site, nodeRef);
        Map<String, Object> blogPostData = BlogPostLibJs.getBlogPostData(post.getNodeRef(), this.services);
        model.put("item", blogPostData);
        model.put("externalBlogConfig", BlogPostLibJs.hasExternalBlogConfiguration(nodeRef, this.services));
        boolean bl = isDraft = blogPostData.get("item") != null && (Boolean)blogPostData.get("item") != false;
        if (jsonPostParams.getSite() != null && jsonPostParams.getContainer() != null && jsonPostParams.getPage() != null && !isDraft) {
            this.addActivityEntry("created", post, site, req, json, nodeRef);
        }
        return model;
    }

    private JsonParams parsePostParams(JSONObject json) {
        JsonParams result = new JsonParams();
        if (json.containsKey((Object)"title")) {
            result.setTitle((String)json.get((Object)"title"));
        }
        if (json.containsKey((Object)"content")) {
            result.setContent((String)json.get((Object)"content"));
        }
        if (json.containsKey((Object)"draft")) {
            Object draft = json.get((Object)"draft");
            if (draft instanceof Boolean) {
                result.setIsDraft((Boolean)draft);
            } else {
                result.setIsDraft(Boolean.parseBoolean((String)draft));
            }
        }
        if (json.containsKey((Object)"tags")) {
            Object tagsObj = json.get((Object)"tags");
            ArrayList<String> tags = new ArrayList<String>();
            if (tagsObj instanceof JSONArray) {
                JSONArray tagsJsonArray = (JSONArray)tagsObj;
                for (int i = 0; i < tagsJsonArray.size(); ++i) {
                    tags.add((String)tagsJsonArray.get(i));
                }
            } else {
                tags.add(tagsObj.toString());
            }
            result.setTags(tags);
        }
        if (json.containsKey((Object)"site")) {
            result.setSite((String)json.get((Object)"site"));
        }
        if (json.containsKey((Object)"page")) {
            result.setPage((String)json.get((Object)"page"));
        }
        if (json.containsKey((Object)"container")) {
            result.setContainer((String)json.get((Object)"container"));
        }
        return result;
    }

    private void ensureTagScope(NodeRef node) {
        NodeRef parent;
        if (!this.taggingService.isTagScope(node)) {
            this.taggingService.addTagScope(node);
        }
        if (!this.taggingService.isTagScope(parent = this.nodeService.getPrimaryParent(node).getParentRef())) {
            this.taggingService.addTagScope(parent);
        }
    }

    private BlogPostInfo createBlogPost(JsonParams jsonParams, SiteInfo site, NodeRef blogNode) {
        String titleParam = jsonParams.getTitle() == null ? "" : jsonParams.getTitle();
        String contentParam = jsonParams.getContent() == null ? "" : jsonParams.getContent();
        boolean isDraftParam = jsonParams.getIsDraft();
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating blog-post '").append(titleParam).append("'");
            if (isDraftParam) {
                msg.append(" DRAFT");
            }
            log.debug((Object)msg.toString());
        }
        ArrayList<String> tagsParam = new ArrayList<String>();
        if (jsonParams.getTags() != null) {
            tagsParam.addAll(jsonParams.getTags());
        }
        BlogPostInfo newPostNode = site != null ? this.blogService.createBlogPost(site.getShortName(), titleParam, contentParam, isDraftParam) : this.blogService.createBlogPost(blogNode, titleParam, contentParam, isDraftParam);
        ArrayList<String> nonEmptyTags = new ArrayList<String>();
        for (String tag : tagsParam) {
            if (tag.trim().isEmpty()) continue;
            nonEmptyTags.add(tag);
        }
        if (!nonEmptyTags.isEmpty()) {
            this.taggingService.setTags(newPostNode.getNodeRef(), nonEmptyTags);
        }
        return newPostNode;
    }

    class JsonParams {
        private String title;
        private String content;
        private boolean isDraft = false;
        private List<String> tags;
        private String site;
        private String container;
        private String page;

        JsonParams() {
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean getIsDraft() {
            return this.isDraft;
        }

        public void setIsDraft(boolean isDraft) {
            this.isDraft = isDraft;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public void setTags(List<String> tags) {
            this.tags = tags;
        }

        public String getSite() {
            return this.site;
        }

        public void setSite(String site) {
            this.site = site;
        }

        public String getContainer() {
            return this.container;
        }

        public void setContainer(String container) {
            this.container = container;
        }

        public String getPage() {
            return this.page;
        }

        public void setPage(String page) {
            this.page = page;
        }
    }
}

