/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bulkimport.copy;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.bulkimport.impl.StreamingNodeImporterFactory;
import org.alfresco.repo.web.scripts.bulkimport.AbstractBulkFileSystemImportWebScript;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BulkFilesystemImportWebScript
extends AbstractBulkFileSystemImportWebScript {
    private MultiThreadedBulkFilesystemImporter bulkImporter;
    private StreamingNodeImporterFactory nodeImporterFactory;

    public void setBulkImporter(MultiThreadedBulkFilesystemImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public void setNodeImporterFactory(StreamingNodeImporterFactory nodeImporterFactory) {
        this.nodeImporterFactory = nodeImporterFactory;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        HashMap<String, Object> model;
        block17: {
            model = new HashMap<String, Object>();
            String targetNodeRefStr = null;
            String targetPath = null;
            String sourceDirectoryStr = null;
            String replaceExistingStr = null;
            String batchSizeStr = null;
            String numThreadsStr = null;
            String disableRulesStr = null;
            cache.setNeverCache(true);
            try {
                if (!this.bulkImporter.getStatus().inProgress()) {
                    NodeRef targetNodeRef = null;
                    File sourceDirectory = null;
                    boolean replaceExisting = false;
                    int batchSize = this.bulkImporter.getDefaultBatchSize();
                    int numThreads = this.bulkImporter.getDefaultNumThreads();
                    boolean disableRules = false;
                    targetNodeRefStr = request.getParameter("targetNodeRef");
                    targetPath = request.getParameter("targetPath");
                    sourceDirectoryStr = request.getParameter("sourceDirectory");
                    replaceExistingStr = request.getParameter("replaceExisting");
                    batchSizeStr = request.getParameter("batchSize");
                    numThreadsStr = request.getParameter("numThreads");
                    disableRulesStr = request.getParameter("disableRules");
                    targetNodeRef = this.getTargetNodeRef(targetNodeRefStr, targetPath);
                    if (sourceDirectoryStr == null || sourceDirectoryStr.trim().length() == 0) {
                        throw new RuntimeException("Error: mandatory parameter 'sourceDirectory' was not provided.");
                    }
                    sourceDirectory = new File(sourceDirectoryStr.trim());
                    if (replaceExistingStr != null && replaceExistingStr.trim().length() > 0) {
                        replaceExisting = "replaceExisting".equals(replaceExistingStr);
                    }
                    if (disableRulesStr != null && disableRulesStr.trim().length() > 0) {
                        disableRules = "disableRules".equals(disableRulesStr);
                    }
                    NodeImporter nodeImporter = this.nodeImporterFactory.getNodeImporter(sourceDirectory);
                    BulkImportParameters bulkImportParameters = new BulkImportParameters();
                    if (numThreadsStr != null && numThreadsStr.trim().length() > 0) {
                        try {
                            numThreads = Integer.parseInt(numThreadsStr);
                            if (numThreads < 1) {
                                throw new RuntimeException("Error: parameter 'numThreads' must be an integer > 0.");
                            }
                            bulkImportParameters.setNumThreads(Integer.valueOf(numThreads));
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Error: parameter 'numThreads' must be an integer > 0.");
                        }
                    }
                    if (batchSizeStr != null && batchSizeStr.trim().length() > 0) {
                        try {
                            batchSize = Integer.parseInt(batchSizeStr);
                            if (batchSize < 1) {
                                throw new RuntimeException("Error: parameter 'batchSize' must be an integer > 0.");
                            }
                            bulkImportParameters.setBatchSize(Integer.valueOf(batchSize));
                        }
                        catch (NumberFormatException e) {
                            throw new RuntimeException("Error: parameter 'batchSize' must be an integer > 0.");
                        }
                    }
                    bulkImportParameters.setReplaceExisting(replaceExisting);
                    bulkImportParameters.setTarget(targetNodeRef);
                    bulkImportParameters.setDisableRulesService(disableRules);
                    this.bulkImporter.asyncBulkImport(bulkImportParameters, nodeImporter);
                    status.setCode(302);
                    status.setRedirect(true);
                    status.setLocation(request.getServiceContextPath() + "/bulkfsimport/status");
                    break block17;
                }
                model.put("importInProgress", I18NUtil.getMessage((String)"bfsit.error.importAlreadyInProgress"));
            }
            catch (WebScriptException wse) {
                status.setCode(400, wse.getMessage());
                status.setRedirect(true);
            }
            catch (FileNotFoundException fnfe) {
                status.setCode(400, "The repository path '" + targetPath + "' does not exist !");
                status.setRedirect(true);
            }
            catch (IllegalArgumentException iae) {
                status.setCode(400, iae.getMessage());
                status.setRedirect(true);
            }
            catch (Throwable t) {
                throw new WebScriptException(500, this.buildTextMessage(t), t);
            }
        }
        return model;
    }
}

