/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.json.JSONWriter;

public abstract class AbstractCalendarWebScript
extends DeclarativeWebScript {
    private static final String ALL_DAY_DATETIME_PATTERN = "yyyy-MM-dd'T00:00:00.000'";
    private static final DateTimeFormatter ALL_DAY_DATETIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T00:00:00.000'");
    public static final String CALENDAR_SERVICE_ACTIVITY_APP_NAME = "calendar";
    protected static final String MSG_EVENT_NOT_FOUND = "calendar.err.event.not.found";
    protected static final String MSG_INVALID_JSON = "calendar.err.invalid.json";
    protected static final String PARAM_TIMEZONE = "timeZone";
    protected static final String PARAM_START_AT = "startAt";
    protected static final String PARAM_END_AT = "endAt";
    protected static final String PARAM_ISO8601 = "iso8601";
    private static Log logger = LogFactory.getLog(AbstractCalendarWebScript.class);
    protected static final int MAX_QUERY_ENTRY_COUNT = 1000;
    protected NodeService nodeService;
    protected SiteService siteService;
    protected ActivityService activityService;
    protected CalendarService calendarService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setCalendarService(CalendarService calendarService) {
        this.calendarService = calendarService;
    }

    protected Date parseDate(String date) {
        if (date == null || date.length() == 0) {
            return null;
        }
        if (date.equalsIgnoreCase("NOW")) {
            Calendar c = Calendar.getInstance();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return c.getTime();
        }
        try {
            return ISO8601DateFormat.parse((String)date);
        }
        catch (Exception e) {
            SimpleDateFormat slashtime = new SimpleDateFormat("yyyy/MM/dd HH:mm");
            SimpleDateFormat slash = new SimpleDateFormat("yyyy/MM/dd");
            try {
                return slashtime.parse(date);
            }
            catch (java.text.ParseException e2) {
                try {
                    return slash.parse(date);
                }
                catch (java.text.ParseException e3) {
                    SimpleDateFormat dashtime = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    SimpleDateFormat dash = new SimpleDateFormat("yyyy-MM-dd");
                    try {
                        return dashtime.parse(date);
                    }
                    catch (java.text.ParseException e4) {
                        try {
                            return dash.parse(date);
                        }
                        catch (java.text.ParseException e5) {
                            throw new WebScriptException(400, "Invalid date '" + date + "'");
                        }
                    }
                }
            }
        }
    }

    protected boolean extractDates(CalendarEntry entry, JSONObject json) throws JSONException {
        boolean isAllDay = false;
        if (json.containsKey((Object)"allday")) {
            isAllDay = true;
        }
        if (json.containsKey((Object)PARAM_START_AT) && json.containsKey((Object)PARAM_END_AT)) {
            String endAt;
            String startAt;
            Object startAtO = json.get((Object)PARAM_START_AT);
            Object endAtO = json.get((Object)PARAM_END_AT);
            String timezoneName = null;
            if (startAtO instanceof JSONObject) {
                JSONObject startAtJSON = (JSONObject)startAtO;
                JSONObject endAtJSON = (JSONObject)endAtO;
                startAt = (String)startAtJSON.get((Object)PARAM_ISO8601);
                endAt = (String)endAtJSON.get((Object)PARAM_ISO8601);
                if (startAtJSON.containsKey((Object)PARAM_TIMEZONE)) {
                    String endTZ;
                    timezoneName = (String)startAtJSON.get((Object)PARAM_TIMEZONE);
                    if (endAtJSON.containsKey((Object)PARAM_TIMEZONE) && !(endTZ = (String)endAtJSON.get((Object)PARAM_TIMEZONE)).equals(timezoneName)) {
                        throw new WebScriptException(400, "Timezones must match");
                    }
                }
            } else {
                startAt = (String)json.get((Object)PARAM_START_AT);
                endAt = (String)json.get((Object)PARAM_END_AT);
            }
            if (json.containsKey((Object)PARAM_TIMEZONE)) {
                timezoneName = (String)json.get((Object)PARAM_TIMEZONE);
            }
            if (json.containsKey((Object)"allday")) {
                String utcMidnight = "T00:00:00Z";
                startAt = startAt.substring(0, 10) + utcMidnight;
                endAt = endAt.substring(0, 10) + utcMidnight;
                entry.setStart(ISO8601DateFormat.parse((String)startAt));
                entry.setEnd(ISO8601DateFormat.parse((String)endAt));
            } else if (timezoneName != null) {
                TimeZone tz = TimeZone.getTimeZone(timezoneName);
                entry.setStart(ISO8601DateFormat.parse((String)startAt, (TimeZone)tz));
                entry.setEnd(ISO8601DateFormat.parse((String)endAt, (TimeZone)tz));
            } else {
                entry.setStart(this.parseDate(startAt));
                entry.setEnd(this.parseDate(endAt));
            }
        } else if (json.containsKey((Object)"allday")) {
            Date start = this.parseDate(this.getOrNull(json, "from"));
            Date end = this.parseDate(this.getOrNull(json, "to"));
            String isoStartAt = ISO8601DateFormat.format((Date)start);
            String isoEndAt = ISO8601DateFormat.format((Date)end);
            String utcMidnight = "T00:00:00Z";
            isoStartAt = isoStartAt.substring(0, 10) + utcMidnight;
            isoEndAt = isoEndAt.substring(0, 10) + utcMidnight;
            entry.setStart(ISO8601DateFormat.parse((String)isoStartAt));
            entry.setEnd(ISO8601DateFormat.parse((String)isoEndAt));
        } else {
            entry.setStart(this.parseDate((String)json.get((Object)"from") + " " + (String)json.get((Object)"start")));
            entry.setEnd(this.parseDate((String)json.get((Object)"to") + " " + (String)json.get((Object)"end")));
        }
        return isAllDay;
    }

    protected String getOrNull(JSONObject json, String key) throws JSONException {
        if (json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        return null;
    }

    protected PagingRequest buildPagingRequest(WebScriptRequest req) {
        return new ScriptPagingDetails(req, 1000);
    }

    protected boolean useJSONErrors() {
        return true;
    }

    protected Map<String, Object> buildError(String message) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", message);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("error", message);
        model.put("result", result);
        return model;
    }

    protected String addActivityEntry(String event, CalendarEntry entry, SiteInfo site, WebScriptRequest req, JSONObject json) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        String dateOpt = "?date=" + fmt.format(entry.getStart());
        String page = req.getParameter("page");
        if (page == null && json != null && json.containsKey((Object)"page")) {
            page = (String)json.get((Object)"page");
        }
        if (page == null) {
            page = CALENDAR_SERVICE_ACTIVITY_APP_NAME;
        }
        try {
            StringWriter activityJson = new StringWriter();
            JSONWriter activity = new JSONWriter((Writer)activityJson);
            activity.startObject();
            activity.writeValue("title", entry.getTitle());
            activity.writeValue("page", page + dateOpt);
            activity.endObject();
            this.activityService.postActivity("org.alfresco.calendar.event-" + event, site.getShortName(), CALENDAR_SERVICE_ACTIVITY_APP_NAME, activityJson.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Error adding event " + event + " to activities feed"), (Throwable)e);
        }
        return dateOpt;
    }

    protected NodeRef createIgnoreEvent(WebScriptRequest req, CalendarEntry parent) {
        HashMap<QName, Date> props = new HashMap<QName, Date>();
        Date date = this.parseDate(req.getParameter("date"));
        props.put(CalendarModel.PROP_IGNORE_EVENT_DATE, date);
        NodeRef ignored = this.nodeService.createNode(parent.getNodeRef(), CalendarModel.ASSOC_IGNORE_EVENT_LIST, QName.createQName((String)GUID.generate()), CalendarModel.TYPE_IGNORE_EVENT, props).getChildRef();
        return ignored;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String siteName;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            if (this.useJSONErrors()) {
                return this.buildError(error);
            }
            throw new WebScriptException(400, error);
        }
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException io) {
                return this.buildError("Invalid JSON: " + io.getMessage());
            }
            catch (ParseException je) {
                return this.buildError("Invalid JSON: " + je.getMessage());
            }
        }
        if ((siteName = (String)templateVars.get("siteid")) == null) {
            siteName = (String)templateVars.get("site");
        }
        if (siteName == null) {
            siteName = req.getParameter("site");
        }
        if (siteName == null && json != null) {
            if (json.containsKey((Object)"siteid")) {
                siteName = (String)json.get((Object)"siteid");
            } else if (json.containsKey((Object)"site")) {
                siteName = (String)json.get((Object)"site");
            }
        }
        if (siteName == null) {
            String error = "No site given";
            if (this.useJSONErrors()) {
                return this.buildError("No site given");
            }
            throw new WebScriptException(400, error);
        }
        SiteInfo site = this.siteService.getSite(siteName);
        if (site == null) {
            String error = "Could not find site: " + siteName;
            if (this.useJSONErrors()) {
                return this.buildError(error);
            }
            throw new WebScriptException(404, error);
        }
        String eventName = (String)templateVars.get("eventname");
        return this.executeImpl(site, eventName, req, json, status, cache);
    }

    protected String removeTimeZoneIfRequired(Date date, Boolean isAllDay, Boolean removeTimezone) {
        return this.removeTimeZoneIfRequired(date, isAllDay, removeTimezone, null);
    }

    protected String removeTimeZoneIfRequired(Date date, Boolean isAllDay, Boolean removeTimezone, String datePattern) {
        if (removeTimezone.booleanValue()) {
            DateTime dateTime = new DateTime((Object)date, DateTimeZone.UTC);
            if (null == datePattern) {
                return dateTime.toString(isAllDay != false ? ALL_DAY_DATETIME_FORMATTER : ISODateTimeFormat.dateTime());
            }
            return dateTime.toString(DateTimeFormat.forPattern((String)datePattern));
        }
        if (!isAllDay.booleanValue() && null == datePattern) {
            return ISO8601DateFormat.format((Date)date);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(null != datePattern ? datePattern : ALL_DAY_DATETIME_PATTERN);
        return simpleDateFormat.format(date);
    }

    protected abstract Map<String, Object> executeImpl(SiteInfo var1, String var2, WebScriptRequest var3, JSONObject var4, Status var5, Cache var6);
}

