/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarListingWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.QNamePattern;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CalendarEntriesListGet
extends AbstractCalendarListingWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        Date fromDate = this.parseDate(req.getParameter("from"));
        Date toDate = this.parseDate(req.getParameter("to"));
        boolean resortNeeded = false;
        boolean repeatingFirstOnly = true;
        String repeatingEvents = req.getParameter("repeating");
        if (repeatingEvents != null) {
            if ("first".equals(repeatingEvents)) {
                repeatingFirstOnly = true;
            } else if ("all".equals(repeatingEvents)) {
                repeatingFirstOnly = false;
                resortNeeded = true;
            }
        }
        PagingRequest paging = this.buildPagingRequest(req);
        PagingResults entries = this.calendarService.listCalendarEntries(new String[]{site.getShortName()}, fromDate, toDate, paging);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (CalendarEntry entry : entries.getPage()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("event", entry);
            result.put("name", entry.getSystemName());
            result.put("title", entry.getTitle());
            boolean isAllDay = CalendarEntryDTO.isAllDay((CalendarEntry)entry);
            boolean removeTimezone = isAllDay && !entry.isOutlook();
            result.put("start", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone));
            result.put("end", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone));
            String legacyDateFormat = "M/d/yyyy";
            String legacyTimeFormat = "HH:mm";
            result.put("legacyDateFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyDateFormat));
            result.put("legacyTimeFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyTimeFormat));
            result.put("legacyDateTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyDateFormat));
            result.put("legacyTimeTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyTimeFormat));
            result.put("fromDate", entry.getStart());
            result.put("tags", entry.getTags());
            List ignores = this.nodeService.getChildAssocs(entry.getNodeRef(), (QNamePattern)CalendarModel.TYPE_IGNORE_EVENT, (QNamePattern)ContentModel.ASSOC_CONTAINS, true);
            ArrayList<String> ignoreEvents = new ArrayList<String>();
            ArrayList<Date> ignoreEventDates = new ArrayList<Date>();
            for (ChildAssociationRef ref : ignores) {
                Date date = (Date)this.nodeService.getProperty(ref.getChildRef(), CalendarModel.PROP_IGNORE_EVENT_DATE);
                if (date == null) continue;
                ignoreEventDates.add(date);
                ignoreEvents.add(formatter.format(date));
            }
            result.put("ignoreEvents", ignoreEvents);
            result.put("ignoreEventDates", ignoreEventDates);
            boolean orderChanged = this.handleRecurring(entry, result, results, fromDate, toDate, repeatingFirstOnly);
            if (orderChanged) {
                resortNeeded = true;
            }
            results.add(result);
        }
        if (resortNeeded) {
            Collections.sort(results, CalendarEntriesListGet.getEventDetailsSorter());
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("events", results);
        model.put("siteId", site.getShortName());
        model.put("site", site);
        return model;
    }
}

