/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.alfresco.repo.web.scripts.calendar.AbstractCalendarWebScript;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.calendar.CalendarRecurrenceHelper;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CalendarEntryGet
extends AbstractCalendarWebScript {
    private static Log logger = LogFactory.getLog(CalendarEntryGet.class);
    private PermissionService permissionService;

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String eventName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        CalendarEntry entry = this.calendarService.getCalendarEntry(site.getShortName(), eventName);
        if (entry == null) {
            String message = rb.getString("calendar.err.event.not.found");
            return this.buildError(MessageFormat.format(message, eventName));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", entry.getSystemName());
        result.put("what", entry.getTitle());
        result.put("description", entry.getDescription());
        result.put("location", entry.getLocation());
        boolean isAllDay = CalendarEntryDTO.isAllDay((CalendarEntry)entry);
        boolean removeTimezone = isAllDay && !entry.isOutlook();
        result.put("from", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone));
        result.put("to", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone));
        String legacyDateFormat = "M/d/yyyy";
        String legacyTimeFormat = "HH:mm";
        result.put("legacyDateFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyDateFormat));
        result.put("legacyTimeFrom", this.removeTimeZoneIfRequired(entry.getStart(), isAllDay, removeTimezone, legacyTimeFormat));
        result.put("legacyDateTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyDateFormat));
        result.put("legacyTimeTo", this.removeTimeZoneIfRequired(entry.getEnd(), isAllDay, removeTimezone, legacyTimeFormat));
        result.put("tags", entry.getTags());
        result.put("isoutlook", entry.isOutlook());
        result.put("outlookuid", entry.getOutlookUID());
        result.put("allday", isAllDay);
        result.put("docfolder", entry.getSharePointDocFolder());
        result.put("recurrence", this.buildRecurrenceString(entry));
        for (String key : result.keySet()) {
            if (result.get(key) != null) continue;
            result.put(key, "");
        }
        AccessStatus canEdit = this.permissionService.hasPermission(entry.getNodeRef(), "Write");
        AccessStatus canDelete = this.permissionService.hasPermission(entry.getNodeRef(), "Delete");
        result.put("canEdit", canEdit == AccessStatus.ALLOWED);
        result.put("canDelete", canDelete == AccessStatus.ALLOWED);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("result", result);
        return model;
    }

    protected String buildRecurrenceString(CalendarEntry event) {
        String recurrence = event.getRecurrenceRule();
        if (recurrence == null || recurrence.trim().length() == 0) {
            return null;
        }
        Map days = CalendarRecurrenceHelper.buildLocalRecurrenceDaysOfTheWeek((Locale)I18NUtil.getLocale());
        Map weeks = CalendarRecurrenceHelper.buildLocalRecurrenceWeekNames((Locale)I18NUtil.getLocale());
        Map params = CalendarRecurrenceHelper.extractRecurrenceRule((CalendarEntry)event);
        StringBuffer text = new StringBuffer();
        if (params.containsKey("FREQ")) {
            String freq = (String)params.get("FREQ");
            String interval = (String)params.get("INTERVAL");
            if (interval == null) {
                interval = "1";
            }
            if ("WEEKLY".equals(freq)) {
                if ("1".equals(interval)) {
                    text.append("Occurs each week on ");
                } else {
                    text.append("Occurs every " + interval + " weeks on ");
                }
                for (String day : ((String)params.get("BYDAY")).split(",")) {
                    text.append((String)days.get(day));
                    text.append(", ");
                }
            } else if ("DAILY".equals(freq)) {
                if ("1".equals(interval)) {
                    text.append("Occurs every day ");
                } else {
                    text.append("Occurs every " + interval + " days ");
                }
            } else if ("MONTHLY".equals(freq)) {
                if (params.get("BYMONTHDAY") != null) {
                    text.append("Occurs day " + (String)params.get("BYMONTHDAY"));
                } else if (params.get("BYSETPOS") != null) {
                    text.append("Occurs the ");
                    text.append((String)weeks.get(Integer.parseInt((String)params.get("BYSETPOS"))) + " ");
                    text.append((String)days.get(params.get("BYDAY")));
                }
                text.append(" of every " + interval + " month(s) ");
            } else if ("YEARLY".equals(freq)) {
                if (params.get("BYMONTHDAY") != null) {
                    text.append("Occurs every " + (String)params.get("BYMONTHDAY"));
                    text.append("." + (String)params.get("BYMONTH") + " ");
                } else {
                    text.append("Occurs the ");
                    text.append((String)weeks.get(Integer.parseInt((String)params.get("BYSETPOS"))) + " ");
                    text.append((String)days.get(params.get("BYDAY")) + " ");
                    text.append(" of " + (String)params.get("BYMONTH") + " month ");
                }
            } else {
                logger.warn((Object)("Unsupported recurrence frequency " + freq));
            }
        }
        DateFormat dFormat = SimpleDateFormat.getDateInstance(2, I18NUtil.getLocale());
        DateFormat tFormat = SimpleDateFormat.getTimeInstance(3, I18NUtil.getLocale());
        text.append("effective " + dFormat.format(event.getStart()));
        if (params.containsKey("COUNT")) {
            // empty if block
        }
        if (event.getLastRecurrence() != null) {
            text.append(" until " + dFormat.format(event.getLastRecurrence()));
        }
        text.append(" from " + tFormat.format(event.getStart()));
        text.append(" to " + tFormat.format(event.getEnd()));
        TimeZone timeZone = TimeZone.getDefault();
        boolean daylight = timeZone.inDaylightTime(new Date());
        String tzDisplayName = timeZone.getDisplayName(daylight, 0);
        text.append(" (" + tzDisplayName + ")");
        return text.toString();
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

