/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.calendar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class CalendarRestApiTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(CalendarRestApiTest.class);
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PermissionService permissionService;
    private PersonService personService;
    private NodeService nodeService;
    private SiteService siteService;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String USER_THREE = "UserThreeSecondToo";
    private static final String USER_FOUR = "UserFourSecondToo";
    private static final String SITE_SHORT_NAME_CALENDAR = "CalendarSiteShortNameTest";
    private static final String EVENT_TITLE_ONE = "TestEventOne";
    private static final String EVENT_TITLE_TWO = "TestEventTwo";
    private static final String EVENT_TITLE_THREE = "TestEventThree";
    private static final String URL_EVENT_BASE = "/calendar/event/CalendarSiteShortNameTest/";
    private static final String URL_EVENTS_LIST = "/calendar/eventList";
    private static final String URL_EVENTS_LIST_ICS = "/calendar/eventList-CalendarSiteShortNameTest.ics?format=calendar";
    private static final String URL_EVENT_CREATE = "/calendar/create";
    private static final String URL_USER_EVENTS_LIST = "/calendar/events/user";
    private static final String URL_USER_SITE_EVENTS_LIST = "/calendar/events/CalendarSiteShortNameTest/user";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.permissionService = (PermissionService)this.getServer().getApplicationContext().getBean("PermissionService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_CALENDAR);
        if (siteInfo == null) {
            this.siteService.createSite("CalendarSitePreset", SITE_SHORT_NAME_CALENDAR, "CalendarSiteTitle", "BlogSiteDescription", SiteVisibility.PUBLIC);
        }
        if (!this.siteService.hasContainer(SITE_SHORT_NAME_CALENDAR, "calendar")) {
            this.siteService.createContainer(SITE_SHORT_NAME_CALENDAR, "calendar", null, null);
        }
        this.createUser(USER_ONE, "SiteCollaborator");
        this.createUser(USER_TWO, "SiteCollaborator");
        this.createUser(USER_THREE, "SiteContributor");
        this.createUser(USER_FOUR, "SiteConsumer");
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.siteService.deleteSite(SITE_SHORT_NAME_CALENDAR);
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteUser(USER_FOUR);
    }

    private void createUser(String userName, String role) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        this.siteService.setMembership(SITE_SHORT_NAME_CALENDAR, userName, role);
    }

    private void deleteUser(String userName) {
        this.personService.deletePerson(userName);
        if (this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.deleteAuthentication(userName);
        }
    }

    private JSONObject validateAndParseJSON(String json) throws Exception {
        return new JSONObject(json);
    }

    private JSONObject getEntries(String username, String from) throws Exception {
        String url = "/calendar/eventList?site=CalendarSiteShortNameTest";
        if (username != null) {
            url = URL_USER_SITE_EVENTS_LIST;
        }
        if (from != null) {
            url = url.indexOf(63) > 0 ? url + "&" : url + "?";
            url = url + "from=" + from;
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject result = this.validateAndParseJSON(response.getContentAsString());
        return result;
    }

    private JSONObject getEntry(String name, int expectedStatus) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_EVENT_BASE + name), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = this.validateAndParseJSON(response.getContentAsString());
            return result;
        }
        return null;
    }

    private JSONObject createEntry(String name, String where, String description, int expectedStatus) throws Exception {
        String date = "2011-06-29";
        String start = "12:00";
        String end = "13:00";
        JSONObject json = new JSONObject();
        json.put("startAt", (Object)(date + "T" + start + ":00+01:00"));
        json.put("endAt", (Object)(date + "T" + end + ":00+01:00"));
        return this.createEntry(name, where, description, json, expectedStatus);
    }

    private JSONObject createAllDayEntryDifferentTimeZone(String name, String where, String description, int expectedStatus) throws Exception {
        String date = "2011-06-29";
        String start = "00:00";
        String end = "00:00";
        JSONObject json = new JSONObject();
        json.put("startAt", (Object)(date + "T" + start + ":00+04:00"));
        json.put("endAt", (Object)(date + "T" + end + ":00+04:00"));
        json.put("allday", (Object)Boolean.TRUE);
        return this.createEntry(name, where, description, json, expectedStatus);
    }

    private JSONObject createAllDayEntry(String name, String where, String description, int expectedStatus) throws Exception {
        String date = "2011-06-29";
        String start = "00:00";
        String end = "00:00";
        JSONObject json = new JSONObject();
        json.put("startAt", (Object)(date + "T" + start + ":00+01:00"));
        json.put("endAt", (Object)(date + "T" + end + ":00+01:00"));
        json.put("allday", (Object)Boolean.TRUE);
        return this.createEntry(name, where, description, json, expectedStatus);
    }

    private JSONObject createMultiAllDayEntry(String name, String where, String description, int expectedStatus) throws Exception {
        String startDate = "2011-06-27";
        String endDate = "2011-06-29";
        String time = "00:00";
        JSONObject json = new JSONObject();
        json.put("startAt", (Object)(startDate + "T" + time + ":00+00:00"));
        json.put("endAt", (Object)(endDate + "T" + time + ":00+00:00"));
        json.put("allday", (Object)Boolean.TRUE);
        return this.createEntry(name, where, description, json, expectedStatus);
    }

    private JSONObject createEntry(String name, String where, String description, JSONObject datesJSON, int expectedStatus) throws Exception {
        JSONObject json = new JSONObject();
        json.put("site", (Object)SITE_SHORT_NAME_CALENDAR);
        json.put("what", (Object)name);
        json.put("where", (Object)where);
        json.put("desc", (Object)description);
        json.put("tags", (Object)"");
        json.put("docfolder", (Object)"");
        json.put("page", (Object)"calendar");
        for (String key : this.getKeys(datesJSON, false)) {
            json.put(key, datesJSON.get(key));
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_EVENT_CREATE, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = this.validateAndParseJSON(response.getContentAsString());
            if (result.has("event")) {
                return result.getJSONObject("event");
            }
            return result;
        }
        return null;
    }

    private JSONObject updateEntry(String name, String what, String where, String description, boolean withRecurrence, int expectedStatus) throws Exception {
        String date = "2011/06/28";
        String start = "11:30";
        String end = "13:30";
        JSONObject json = new JSONObject();
        json.put("what", (Object)what);
        json.put("where", (Object)where);
        json.put("desc", (Object)description);
        json.put("from", (Object)date);
        json.put("to", (Object)date);
        json.put("start", (Object)start);
        json.put("end", (Object)end);
        json.put("tags", (Object)"");
        json.put("docfolder", (Object)"");
        json.put("page", (Object)"calendar");
        if (withRecurrence) {
            json.put("recurrenceRule", (Object)"FREQ=WEEKLY;INTERVAL=2;BYDAY=WE,FR");
            json.put("recurrenceLastMeeting", (Object)"2011-09-11");
        }
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_EVENT_BASE + name, json.toString(), "application/json"), expectedStatus);
        if (expectedStatus == 200) {
            JSONObject result = this.validateAndParseJSON(response.getContentAsString());
            if (result.has("event")) {
                return result.getJSONObject("event");
            }
            if (result.has("data")) {
                return result.getJSONObject("data");
            }
            return result;
        }
        return null;
    }

    private String getNameFromEntry(JSONObject entry) throws Exception {
        if (!entry.has("uri")) {
            throw new IllegalArgumentException("No uri in " + entry.toString());
        }
        String uri = entry.getString("uri");
        String name = uri.substring(uri.indexOf(SITE_SHORT_NAME_CALENDAR) + SITE_SHORT_NAME_CALENDAR.length() + 1);
        if (name.indexOf(63) > 0) {
            return name.substring(0, name.indexOf(63));
        }
        return name;
    }

    private String getEntriesICAL() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_EVENTS_LIST_ICS), 200);
        return response.getContentAsString();
    }

    private String[] getKeys(JSONObject json, boolean sorted) {
        Iterator ki = json.keys();
        ArrayList keys = new ArrayList(json.length());
        while (ki.hasNext()) {
            keys.add(ki.next());
        }
        if (sorted) {
            Collections.sort(keys);
        }
        return keys.toArray(new String[keys.size()]);
    }

    public void testCreateEditDeleteEntry() throws Exception {
        JSONObject entry = this.getEntry(EVENT_TITLE_ONE, 200);
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("error"));
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", 200);
        String name = this.getNameFromEntry(entry);
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("where"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("desc"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"12:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"13:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"12:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"13:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"6/29/2011", (Object)entry.getJSONObject("startAt").get("legacyDate"));
        CalendarRestApiTest.assertEquals((Object)"12:00", (Object)entry.getJSONObject("startAt").get("legacyTime"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"6/29/2011", (Object)entry.getJSONObject("endAt").get("legacyDate"));
        CalendarRestApiTest.assertEquals((Object)"13:00", (Object)entry.getJSONObject("endAt").get("legacyTime"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        JSONObject permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_FOUR);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"6/29/2011", (Object)entry.getJSONObject("startAt").get("legacyDate"));
        CalendarRestApiTest.assertEquals((Object)"12:00", (Object)entry.getJSONObject("startAt").get("legacyTime"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"6/29/2011", (Object)entry.getJSONObject("endAt").get("legacyDate"));
        CalendarRestApiTest.assertEquals((Object)"13:00", (Object)entry.getJSONObject("endAt").get("legacyTime"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        entry = this.updateEntry(name, EVENT_TITLE_ONE, "More Where", "More Thing", false, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("summary"));
        CalendarRestApiTest.assertEquals((String)"More Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"More Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"2011-06-28T11:30", (String)entry.getJSONObject("startAt").getString("legacyDateTime"));
        CalendarRestApiTest.assertEquals((String)"2011-06-28T13:30", (String)entry.getJSONObject("endAt").getString("legacyDateTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"More Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"More Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"11:30", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"13:30", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        entry = this.updateEntry(name, EVENT_TITLE_ONE, "More Where", "More Thing", true, 200);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"More Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"More Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"11:30", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"13:30", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((String)"Occurs every 2 weeks on Wednesday, Friday, effective 28-Jun-2011 until 11-Sep-2011 from 11:30 to 13:30 (BST)", (String)entry.getString("recurrence"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_EVENT_BASE + name), 204);
        entry = this.getEntry(EVENT_TITLE_ONE, 200);
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("error"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_EVENT_BASE + name), 404);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(URL_EVENT_BASE + name, "{}", "application/json"), 200);
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("error"));
    }

    public void testCreateAllDayEntry() throws Exception {
        JSONObject entry = this.getEntry(EVENT_TITLE_ONE, 200);
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("error"));
        entry = this.createAllDayEntry(EVENT_TITLE_ONE, "Where", "Thing", 200);
        String name = this.getNameFromEntry(entry);
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("where"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("desc"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T00:00:00.000", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T00:00:00.000", (Object)entry.getJSONObject("endAt").get("iso8601"));
        entry = this.createAllDayEntryDifferentTimeZone(EVENT_TITLE_ONE, "Where", "Thing", 200);
        name = this.getNameFromEntry(entry);
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("where"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("desc"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T00:00:00.000", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T00:00:00.000", (Object)entry.getJSONObject("endAt").get("iso8601"));
        entry = this.createMultiAllDayEntry(EVENT_TITLE_ONE, "Where", "Thing", 200);
        name = this.getNameFromEntry(entry);
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("where"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("desc"));
        CalendarRestApiTest.assertEquals((String)"2011-06-27", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((String)"Where", (String)entry.getString("location"));
        CalendarRestApiTest.assertEquals((String)"Thing", (String)entry.getString("description"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("isoutlook"));
        CalendarRestApiTest.assertEquals((String)"6/27/2011", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-27T00:00:00.000", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T00:00:00.000", (Object)entry.getJSONObject("endAt").get("iso8601"));
    }

    public void testPermissions() throws Exception {
        NodeRef calendarNodeRef = this.siteService.getContainer(SITE_SHORT_NAME_CALENDAR, "calendar");
        this.authenticationComponent.setCurrentUser(USER_ONE);
        CalendarRestApiTest.assertEquals((String)"SiteCollaborator", (String)this.siteService.getMembersRole(SITE_SHORT_NAME_CALENDAR, this.authenticationComponent.getCurrentUserName()));
        CalendarRestApiTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(calendarNodeRef, "AddChildren"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        CalendarRestApiTest.assertEquals((String)"SiteCollaborator", (String)this.siteService.getMembersRole(SITE_SHORT_NAME_CALENDAR, this.authenticationComponent.getCurrentUserName()));
        CalendarRestApiTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(calendarNodeRef, "AddChildren"));
        this.authenticationComponent.setCurrentUser(USER_THREE);
        CalendarRestApiTest.assertEquals((String)"SiteContributor", (String)this.siteService.getMembersRole(SITE_SHORT_NAME_CALENDAR, this.authenticationComponent.getCurrentUserName()));
        CalendarRestApiTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(calendarNodeRef, "AddChildren"));
        this.authenticationComponent.setCurrentUser(USER_FOUR);
        CalendarRestApiTest.assertEquals((String)"SiteConsumer", (String)this.siteService.getMembersRole(SITE_SHORT_NAME_CALENDAR, this.authenticationComponent.getCurrentUserName()));
        CalendarRestApiTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(calendarNodeRef, "AddChildren"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
        JSONObject entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", 200);
        String name = this.getNameFromEntry(entry);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        JSONObject permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_TWO);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_THREE);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_FOUR);
        entry = this.getEntry(name, 200);
        CalendarRestApiTest.assertEquals((String)("Error found " + entry.toString()), (boolean)false, (boolean)entry.has("error"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entry.getString("what"));
        CalendarRestApiTest.assertEquals((String)name, (String)entry.getString("name"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T12:00:00.000+01:00", (Object)entry.getJSONObject("startAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((Object)"2011-06-29T13:00:00.000+01:00", (Object)entry.getJSONObject("endAt").get("iso8601"));
        CalendarRestApiTest.assertEquals((boolean)true, (boolean)entry.has("permissions"));
        permissions = entry.getJSONObject("permissions");
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("edit"));
        CalendarRestApiTest.assertEquals((boolean)false, (boolean)permissions.getBoolean("delete"));
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    public void testDifferentDateStyles() throws Exception {
        JSONObject json = new JSONObject();
        json.put("from", (Object)"2011/06/21");
        json.put("to", (Object)"2011/06/21");
        json.put("start", (Object)"11:00");
        json.put("end", (Object)"12:00");
        JSONObject entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"11:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"12:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        json = new JSONObject();
        json.put("from", (Object)"2011-06-22");
        json.put("to", (Object)"2011-06-22");
        json.put("start", (Object)"10:00");
        json.put("end", (Object)"12:00");
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"10:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"12:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        json = new JSONObject();
        json.put("startAt", (Object)"2011-06-21T11:30:05+01:00");
        json.put("endAt", (Object)"2011-06-21T12:45:25+01:00");
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"11:30", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"12:45", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((String)"2011-06-21T11:30:05.000+01:00", (String)entry.getJSONObject("startAt").getString("iso8601"));
        CalendarRestApiTest.assertEquals((String)"2011-06-21T12:45:25.000+01:00", (String)entry.getJSONObject("endAt").getString("iso8601"));
        json = new JSONObject();
        json.put("startAt", (Object)"2011-06-22T11:30:05");
        json.put("endAt", (Object)"2011-06-22T12:45:25");
        json.put("timeZone", (Object)"Europe/London");
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"11:30", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"12:45", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((String)"2011-06-22T11:30:05.000+01:00", (String)entry.getJSONObject("startAt").getString("iso8601"));
        CalendarRestApiTest.assertEquals((String)"2011-06-22T12:45:25.000+01:00", (String)entry.getJSONObject("endAt").getString("iso8601"));
        json = new JSONObject();
        JSONObject startAt = new JSONObject();
        JSONObject endAt = new JSONObject();
        startAt.put("iso8601", (Object)"2011-06-20T09:35:05+01:00");
        endAt.put("iso8601", (Object)"2011-06-20T10:35:25+01:00");
        json.put("startAt", (Object)startAt);
        json.put("endAt", (Object)endAt);
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-20", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-20", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"09:35", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"10:35", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((String)"2011-06-20T09:35:05.000+01:00", (String)entry.getJSONObject("startAt").getString("iso8601"));
        CalendarRestApiTest.assertEquals((String)"2011-06-20T10:35:25.000+01:00", (String)entry.getJSONObject("endAt").getString("iso8601"));
        json = new JSONObject();
        startAt = new JSONObject();
        endAt = new JSONObject();
        startAt.put("iso8601", (Object)"2011-06-24T09:30:05");
        startAt.put("timeZone", (Object)"Europe/London");
        endAt.put("iso8601", (Object)"2011-06-24T10:45:25");
        endAt.put("timeZone", (Object)"Europe/London");
        json.put("startAt", (Object)startAt);
        json.put("endAt", (Object)endAt);
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-24", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-24", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"09:30", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"10:45", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"false", (String)entry.getString("allday"));
        CalendarRestApiTest.assertEquals((String)"2011-06-24T09:30:05.000+01:00", (String)entry.getJSONObject("startAt").getString("iso8601"));
        CalendarRestApiTest.assertEquals((String)"2011-06-24T10:45:25.000+01:00", (String)entry.getJSONObject("endAt").getString("iso8601"));
        json = new JSONObject();
        json.put("from", (Object)"2011/06/21");
        json.put("to", (Object)"2011/06/21");
        json.put("allday", (Object)Boolean.TRUE);
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-21", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("startAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"00:00", (String)entry.getJSONObject("endAt").getString("legacyTime"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
        json = new JSONObject();
        json.put("startAt", (Object)"2011-06-22T00:00:00");
        json.put("endAt", (Object)"2011-06-22T00:00:00");
        json.put("timeZone", (Object)"Europe/London");
        json.put("allday", (Object)Boolean.TRUE);
        entry = this.createEntry(EVENT_TITLE_ONE, "Where", "Thing", json, 200);
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("startAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"2011-06-22", (String)entry.getJSONObject("endAt").getString("legacyDate"));
        CalendarRestApiTest.assertEquals((String)"true", (String)entry.getString("allday"));
    }

    public void testOverallListing() throws Exception {
        JSONObject dates = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)0, (int)dates.length());
        this.createEntry(EVENT_TITLE_ONE, "Somewhere", "Thing 1", 200);
        this.createEntry(EVENT_TITLE_TWO, "Somewhere", "Thing 2", 200);
        dates = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)1, (int)dates.length());
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)dates.names().getString(0));
        JSONArray entries = dates.getJSONArray("6/29/2011");
        CalendarRestApiTest.assertEquals((int)2, (int)entries.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entries.getJSONObject(0).getString("name"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)entries.getJSONObject(1).getString("name"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29T12:00:00.000+01:00", (String)entries.getJSONObject(0).getJSONObject("startAt").getString("iso8601"));
        CalendarRestApiTest.assertEquals((String)"2011-06-29T13:00:00.000+01:00", (String)entries.getJSONObject(0).getJSONObject("endAt").getString("iso8601"));
        JSONObject entry = this.createEntry(EVENT_TITLE_THREE, "Where3", "Thing 3", 200);
        String name3 = this.getNameFromEntry(entry);
        this.updateEntry(name3, EVENT_TITLE_THREE, "More Where 3", "More Thing 3", false, 200);
        dates = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)2, (int)dates.length());
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)dates.names().getString(0));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)dates.names().getString(1));
        entries = dates.getJSONArray("6/29/2011");
        CalendarRestApiTest.assertEquals((int)2, (int)entries.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)entries.getJSONObject(0).getString("name"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)entries.getJSONObject(1).getString("name"));
        entries = dates.getJSONArray("6/28/2011");
        CalendarRestApiTest.assertEquals((int)1, (int)entries.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_THREE, (String)entries.getJSONObject(0).getString("name"));
        String ical = this.getEntriesICAL();
        CalendarRestApiTest.assertTrue((String)("Invalid ICAL:\n" + ical), (boolean)ical.contains("BEGIN:VCALENDAR"));
        CalendarRestApiTest.assertTrue((String)("Invalid ICAL:\n" + ical), (boolean)ical.contains("END:VCALENDAR"));
        CalendarRestApiTest.assertEquals((int)4, (int)ical.split("BEGIN:VEVENT").length);
        CalendarRestApiTest.assertTrue((String)("Title not found:\n" + ical), (boolean)ical.contains("SUMMARY:TestEventOne"));
        CalendarRestApiTest.assertTrue((String)("Title not found:\n" + ical), (boolean)ical.contains("SUMMARY:TestEventTwo"));
        CalendarRestApiTest.assertTrue((String)("Title not found:\n" + ical), (boolean)ical.contains("SUMMARY:TestEventThree"));
    }

    public void testUserListing() throws Exception {
        JSONObject result = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)0, (int)result.length());
        result = this.getEntries("admin", null);
        JSONArray events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)0, (int)events.length());
        this.createEntry(EVENT_TITLE_ONE, "Somewhere", "Thing 1", 200);
        this.createEntry(EVENT_TITLE_TWO, "Somewhere", "Thing 2", 200);
        result = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)1, (int)result.length());
        result = this.getEntries("admin", "2000/01/01");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)2, (int)events.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(1).getString("title"));
        result = this.getEntries("admin", null);
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)2, (int)events.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(1).getString("title"));
        JSONObject entry = this.createEntry(EVENT_TITLE_THREE, "Where3", "Thing 3", 200);
        String name3 = this.getNameFromEntry(entry);
        this.updateEntry(name3, EVENT_TITLE_THREE, "More Where 3", "More Thing 3", false, 200);
        result = this.getEntries("admin", null);
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)3, (int)events.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_THREE, (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(1).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(2).getString("title"));
        CalendarRestApiTest.assertEquals((String)SITE_SHORT_NAME_CALENDAR, (String)events.getJSONObject(0).getString("site"));
        CalendarRestApiTest.assertEquals((String)SITE_SHORT_NAME_CALENDAR, (String)events.getJSONObject(1).getString("site"));
        CalendarRestApiTest.assertEquals((String)SITE_SHORT_NAME_CALENDAR, (String)events.getJSONObject(2).getString("site"));
        result = this.getEntries("admin", "2011/06/29");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)2, (int)events.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(1).getString("title"));
        result = this.getEntries("admin", "2011/07/01");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)0, (int)events.length());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/calendar/events/user?from=2000/01/01"), 200);
        result = new JSONObject(response.getContentAsString());
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)3, (int)events.length());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        SiteInfo site = this.siteService.getSite(SITE_SHORT_NAME_CALENDAR);
        site.setVisibility(SiteVisibility.PRIVATE);
        this.siteService.updateSite(site);
        this.siteService.removeMembership(SITE_SHORT_NAME_CALENDAR, USER_ONE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/calendar/events/user?from=2000/01/01"), 200);
        result = new JSONObject(response.getContentAsString());
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)0, (int)events.length());
    }

    public void testRepeatingEventsInListings() throws Exception {
        JSONObject result = this.getEntries(null, null);
        CalendarRestApiTest.assertEquals((int)0, (int)result.length());
        result = this.getEntries("admin", null);
        JSONArray events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)0, (int)events.length());
        JSONObject entry1 = this.createEntry(EVENT_TITLE_ONE, "Somewhere", "Thing 1", 200);
        JSONObject entry2 = this.createEntry(EVENT_TITLE_TWO, "Somewhere", "Thing 2", 200);
        String entryName1 = this.getNameFromEntry(entry1);
        String entryName2 = this.getNameFromEntry(entry2);
        this.updateEntry(entryName2, EVENT_TITLE_TWO, "Somewhere", "Thing 2", true, 200);
        result = this.getEntries("admin", "2011-06-27&repeating=first");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)2, (int)events.length());
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(0).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName1, (String)events.getJSONObject(1).getString("name"));
        CalendarRestApiTest.assertEquals((String)"TestEventTwo (Repeating)", (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(1).getString("title"));
        result = this.getEntries(null, "2011-06-27&repeating=first");
        CalendarRestApiTest.assertEquals((int)2, (int)result.length());
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)this.getKeys(result, true)[0]);
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)this.getKeys(result, true)[1]);
        events = result.getJSONArray("6/28/2011");
        CalendarRestApiTest.assertEquals((int)1, (int)events.length());
        CalendarRestApiTest.assertEquals((String)"TestEventTwo (Repeating)", (String)events.getJSONObject(0).getString("name"));
        events = result.getJSONArray("6/29/2011");
        CalendarRestApiTest.assertEquals((int)1, (int)events.length());
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(0).getString("name"));
        result = this.getEntries("admin", "2011/06/27");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)7, (int)Math.min(events.length(), 7));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(0).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(1).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName1, (String)events.getJSONObject(2).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(3).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(4).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(5).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(6).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(7).getString("name"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(0).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(1).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_ONE, (String)events.getJSONObject(2).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(3).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(4).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(5).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(6).getString("title"));
        CalendarRestApiTest.assertEquals((String)EVENT_TITLE_TWO, (String)events.getJSONObject(7).getString("title"));
        CalendarRestApiTest.assertEquals((String)"2011-06-28T", (String)events.getJSONObject(0).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-06-29T", (String)events.getJSONObject(1).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-06-29T", (String)events.getJSONObject(2).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-07-01T", (String)events.getJSONObject(3).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-07-13T", (String)events.getJSONObject(4).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-07-15T", (String)events.getJSONObject(5).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-07-27T", (String)events.getJSONObject(6).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-07-29T", (String)events.getJSONObject(7).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        result = this.getEntries(null, "2011-06-28&repeating=all");
        CalendarRestApiTest.assertEquals((int)7, (int)Math.min(result.length(), 7));
        CalendarRestApiTest.assertEquals((String)"6/28/2011", (String)this.getKeys(result, true)[0]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("6/28/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("6/28/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"6/29/2011", (String)this.getKeys(result, true)[1]);
        CalendarRestApiTest.assertEquals((int)2, (int)result.getJSONArray("6/29/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("6/29/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_ONE, (Object)result.getJSONArray("6/29/2011").getJSONObject(1).get("name"));
        CalendarRestApiTest.assertEquals((String)"7/1/2011", (String)this.getKeys(result, true)[2]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("7/1/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("7/1/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"7/13/2011", (String)this.getKeys(result, true)[3]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("7/13/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("7/13/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"7/15/2011", (String)this.getKeys(result, true)[4]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("7/15/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("7/15/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"7/27/2011", (String)this.getKeys(result, true)[5]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("7/27/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("7/27/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"7/29/2011", (String)this.getKeys(result, true)[6]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("7/29/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("7/29/2011").getJSONObject(0).get("name"));
        result = this.getEntries("admin", "2011/08/20");
        events = result.getJSONArray("events");
        CalendarRestApiTest.assertEquals((int)4, (int)events.length());
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(0).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(1).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(2).getString("name"));
        CalendarRestApiTest.assertEquals((String)entryName2, (String)events.getJSONObject(3).getString("name"));
        CalendarRestApiTest.assertEquals((String)"2011-08-24T", (String)events.getJSONObject(0).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-08-26T", (String)events.getJSONObject(1).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-09-07T", (String)events.getJSONObject(2).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        CalendarRestApiTest.assertEquals((String)"2011-09-09T", (String)events.getJSONObject(3).getJSONObject("startAt").getString("iso8601").substring(0, 11));
        result = this.getEntries(null, "2011-08-20&repeating=all");
        CalendarRestApiTest.assertEquals((int)4, (int)result.length());
        CalendarRestApiTest.assertEquals((String)"8/24/2011", (String)this.getKeys(result, true)[0]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("8/24/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("8/24/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"8/26/2011", (String)this.getKeys(result, true)[1]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("8/26/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("8/26/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"9/7/2011", (String)this.getKeys(result, true)[2]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("9/7/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("9/7/2011").getJSONObject(0).get("name"));
        CalendarRestApiTest.assertEquals((String)"9/9/2011", (String)this.getKeys(result, true)[3]);
        CalendarRestApiTest.assertEquals((int)1, (int)result.getJSONArray("9/9/2011").length());
        CalendarRestApiTest.assertEquals((Object)EVENT_TITLE_TWO, (Object)result.getJSONArray("9/9/2011").getJSONObject(0).get("name"));
    }
}

