/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comment;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class CommentsApiTest
extends BaseWebScriptTest {
    private static final String URL_POST_COMMENT = "api/node/{0}/{1}/{2}/comments";
    private static final String JSON = "application/json";
    private FileFolderService fileFolderService;
    private TransactionService transactionService;
    private SearchService searchService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private VersionService versionService;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private UserTransaction txn;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.fileFolderService = (FileFolderService)appContext.getBean("fileFolderService");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.searchService = (SearchService)appContext.getBean("SearchService");
        this.nodeService = (NodeService)appContext.getBean("nodeService");
        this.namespaceService = (NamespaceService)appContext.getBean("namespaceService");
        this.versionService = (VersionService)appContext.getBean("versionService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List results = this.searchService.selectNodes(this.rootNodeRef, "/app:company_home", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Can't find /app:company_home");
        }
        NodeRef companyHomeNodeRef = (NodeRef)results.get(0);
        results = this.searchService.selectNodes(this.rootNodeRef, "/app:company_home/cm:Commenty", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (results.size() > 0) {
            this.fileFolderService.delete((NodeRef)results.get(0));
        }
        this.nodeRef = this.fileFolderService.create(companyHomeNodeRef, "Commenty", ContentModel.TYPE_CONTENT).getNodeRef();
        this.versionService.ensureVersioningEnabled(this.nodeRef, null);
        this.nodeService.setProperty(this.nodeRef, ContentModel.PROP_AUTO_VERSION_PROPS, (Serializable)Boolean.valueOf(true));
        this.txn.commit();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void addComment(NodeRef nodeRef) throws Exception {
        TestWebScriptServer.Response response = null;
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        StringBuilder body = new StringBuilder("{");
        body.append("'title' : 'Test Title', ");
        body.append("'content' : 'Test Comment'");
        body.append("}");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(MessageFormat.format(URL_POST_COMMENT, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId()), body.toString(), JSON), 200);
        CommentsApiTest.assertEquals((int)200, (int)response.getStatus());
        txn.commit();
    }

    private String getCurrentVersion(NodeRef nodeRef) throws Exception {
        String version = this.versionService.getCurrentVersion(nodeRef).getVersionLabel();
        return version;
    }

    public void testCommentDoesNotVersion() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String versionBefore = this.getCurrentVersion(this.nodeRef);
        this.addComment(this.nodeRef);
        String versionAfter = this.getCurrentVersion(this.nodeRef);
        CommentsApiTest.assertEquals((String)versionBefore, (String)versionAfter);
    }
}

