/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.alfresco.cmis.CMISFilterNotValidException;
import org.alfresco.cmis.CMISObjectReference;
import org.alfresco.cmis.CMISRendition;
import org.alfresco.cmis.CMISRenditionService;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cmis.reference.ReferenceFactory;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResource;

public class ContentGet
extends StreamContent
implements ServletContextAware {
    private static final Log logger = LogFactory.getLog(ContentGet.class);
    private ServletContext servletContext;
    private ReferenceFactory referenceFactory;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private CMISRenditionService renditionService;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setReferenceFactory(ReferenceFactory referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCMISRenditionService(CMISRenditionService renditionService) {
        this.renditionService = renditionService;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String[] names = req.getParameterNames();
        HashMap<String, String> args = new HashMap<String, String>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameter(name));
        }
        Map templateVars = req.getServiceMatch().getTemplateVars();
        CMISObjectReference reference = this.referenceFactory.createObjectReferenceFromUrl(args, templateVars);
        NodeRef nodeRef = reference.getNodeRef();
        if (nodeRef == null) {
            throw new WebScriptException(404, "Unable to find " + reference.toString());
        }
        boolean attach = Boolean.valueOf(req.getParameter("a"));
        String streamId = req.getParameter("streamId");
        if (streamId != null && streamId.length() > 0) {
            this.streamRendition(req, res, reference, streamId, attach);
        } else {
            QName propertyQName = ContentModel.PROP_CONTENT;
            String contentPart = (String)templateVars.get("property");
            if (contentPart.length() > 0 && contentPart.charAt(0) == ';') {
                if (contentPart.length() < 2) {
                    throw new WebScriptException(400, "Content property malformed");
                }
                String propertyName = contentPart.substring(1);
                if (propertyName.length() > 0) {
                    propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
                }
            }
            this.streamContentLocal(req, res, nodeRef, attach, propertyQName);
        }
    }

    private void streamContentLocal(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, boolean attach, QName propertyQName) throws IOException {
        boolean rfc5987Supported;
        String userAgent = req.getHeader("User-Agent");
        boolean bl = rfc5987Supported = null != userAgent && (userAgent.contains("MSIE") || userAgent.contains(" Chrome/") || userAgent.contains(" FireFox/"));
        if (attach && rfc5987Supported) {
            String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
            this.streamContent(req, res, nodeRef, propertyQName, attach, name);
        } else {
            this.streamContent(req, res, nodeRef, propertyQName, attach);
        }
    }

    private void streamRendition(WebScriptRequest req, WebScriptResponse res, CMISObjectReference reference, String streamId, boolean attach) throws IOException {
        try {
            CMISRendition rendition = null;
            List renditions = this.renditionService.getRenditions(reference.getNodeRef(), "*");
            for (CMISRendition candidateRendition : renditions) {
                if (!candidateRendition.getStreamId().equals(streamId)) continue;
                rendition = candidateRendition;
                break;
            }
            if (rendition == null) {
                throw new WebScriptException(404, "Unable to find rendition " + streamId + " for " + reference.toString());
            }
            if (streamId.startsWith("alf:icon")) {
                this.streamIcon(res, reference, streamId, attach);
            } else {
                this.streamContentLocal(req, res, rendition.getNodeRef(), attach, ContentModel.PROP_CONTENT);
            }
        }
        catch (CMISFilterNotValidException e) {
            throw new WebScriptException(500, "Invalid Rendition Filter");
        }
    }

    private void streamIcon(WebScriptResponse res, CMISObjectReference reference, String streamId, boolean attach) throws IOException {
        FileTypeImageSize imageSize = streamId.equals("alf:icon16") ? FileTypeImageSize.Small : FileTypeImageSize.Medium;
        String iconSize = streamId.equals("alf:icon16") ? "-16" : "";
        String iconPath = null;
        if (this.dictionaryService.isSubClass(this.nodeService.getType(reference.getNodeRef()), ContentModel.TYPE_CONTENT)) {
            String name = (String)((Object)this.nodeService.getProperty(reference.getNodeRef(), ContentModel.PROP_NAME));
            iconPath = FileTypeImageUtils.getFileTypeImage(this.servletContext, name, imageSize);
        } else {
            String icon = (String)((Object)this.nodeService.getProperty(reference.getNodeRef(), ApplicationModel.PROP_ICON));
            iconPath = icon != null ? "/images/icons/" + icon + iconSize + ".gif" : "/images/icons/space-icon-default" + iconSize + ".gif";
        }
        String mimetype = "application/octet-stream";
        int extIndex = iconPath.lastIndexOf(46);
        if (extIndex != -1) {
            String ext = iconPath.substring(extIndex + 1);
            mimetype = this.mimetypeService.getMimetype(ext);
        }
        res.setContentType(mimetype);
        ServletContextResource resource = new ServletContextResource(this.servletContext, iconPath);
        if (!resource.exists()) {
            throw new WebScriptException(404, "Unable to find rendition " + streamId + " for " + reference.toString());
        }
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)res.getOutputStream());
    }
}

