/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptStatus;
import org.springframework.util.FileCopyUtils;

public class StreamContent
extends AbstractWebScript
implements ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(StreamContent.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    protected PermissionService permissionService;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected MimetypeService mimetypeService;
    protected ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String format = req.getFormat();
        try {
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            Map<String, Object> model = this.executeImpl(req, status, cache);
            if (model == null) {
                model = new HashMap<String, Object>(8, 1.0f);
            }
            model.put("status", status);
            model.put("cache", cache);
            AbstractWebScript.ScriptDetails executeScript = this.getExecuteScript(req.getContentType());
            if (executeScript != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing script " + executeScript.getContent().getPathDescription()));
                }
                Map scriptModel = this.createScriptParameters(req, res, executeScript, model);
                HashMap<String, Object> returnModel = new HashMap<String, Object>(8, 1.0f);
                scriptModel.put("model", returnModel);
                this.executeScript(executeScript.getContent(), scriptModel);
                this.mergeScriptModelIntoTemplateModel(executeScript.getContent().getPath(), returnModel, model);
            }
            if (status.getRedirect()) {
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
            } else {
                String contentPath;
                Boolean attachBoolean = (Boolean)model.get("attach");
                boolean attach = false;
                if (attachBoolean != null) {
                    attach = attachBoolean;
                }
                if ((contentPath = (String)model.get("contentPath")) == null) {
                    NodeRef nodeRef = (NodeRef)model.get("contentNode");
                    if (nodeRef == null) {
                        throw new WebScriptException("The content node was not specified so the content cannot be streamed to the client: " + executeScript.getContent().getPathDescription());
                    }
                    QName propertyQName = null;
                    String contentProperty = (String)model.get("contentProperty");
                    propertyQName = contentProperty == null ? ContentModel.PROP_CONTENT : QName.createQName((String)contentProperty);
                    this.streamContent(req, res, nodeRef, propertyQName, attach, model);
                } else {
                    this.streamContent(req, res, contentPath, attach, model);
                }
            }
        }
        catch (Throwable e) {
            throw this.createStatusException(e, req, res);
        }
    }

    private final void mergeScriptModelIntoTemplateModel(String scriptPath, Map<String, Object> scriptModel, Map<String, Object> templateModel) {
        int i = scriptPath.lastIndexOf(".");
        if (i != -1) {
            String extension = scriptPath.substring(i + 1);
            ScriptProcessor processor = this.getContainer().getScriptProcessorRegistry().getScriptProcessorByExtension(extension);
            if (processor != null) {
                for (Map.Entry<String, Object> entry : scriptModel.entrySet()) {
                    Object value = entry.getValue();
                    Object templateValue = processor.unwrapValue(value);
                    templateModel.put(entry.getKey(), templateValue);
                }
            }
        }
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, WebScriptStatus status) {
        return null;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        return this.executeImpl(req, new WebScriptStatus(status));
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        return this.executeImpl(req, status);
    }

    protected final void renderFormatTemplate(String format, Map<String, Object> model, Writer writer) {
        format = format == null ? "" : format;
        String templatePath = this.getDescription().getId() + "." + format + ".ftl";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering template '" + templatePath + "'"));
        }
        this.renderTemplate(templatePath, model, writer);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach) throws IOException {
        this.streamContent(req, res, nodeRef, propertyQName, attach, null, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach, Map<String, Object> model) throws IOException {
        this.streamContent(req, res, nodeRef, propertyQName, attach, null, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach, String attachFileName) throws IOException {
        this.streamContent(req, res, nodeRef, propertyQName, attach, attachFileName, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        ContentReader reader;
        Date modified;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from node ref " + nodeRef.toString() + " (property: " + propertyQName.toString() + ") (attach: " + attach + ")"));
        }
        if ((modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED)) != null) {
            long modifiedSince = -1L;
            String modifiedSinceStr = req.getHeader("If-Modified-Since");
            if (modifiedSinceStr != null) {
                long modDate;
                block7: {
                    try {
                        modifiedSince = dateFormat.parse(modifiedSinceStr).getTime();
                    }
                    catch (Throwable e) {
                        if (!logger.isInfoEnabled()) break block7;
                        logger.info((Object)("Browser sent badly-formatted If-Modified-Since header: " + modifiedSinceStr));
                    }
                }
                if (modifiedSince > 0L && (modDate = modified.getTime() / 1000L * 1000L) <= modifiedSince) {
                    res.setStatus(304);
                    return;
                }
            }
        }
        if ((reader = this.contentService.getReader(nodeRef, propertyQName)) == null || !reader.exists()) {
            throw new WebScriptException(404, "Unable to locate content for node ref " + nodeRef + " (property: " + propertyQName.toString() + ")");
        }
        this.streamContentImpl(req, res, reader, attach, modified, modified == null ? null : String.valueOf(modified.getTime()), attachFileName, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach) throws IOException {
        this.streamContent(req, res, resourcePath, attach, null, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach, Map<String, Object> model) throws IOException {
        this.streamContent(req, res, resourcePath, attach, null, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach, String attachFileName) throws IOException {
        this.streamContent(req, res, resourcePath, attach, attachFileName, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from resource path " + resourcePath + " (attach: " + attach + ")"));
        }
        String ext = "";
        int extIndex = resourcePath.lastIndexOf(46);
        if (extIndex != -1) {
            ext = resourcePath.substring(extIndex);
        }
        StringBuilder sb = new StringBuilder("classpath:").append(resourcePath);
        String classpathResource = sb.toString();
        long resourceLastModified = this.resourceLoader.getResource(classpathResource).lastModified();
        File file = TempFileProvider.createTempFile((String)"streamContent-", (String)ext);
        InputStream is = this.resourceLoader.getResource(classpathResource).getInputStream();
        FileOutputStream os = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        this.streamContent(req, res, file, resourceLastModified, attach, attachFileName, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, boolean attach) throws IOException {
        this.streamContent(req, res, file, attach, null, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, boolean attach, Map<String, Object> model) throws IOException {
        this.streamContent(req, res, file, attach, null, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, boolean attach, String attachFileName) throws IOException {
        this.streamContent(req, res, file, null, attach, attachFileName, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        this.streamContent(req, res, file, null, attach, attachFileName, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, Long modifiedTime, boolean attach, String attachFileName) throws IOException {
        this.streamContent(req, res, file, modifiedTime, attach, attachFileName, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, Long modifiedTime, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from file " + file.getAbsolutePath() + " (attach: " + attach + ")"));
        }
        String filePath = file.getAbsolutePath();
        String mimetype = "application/octet-stream";
        int extIndex = filePath.lastIndexOf(46);
        if (extIndex != -1) {
            mimetype = this.mimetypeService.getMimetype(filePath.substring(extIndex + 1));
        }
        FileContentReader reader = new FileContentReader(file);
        reader.setMimetype(mimetype);
        reader.setEncoding("UTF-8");
        long lastModified = modifiedTime == null ? file.lastModified() : modifiedTime.longValue();
        Date lastModifiedDate = new Date(lastModified);
        this.streamContentImpl(req, res, (ContentReader)reader, attach, lastModifiedDate, String.valueOf(lastModifiedDate.getTime()), attachFileName, model);
    }

    protected void streamContentImpl(WebScriptRequest req, WebScriptResponse res, ContentReader reader, boolean attach, Date modified, String eTag, String attachFileName) throws IOException {
        this.streamContentImpl(req, res, reader, attach, modified, eTag, attachFileName, null);
    }

    protected void streamContentImpl(WebScriptRequest req, WebScriptResponse res, ContentReader reader, boolean attach, Date modified, String eTag, String attachFileName, Map<String, Object> model) throws IOException {
        block6: {
            this.setAttachment(res, attach, attachFileName);
            String mimetype = reader.getMimetype();
            String extensionPath = req.getExtensionPath();
            if (mimetype == null || mimetype.length() == 0) {
                mimetype = "application/octet-stream";
                int extIndex = extensionPath.lastIndexOf(46);
                if (extIndex != -1) {
                    String ext = extensionPath.substring(extIndex + 1);
                    mimetype = this.mimetypeService.getMimetype(ext);
                }
            }
            res.setContentType(mimetype);
            res.setContentEncoding(reader.getEncoding());
            res.setHeader("Content-Length", Long.toString(reader.getSize()));
            this.setResponseCache(res, modified, eTag, model);
            try {
                reader.getContent(res.getOutputStream());
            }
            catch (SocketException e1) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Client aborted stream read:\n\tcontent: " + reader));
                }
            }
            catch (ContentIOException e2) {
                if (!logger.isInfoEnabled()) break block6;
                logger.info((Object)("Client aborted stream read:\n\tcontent: " + reader));
            }
        }
    }

    protected void setResponseCache(WebScriptResponse res, Date modified, String eTag, Map<String, Object> model) {
        Cache cache = new Cache();
        if (model == null || model.get("allowBrowserToCache") == null || ((String)model.get("allowBrowserToCache")).equals("false")) {
            cache.setNeverCache(false);
            cache.setMustRevalidate(true);
            cache.setMaxAge(Long.valueOf(0L));
            cache.setLastModified(modified);
            cache.setETag(eTag);
        } else {
            cache.setNeverCache(false);
            cache.setMustRevalidate(false);
            cache.setMaxAge(Long.valueOf(Long.MAX_VALUE));
            cache.setLastModified(modified);
            cache.setETag(eTag);
            res.setCache(cache);
        }
        res.setCache(cache);
    }

    protected void setAttachment(WebScriptResponse res, boolean attach, String attachFileName) {
        if (attach) {
            String headerValue = "attachment";
            if (attachFileName != null && attachFileName.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attaching content using filename: " + attachFileName));
                }
                headerValue = headerValue + "; filename=\"" + attachFileName + "\"; filename*=UTF-8''" + WebDAVHelper.encodeURL(attachFileName);
            }
            res.setHeader("Content-Disposition", headerValue);
        }
    }
}

