/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.Comparator;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;

public interface DictionaryComparators {

    public static class PropertyDefinitionComparator
    implements Comparator<PropertyDefinition> {
        @Override
        public int compare(PropertyDefinition arg0, PropertyDefinition arg1) {
            String title1;
            int result = 0;
            String title0 = arg0.getTitle();
            if (title0 == null) {
                title0 = arg0.getName().toPrefixString();
            }
            if ((title1 = arg1.getTitle()) == null) {
                title1 = arg1.getName().getPrefixString();
            }
            if (title0 == null && title1 != null) {
                result = 1;
            } else if (title0 != null && title1 == null) {
                result = -1;
            } else if (title0 != null && title1 != null) {
                result = String.CASE_INSENSITIVE_ORDER.compare(title0, title1);
            }
            return result;
        }
    }

    public static class ClassDefinitionComparator
    implements Comparator<ClassDefinition> {
        @Override
        public int compare(ClassDefinition arg0, ClassDefinition arg1) {
            String title1;
            int result = 0;
            String title0 = arg0.getTitle();
            if (title0 == null) {
                title0 = arg0.getName().toPrefixString();
            }
            if ((title1 = arg1.getTitle()) == null) {
                title1 = arg1.getName().getPrefixString();
            }
            if (title0 == null && title1 != null) {
                result = 1;
            } else if (title0 != null && title1 == null) {
                result = -1;
            } else if (title0 != null && title1 != null) {
                result = String.CASE_INSENSITIVE_ORDER.compare(title0, title1);
            }
            return result;
        }
    }
}

