/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.web.scripts.dictionary.DictionaryWebServiceBase;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DictionaryGet
extends DictionaryWebServiceBase {
    private static final String MODEL_CLASS_DEFS = "classdefs";
    private static final String MODEL_PROPERTY_DEFS = "propertydefs";
    private static final String MODEL_ASSOCIATION_DEFS = "assocdefs";
    private Set<String> ignoreNamespaces = Collections.emptySet();

    public void setIgnoreNamespaces(Set<String> namespaces) {
        this.ignoreNamespaces = namespaces;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        ArrayList qnames = new ArrayList(256);
        HashSet<String> namespaces = new HashSet<String>();
        HashMap<QName, ClassDefinition> classdef = new HashMap<QName, ClassDefinition>();
        HashMap propdef = new HashMap();
        HashMap assocdef = new HashMap();
        for (String ns : this.namespaceService.getURIs()) {
            if (this.ignoreNamespaces.contains(ns)) continue;
            namespaces.add(ns);
        }
        for (QName qname : this.dictionaryservice.getAllModels()) {
            if (!namespaces.contains(qname.getNamespaceURI())) continue;
            qnames.addAll(this.dictionaryservice.getAspects(qname));
            qnames.addAll(this.dictionaryservice.getTypes(qname));
        }
        for (QName qname : qnames) {
            classdef.put(qname, this.dictionaryservice.getClass(qname));
            propdef.put(qname, this.dictionaryservice.getClass(qname).getProperties().values());
            assocdef.put(qname, this.dictionaryservice.getClass(qname).getAssociations().values());
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MODEL_CLASS_DEFS, classdef.values());
        model.put(MODEL_PROPERTY_DEFS, propdef.values());
        model.put(MODEL_ASSOCIATION_DEFS, assocdef.values());
        return model;
    }
}

