/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.dictionary;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.InvalidQNameException;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public abstract class DictionaryWebServiceBase
extends DeclarativeWebScript {
    private static final String NAME_DELIMITER = "_";
    private Map<String, String> prefixesAndUrlsMap;
    private Map<String, String> urlsAndPrefixesMap;
    protected NamespaceService namespaceService;
    protected DictionaryService dictionaryservice;
    private static final String CLASS_FILTER_OPTION_TYPE1 = "all";
    private static final String CLASS_FILTER_OPTION_TYPE2 = "aspect";
    private static final String CLASS_FILTER_OPTION_TYPE3 = "type";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE1 = "all";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE2 = "general";
    private static final String ASSOCIATION_FILTER_OPTION_TYPE3 = "child";

    public void setNamespaceService(NamespaceService namespaceservice) {
        this.namespaceService = namespaceservice;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryservice = dictionaryService;
    }

    public void init() {
        Collection prefixes = this.namespaceService.getPrefixes();
        this.prefixesAndUrlsMap = new HashMap<String, String>(prefixes.size());
        this.urlsAndPrefixesMap = new HashMap<String, String>(prefixes.size());
        for (String prefix : prefixes) {
            String url = this.namespaceService.getNamespaceURI(prefix);
            this.prefixesAndUrlsMap.put(prefix, url);
            this.urlsAndPrefixesMap.put(url, prefix);
        }
    }

    protected QName createClassQName(String className) {
        QName result = null;
        int index = className.indexOf(NAME_DELIMITER);
        if (index > 0) {
            QName classQName;
            String prefix = className.substring(0, index);
            String shortName = className.substring(index + 1);
            String url = this.namespaceService.getNamespaceURI(prefix);
            if (url != null && url.length() != 0 && shortName != null && shortName.length() != 0 && this.dictionaryservice.getClass(classQName = QName.createQName((String)url, (String)shortName)) != null) {
                result = classQName;
            }
        }
        return result;
    }

    public String getNamespaceURIfromQname(QName qname) {
        return qname.getNamespaceURI();
    }

    public String getFullNamespaceURI(String classname) {
        try {
            String result = null;
            String prefix = this.getPrefix(classname);
            String url = this.prefixesAndUrlsMap.get(prefix);
            String name = this.getShortName(classname);
            result = "{" + url + "}" + name;
            return result;
        }
        catch (Exception e) {
            throw new WebScriptException(404, "The exact classname - " + classname + "  parameter has not been provided in the URL");
        }
    }

    public boolean isValidClassname(String classname) {
        QName qname = null;
        try {
            qname = QName.createQName((String)this.getFullNamespaceURI(classname));
            return this.dictionaryservice.getClass(qname) != null;
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public String getPrefixFromModelName(String modelname) {
        String namespaceprefix = null;
        for (QName qnameObj : this.dictionaryservice.getAllModels()) {
            if (!qnameObj.getLocalName().equals(modelname)) continue;
            namespaceprefix = this.getUrlsAndPrefixesMap().get(qnameObj.getNamespaceURI());
            break;
        }
        return namespaceprefix;
    }

    public boolean isValidAssociationFilter(String af) {
        return af.equalsIgnoreCase("all") || af.equalsIgnoreCase(ASSOCIATION_FILTER_OPTION_TYPE2) || af.equalsIgnoreCase(ASSOCIATION_FILTER_OPTION_TYPE3);
    }

    public boolean isValidTypeorAspect(String classname) {
        try {
            QName qname = QName.createQName((String)this.getFullNamespaceURI(classname));
            return this.dictionaryservice.getClass(qname) != null && this.dictionaryservice.getClass(qname).isAspect();
        }
        catch (InvalidQNameException invalidQNameException) {
            return false;
        }
    }

    public boolean isValidModelName(String modelname) {
        boolean value = false;
        for (QName qnameObj : this.dictionaryservice.getAllModels()) {
            if (!qnameObj.getLocalName().equalsIgnoreCase(modelname)) continue;
            value = true;
            break;
        }
        return value;
    }

    public String getPrefix(String classname) {
        String prefix = null;
        int index = classname.indexOf(NAME_DELIMITER);
        if (index > 0) {
            prefix = classname.substring(0, index);
        }
        return prefix;
    }

    public String getShortName(String classname) {
        String shortname = null;
        int index = classname.indexOf(NAME_DELIMITER);
        if (index > 0) {
            shortname = classname.substring(index + 1);
        }
        return shortname;
    }

    public String getValidInput(String input) {
        if (input != null && input.length() != 0) {
            return input;
        }
        return null;
    }

    public boolean isValidClassFilter(String classfilter) {
        return classfilter.equals("all") || classfilter.equals(CLASS_FILTER_OPTION_TYPE2) || classfilter.equals(CLASS_FILTER_OPTION_TYPE3);
    }

    public Map<String, String> getPrefixesAndUrlsMap() {
        return this.prefixesAndUrlsMap;
    }

    public Map<String, String> getUrlsAndPrefixesMap() {
        return this.urlsAndPrefixesMap;
    }
}

