/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumPostPut
extends AbstractDiscussionWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        if (post != null) {
            this.doUpdatePost(post, post.getTopic(), req, json);
            this.addActivityEntry("reply", "updated", post.getTopic(), post, site, req, json);
            model.put("postData", this.renderPost(post, site));
        } else if (topic != null) {
            post = this.discussionService.getPrimaryPost(topic);
            if (post == null) {
                throw new WebScriptException(412, "First (primary) post was missing from the topic, can't fetch");
            }
            this.doUpdatePost(post, topic, req, json);
            this.addActivityEntry("post", "updated", topic, null, site, req, json);
            model.put("postData", this.renderTopic(topic, site));
        } else {
            String error = "Node was of the wrong type, only Topic and Post are supported";
            throw new WebScriptException(400, error);
        }
        return model;
    }

    private void doUpdatePost(PostInfo post, TopicInfo topic, WebScriptRequest req, JSONObject json) {
        if (json.containsKey((Object)"title")) {
            String title = (String)json.get((Object)"title");
            post.setTitle(title);
            if (title.length() > 0) {
                topic.setTitle(title);
            }
        }
        if (json.containsKey((Object)"content")) {
            post.setContents((String)json.get((Object)"content"));
        }
        if (json.containsKey((Object)"tags")) {
            topic.getTags().clear();
            List<String> tags = this.getTags(json);
            if (tags != null) {
                topic.getTags().addAll(tags);
            }
        }
        this.discussionService.updateTopic(topic);
        this.discussionService.updatePost(post);
    }
}

