/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.discussion.TopicInfoImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.discussion.AbstractDiscussionWebScript;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ForumTopicsFilteredGet
extends AbstractDiscussionWebScript {
    protected static final String DEFAULT_TOPIC_AUTHOR = "mine";
    protected static final int DEFAULT_TOPIC_LATEST_POST_DAYS_AGO = 1;
    protected static final int DEFAULT_MAX_RESULTS = 10;
    protected static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    protected static final String SEARCH_QUERY = "TYPE:\"{http://www.alfresco.org/model/forum/1.0}post\" AND PATH:\"/app:company_home/st:sites/%s/cm:discussions/*/*\" AND @cm:created:[\"%s\" TO NOW]";
    private SearchService searchService;

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String siteName;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        SiteInfo site = null;
        if (templateVars.containsKey("site") && (site = this.siteService.getSite(siteName = (String)templateVars.get("site"))) == null) {
            String error = "Could not find site: " + siteName;
            throw new WebScriptException(404, error);
        }
        return this.executeImpl(site, null, null, null, req, null, null, null);
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef nodeRef, TopicInfo topic, PostInfo post, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (topic != null || post != null) {
            String error = "Can't list Topics inside an existing Topic or Post";
            throw new WebScriptException(400, error);
        }
        String pAuthor = req.getParameter("topics");
        String author = DEFAULT_TOPIC_AUTHOR;
        if (pAuthor != null) {
            author = pAuthor;
        }
        String pDaysAgo = req.getParameter("history");
        int daysAgo = 1;
        if (pDaysAgo != null) {
            try {
                daysAgo = Integer.parseInt(pDaysAgo);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        Pair<String, String> searchQuery = this.getSearchQuery(site, author, daysAgo);
        PagingRequest paging = this.buildPagingRequest(req);
        PagingResults<TopicInfo> topics = this.doSearch(searchQuery, false, paging);
        Map<String, Object> model = this.buildCommonModel(site, topic, post, req);
        model.put("data", this.renderTopics(topics, paging, site));
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PagingResults<TopicInfo> doSearch(Pair<String, String> searchQuery, boolean sortAscending, PagingRequest paging) {
        ResultSet resultSet = null;
        PagingResults<TopicInfo> pagedResults = new PagingResults<TopicInfo>();
        String sortOn = "@{http://www.alfresco.org/model/content/1.0}created";
        SearchParameters sp = new SearchParameters();
        sp.addStore(SPACES_STORE);
        sp.setQuery((String)searchQuery.getFirst());
        sp.setLanguage((String)searchQuery.getSecond());
        sp.addSort(sortOn, sortAscending);
        if (paging.getMaxItems() > 0) {
            sp.setLimit(paging.getMaxItems() * 10);
            sp.setLimitBy(LimitBy.FINAL_SIZE);
        }
        if (paging.getSkipCount() > 0) {
            sp.setSkipCount(paging.getSkipCount());
        }
        try {
            resultSet = this.searchService.query(sp);
            pagedResults = this.wrap(resultSet, paging);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
        }
        return pagedResults;
    }

    protected Pair<String, String> getSearchQuery(SiteInfo site, String author, int daysAgo) {
        String search = String.format(SEARCH_QUERY, site != null ? "cm:" + site.getShortName() : "*", this.getDateXDaysAgo(daysAgo));
        if (author.equals(DEFAULT_TOPIC_AUTHOR)) {
            search = search + " AND @cm:creator:\"" + AuthenticationUtil.getFullyAuthenticatedUser() + "\"";
        }
        Pair searchQuery = new Pair((Object)search, (Object)"fts-alfresco");
        return searchQuery;
    }

    protected String getDateXDaysAgo(int daysAgo) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, daysAgo * -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(calendar.getTime());
    }

    @Override
    protected PagingRequest buildPagingRequest(WebScriptRequest req) {
        String pResultSize = req.getParameter("resultSize");
        int resultSize = 10;
        if (pResultSize != null) {
            try {
                resultSize = Integer.parseInt(pResultSize);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return new ScriptPagingDetails(req, resultSize);
    }

    protected PagingResults<TopicInfo> wrap(final ResultSet finalResults, PagingRequest paging) {
        int maxItems = paging.getMaxItems();
        Comparator<TopicInfo> lastPostDesc = new Comparator<TopicInfo>(){

            @Override
            public int compare(TopicInfo t1, TopicInfo t2) {
                Date t1LastPostDate = t1.getCreatedAt();
                if (ForumTopicsFilteredGet.this.discussionService.getMostRecentPost(t1) != null) {
                    t1LastPostDate = ForumTopicsFilteredGet.this.discussionService.getMostRecentPost(t1).getCreatedAt();
                }
                Date t2LastPostDate = t2.getCreatedAt();
                if (ForumTopicsFilteredGet.this.discussionService.getMostRecentPost(t2) != null) {
                    t2LastPostDate = ForumTopicsFilteredGet.this.discussionService.getMostRecentPost(t2).getCreatedAt();
                }
                return t2LastPostDate.compareTo(t1LastPostDate);
            }
        };
        final TreeSet<TopicInfo> topics = new TreeSet<TopicInfo>(lastPostDesc);
        for (ResultSetRow row : finalResults) {
            Pair pair = this.discussionService.getForNodeRef(row.getNodeRef());
            TopicInfo topic = (TopicInfo)pair.getFirst();
            if (topic == null) continue;
            String path = this.nodeService.getPath(topic.getNodeRef()).toDisplayPath(this.nodeService, this.permissionService);
            String site = path.split("/")[3];
            TopicInfoImpl tii = (TopicInfoImpl)topic;
            tii.setShortSiteName(site);
            topics.add((TopicInfo)tii);
            if (topics.size() < maxItems) continue;
            break;
        }
        return new PagingResults<TopicInfo>(){

            public boolean hasMoreItems() {
                try {
                    return finalResults.hasMore();
                }
                catch (UnsupportedOperationException e) {
                    return false;
                }
            }

            public Pair<Integer, Integer> getTotalResultCount() {
                int skipCount = 0;
                int itemsRemainingAfterThisPage = 0;
                try {
                    skipCount = finalResults.getStart();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                try {
                    itemsRemainingAfterThisPage = finalResults.length();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                int totalItemsInUnpagedResultSet = skipCount + itemsRemainingAfterThisPage;
                return new Pair((Object)totalItemsInUnpagedResultSet, (Object)totalItemsInUnpagedResultSet);
            }

            public List<TopicInfo> getPage() {
                return new ArrayList<TopicInfo>(topics);
            }

            public String getQueryExecutionId() {
                return null;
            }
        };
    }
}

