/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facebook;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.web.scripts.facebook.FacebookAPIRuntime;
import org.alfresco.repo.web.scripts.facebook.FacebookAppModel;
import org.alfresco.repo.web.scripts.facebook.FacebookService;
import org.alfresco.repo.web.scripts.facebook.FacebookServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.StatusTemplate;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;

public class FacebookServletRuntime
extends FacebookAPIRuntime {
    private static final Log logger = LogFactory.getLog(FacebookServletRuntime.class);
    protected FacebookService facebookService;

    public FacebookServletRuntime(RuntimeContainer container, ServletAuthenticatorFactory authFactory, HttpServletRequest req, HttpServletResponse res, ServerProperties serverProperties, FacebookService facebookService) {
        super(container, authFactory, req, res, serverProperties);
        this.facebookService = facebookService;
    }

    @Override
    protected WebScriptRequest createRequest(Match match) {
        FacebookServletRequest fbreq = new FacebookServletRequest((Runtime)this, this.req, match, this.serverProperties, this.getScriptUrl());
        if (match != null) {
            FacebookAppModel appModel = this.facebookService.getAppModel(fbreq.getApiKey());
            fbreq.setSecretKey(appModel.getSecret());
            fbreq.setAppId(appModel.getId());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Facebook request [apiKey=" + fbreq.getApiKey() + ", user=" + fbreq.getUserId() + ", session=" + fbreq.getSessionKey() + ", secret=" + fbreq.getSecretKey() + "]"));
        }
        this.servletReq = fbreq;
        return this.servletReq;
    }

    protected String getScriptUrl() {
        return "/facebook" + super.getScriptUrl();
    }

    protected StatusTemplate getStatusCodeTemplate(int statusCode) {
        return new StatusTemplate("/fbml." + statusCode + ".ftl", "html");
    }

    protected StatusTemplate getStatusTemplate() {
        return new StatusTemplate("/fbml.status.ftl", "html");
    }
}

