/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.invitation.site.InviteInfo;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationExceptionNotFound;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class InviteByTicket
extends DeclarativeWebScript {
    private static final String PARAM_INVITEE_USER_NAME = "inviteeUserName";
    private ServiceRegistry serviceRegistry;
    private SiteService siteService;
    private InvitationService invitationService;
    private TenantService tenantService;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setInvitationService(InvitationService invitationService) {
        this.invitationService = invitationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    protected Map<String, Object> executeImpl(final WebScriptRequest req, final Status status) {
        String inviteeUserName;
        String tenantDomain = "";
        if (this.tenantService.isEnabled() && (inviteeUserName = req.getParameter(PARAM_INVITEE_USER_NAME)) != null) {
            tenantDomain = this.tenantService.getUserDomain(inviteeUserName);
        }
        String mtAwareSystemUser = this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain);
        Map ret = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return InviteByTicket.this.execute(req, status);
            }
        }, (String)mtAwareSystemUser);
        AuthenticationUtil.setRunAsUser((String)mtAwareSystemUser);
        return ret;
    }

    private Map<String, Object> execute(WebScriptRequest req, Status status) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        String inviteId = (String)req.getServiceMatch().getTemplateVars().get("inviteId");
        String inviteTicket = (String)req.getServiceMatch().getTemplateVars().get("inviteTicket");
        try {
            Invitation invitation = this.invitationService.getInvitation(inviteId);
            if (invitation instanceof NominatedInvitation) {
                NominatedInvitation theInvitation = (NominatedInvitation)invitation;
                String ticket = theInvitation.getTicket();
                if (ticket == null || !ticket.equals(inviteTicket)) {
                    throw new WebScriptException(404, "Ticket mismatch");
                }
                model.put("invite", this.toInviteInfo(theInvitation));
                return model;
            }
            throw new WebScriptException(403, "Not a nominated invitation");
        }
        catch (InvitationExceptionNotFound nfe) {
            throw new WebScriptException(404, "No invite found for given id");
        }
    }

    private InviteInfo toInviteInfo(NominatedInvitation invitation) {
        PersonService personService = this.serviceRegistry.getPersonService();
        SiteInfo siteInfo = this.siteService.getSite(invitation.getResourceName());
        String invitationStatus = "pending";
        NodeRef inviterRef = personService.getPerson(invitation.getInviterUserName());
        TemplateNode inviterPerson = null;
        if (inviterRef != null) {
            inviterPerson = new TemplateNode(inviterRef, this.serviceRegistry, null);
        }
        NodeRef inviteeRef = personService.getPerson(invitation.getInviteeUserName());
        TemplateNode inviteePerson = null;
        if (inviteeRef != null) {
            inviteePerson = new TemplateNode(inviteeRef, this.serviceRegistry, null);
        }
        InviteInfo ret = new InviteInfo(invitationStatus, invitation.getInviterUserName(), inviterPerson, invitation.getInviteeUserName(), inviteePerson, invitation.getRoleName(), invitation.getResourceName(), siteInfo, invitation.getSentInviteDate(), invitation.getInviteId());
        return ret;
    }
}

