/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.invite;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.invitation.WorkflowModelNominatedInvitation;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.apache.commons.lang.RandomStringUtils;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class InviteServiceTest
extends BaseWebScriptTest {
    private AuthorityService authorityService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private WorkflowService workflowService;
    private MutableAuthenticationDao mutableAuthenticationDao;
    private NamespaceService namespaceService;
    private TransactionService transactionService;
    private List<String> inviteeEmailAddrs;
    private static final String WF_DEFINITION_INVITE = "jbpm$inwf:invitation-nominated";
    private static final String USER_INVITER = "InviterUser";
    private static final String USER_INVITER_2 = "InviterUser2";
    private static final String INVITEE_FIRSTNAME = "InviteeFirstName";
    private static final String INVITEE_LASTNAME = "InviteeLastName";
    private static final String INVITER_EMAIL = "FirstName123.LastName123@email.com";
    private static final String INVITER_EMAIL_2 = "FirstNameabc.LastNameabc@email.com";
    private static final String INVITEE_EMAIL_DOMAIN = "alfrescotesting.com";
    private static final String INVITEE_EMAIL_PREFIX = "invitee";
    private static final String INVITEE_SITE_ROLE = "SiteCollaborator";
    private static final String SITE_SHORT_NAME_INVITE_1 = "SiteOneInviteTest";
    private static final String SITE_SHORT_NAME_INVITE_2 = "SiteTwoInviteTest";
    private static final String SITE_SHORT_NAME_INVITE_3 = "SiteThreeInviteTest";
    private static final String URL_INVITE = "/api/invite";
    private static final String URL_INVITES = "/api/invites";
    private static final String INVITE_ACTION_START = "start";
    private static final String INVITE_ACTION_CANCEL = "cancel";
    public static String PERSON_FIRSTNAME = "FirstName123";
    public static String PERSON_LASTNAME = "LastName123";
    public static String PERSON_JOBTITLE = "JobTitle123";
    public static String PERSON_ORG = "Organisation123";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.clearCurrentSecurityContext();
        this.authorityService = (AuthorityService)this.getServer().getApplicationContext().getBean("AuthorityService");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("AuthenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.siteService = (SiteService)this.getServer().getApplicationContext().getBean("SiteService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.workflowService = (WorkflowService)this.getServer().getApplicationContext().getBean("WorkflowService");
        this.mutableAuthenticationDao = (MutableAuthenticationDao)this.getServer().getApplicationContext().getBean("authenticationDao");
        this.namespaceService = (NamespaceService)this.getServer().getApplicationContext().getBean("NamespaceService");
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("TransactionService");
        InviteServiceTest.configureMailExecutorForTestMode(this.getServer());
        WorkflowDefinition inviteWfDefinition = this.workflowService.getDefinitionByName("jbpm$" + WorkflowModelNominatedInvitation.WF_PROCESS_INVITE.toPrefixString((NamespacePrefixResolver)this.namespaceService));
        this.workflowService.undeployDefinition(inviteWfDefinition.id);
        ClassPathResource inviteWfResource = new ClassPathResource("alfresco/workflow/invitation-nominated_processdefinition.xml");
        this.workflowService.deployDefinition("jbpm", inviteWfResource.getInputStream(), "text/xml");
        this.inviteeEmailAddrs = new ArrayList<String>();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, InviteServiceTest.USER_INVITER, InviteServiceTest.INVITER_EMAIL);
                        InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, InviteServiceTest.USER_INVITER_2, InviteServiceTest.INVITER_EMAIL_2);
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                String residuallyAuthenticatedUser = AuthenticationUtil.getFullyAuthenticatedUser();
                Assert.assertNull((String)("Residual authentication on context-initiating thread (this thread):" + residuallyAuthenticatedUser), (Object)residuallyAuthenticatedUser);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        String inviterSiteRole;
                        SiteInfo siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_1);
                        if (siteInfo == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_1, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_2)) == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_2, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((siteInfo = InviteServiceTest.this.siteService.getSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_3)) == null) {
                            InviteServiceTest.this.siteService.createSite("InviteSitePreset", InviteServiceTest.SITE_SHORT_NAME_INVITE_3, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.PUBLIC);
                        }
                        if ((inviterSiteRole = InviteServiceTest.this.siteService.getMembersRole(InviteServiceTest.SITE_SHORT_NAME_INVITE_3, InviteServiceTest.USER_INVITER_2)) == null || !inviterSiteRole.equals(InviteServiceTest.INVITEE_SITE_ROLE)) {
                            InviteServiceTest.this.siteService.setMembership(InviteServiceTest.SITE_SHORT_NAME_INVITE_3, InviteServiceTest.USER_INVITER_2, InviteServiceTest.INVITEE_SITE_ROLE);
                        }
                        return null;
                    }
                }, (String)InviteServiceTest.USER_INVITER);
                InviteServiceTest.this.authenticationComponent.setCurrentUser(InviteServiceTest.USER_INVITER);
                return null;
            }
        });
    }

    public static void configureMailExecutorForTestMode(TestWebScriptServer server) {
        ChildApplicationContextFactory outboundSmptSubsystem = (ChildApplicationContextFactory)server.getApplicationContext().getBean("OutboundSMTP");
        ApplicationContext childAppCtxt = outboundSmptSubsystem.getApplicationContext();
        MailActionExecuter mailActionExecutor = (MailActionExecuter)childAppCtxt.getBean("mail");
        mailActionExecutor.setTestMode(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.RunAsWork<Object> runAsWork = new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        InviteServiceTest.this.deletePersonByUserName(InviteServiceTest.USER_INVITER);
                        for (String inviteeEmail : InviteServiceTest.this.inviteeEmailAddrs) {
                            Set people = InviteServiceTest.this.personService.getPeopleFilteredByProperty(ContentModel.PROP_EMAIL, (Serializable)((Object)inviteeEmail), 1000);
                            for (NodeRef person : people) {
                                String userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)InviteServiceTest.this.nodeService.getProperty(person, ContentModel.PROP_USERNAME));
                                InviteServiceTest.this.deletePersonByUserName(userName);
                            }
                        }
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_1);
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_2);
                        InviteServiceTest.this.siteService.deleteSite(InviteServiceTest.SITE_SHORT_NAME_INVITE_3);
                        Thread.sleep(5000L);
                        return null;
                    }
                };
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)runAsWork, (String)AuthenticationUtil.getSystemUserName());
                WorkflowDefinition wfDef = InviteServiceTest.this.workflowService.getDefinitionByName(InviteServiceTest.WF_DEFINITION_INVITE);
                List workflowList = InviteServiceTest.this.workflowService.getActiveWorkflows(wfDef.id);
                for (WorkflowInstance workflow : workflowList) {
                    InviteServiceTest.this.workflowService.cancelWorkflow(workflow.id);
                }
                return null;
            }
        });
    }

    private void createPerson(String firstName, String lastName, String userName, String emailAddress) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)firstName);
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)lastName);
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)emailAddress);
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)PERSON_JOBTITLE);
            personProps.put((Object)ContentModel.PROP_ORGANIZATION, (Object)PERSON_ORG);
            this.personService.createPerson((Map)personProps);
        }
    }

    private void deletePersonByUserName(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }

    private JSONObject startInvite(String inviteeFirstName, String inviteeLastName, String inviteeEmail, String inviteeSiteRole, String siteShortName, int expectedStatus) throws Exception {
        this.inviteeEmailAddrs.add(inviteeEmail);
        String startInviteUrl = "/api/invite/start?inviteeFirstName=" + inviteeFirstName + "&inviteeLastName=" + inviteeLastName + "&inviteeEmail=" + URLEncoder.encode((String)inviteeEmail) + "&siteShortName=" + siteShortName + "&inviteeSiteRole=" + inviteeSiteRole + "&serverPath=" + "http://localhost:8081/share/" + "&acceptUrl=" + "page/accept-invite" + "&rejectUrl=" + "page/reject-invite";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(startInviteUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject startInvite(String inviteeFirstName, String inviteeLastName, String inviteeSiteRole, String siteShortName, int expectedStatus) throws Exception {
        String inviteeEmail = INVITEE_EMAIL_PREFIX + RandomStringUtils.randomAlphanumeric((int)6) + "@" + INVITEE_EMAIL_DOMAIN;
        return this.startInvite(inviteeFirstName, inviteeLastName, inviteeEmail, inviteeSiteRole, siteShortName, expectedStatus);
    }

    private JSONObject cancelInvite(String inviteId, int expectedStatus) throws Exception {
        String cancelInviteUrl = "/api/invite/cancel?inviteId=" + inviteId;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(cancelInviteUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject rejectInvite(String inviteId, String inviteTicket, int expectedStatus) throws Exception {
        String rejectInviteUrl = "/api/invite/" + inviteId + "/" + inviteTicket + "/reject";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(rejectInviteUrl, (byte[])null, null), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviteId(String inviteId, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviteId=" + inviteId;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviterUserName(String inviterUserName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviterUserName=" + inviterUserName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesByInviteeUserName(String inviteeUserName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?inviteeUserName=" + inviteeUserName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONObject getInvitesBySiteShortName(String siteShortName, int expectedStatus) throws Exception {
        String getInvitesUrl = "/api/invites?siteShortName=" + siteShortName;
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(getInvitesUrl), expectedStatus);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    public void testStartInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        InviteServiceTest.assertEquals((Object)INVITE_ACTION_START, (Object)result.get("action"));
        InviteServiceTest.assertEquals((Object)INVITEE_FIRSTNAME, (Object)result.get("inviteeFirstName"));
        InviteServiceTest.assertEquals((Object)INVITEE_LASTNAME, (Object)result.get("inviteeLastName"));
        InviteServiceTest.assertEquals((Object)this.inviteeEmailAddrs.get(this.inviteeEmailAddrs.size() - 1), (Object)result.get("inviteeEmail"));
        InviteServiceTest.assertEquals((Object)SITE_SHORT_NAME_INVITE_1, (Object)result.get("siteShortName"));
    }

    public void testStartInviteWhenInviteeIsAlreadyMemberOfSite() throws Exception {
        String randomStr = RandomStringUtils.randomNumeric((int)6);
        final String inviteeUserName = "inviteeUserName" + randomStr;
        final String inviteeEmailAddr = INVITEE_EMAIL_PREFIX + randomStr + "@" + INVITEE_EMAIL_DOMAIN;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(InviteServiceTest.INVITEE_FIRSTNAME, InviteServiceTest.INVITEE_LASTNAME, inviteeUserName, inviteeEmailAddr);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.siteService.setMembership(InviteServiceTest.SITE_SHORT_NAME_INVITE_1, inviteeUserName, InviteServiceTest.INVITEE_SITE_ROLE);
                return null;
            }
        }, (String)USER_INVITER);
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 409);
        this.startInvite(INVITEE_FIRSTNAME, "Belzebub", inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        this.startInvite("Lucifer", INVITEE_LASTNAME, inviteeEmailAddr, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
    }

    public void testStartInviteForSameInviteeButTwoDifferentSites() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteeEmail = (String)result.get("inviteeEmail");
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_2, 200);
    }

    public void testCancelInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteId = result.getString("inviteId");
        this.cancelInvite(inviteId, 200);
    }

    public void testAcceptInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteId = result.getString("inviteId");
        String inviteTicket = result.getString("inviteTicket");
        String acceptInviteUrl = "/api/invite/" + inviteId + "/" + inviteTicket + "/accept";
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(acceptInviteUrl, (byte[])null, null), 200);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(acceptInviteUrl, (byte[])null, null), 409);
        this.rejectInvite(inviteId, inviteTicket, 409);
        this.authenticationComponent.setCurrentUser(USER_INVITER);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
    }

    public void testRejectInvite() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteId = result.getString("inviteId");
        String inviteTicket = result.getString("inviteTicket");
        this.rejectInvite(inviteId, inviteTicket, 200);
        this.rejectInvite(inviteId, inviteTicket, 409);
        this.authenticationComponent.setCurrentUser(USER_INVITER);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
    }

    public void testGetInvitesByInviteId() throws Exception {
        JSONObject startInviteResult = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteId = startInviteResult.getString("inviteId");
        InviteServiceTest.assertEquals((boolean)true, (inviteId != null && inviteId.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesByInviteId(inviteId, 200);
        InviteServiceTest.assertEquals((int)getInvitesResult.getJSONArray("invites").length(), (int)1);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)inviteId, (Object)inviteJSONObj.get("inviteId"));
    }

    public void testGetInvitesByInviterUserName() throws Exception {
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        JSONObject getInvitesResult = this.getInvitesByInviterUserName(USER_INVITER, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)USER_INVITER, (Object)inviteJSONObj.getJSONObject("inviter").get("userName"));
    }

    public void testGetInvitesByInviteeUserName() throws Exception {
        JSONObject startInviteResult = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteeUserName = startInviteResult.getString("inviteeUserName");
        InviteServiceTest.assertEquals((boolean)true, (inviteeUserName != null && inviteeUserName.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesByInviteeUserName(inviteeUserName, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)inviteeUserName, (Object)inviteJSONObj.getJSONObject(INVITEE_EMAIL_PREFIX).get("userName"));
    }

    public void testGetInvitesBySiteShortName() throws Exception {
        JSONObject startInviteResult = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String siteShortName = startInviteResult.getString("siteShortName");
        InviteServiceTest.assertEquals((boolean)true, (siteShortName != null && siteShortName.length() != 0 ? 1 : 0) != 0);
        JSONObject getInvitesResult = this.getInvitesBySiteShortName(siteShortName, 200);
        InviteServiceTest.assertEquals((boolean)true, (getInvitesResult.getJSONArray("invites").length() > 0 ? 1 : 0) != 0);
        JSONObject inviteJSONObj = getInvitesResult.getJSONArray("invites").getJSONObject(0);
        InviteServiceTest.assertEquals((Object)siteShortName, (Object)inviteJSONObj.getJSONObject("site").get("shortName"));
    }

    public void testStartInviteForbiddenWhenInviterNotSiteManager() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_INVITER_2);
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_3, 403);
    }

    public void testCancelInviteForbiddenWhenInviterNotSiteManager() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_3, 200);
        String inviteId = result.getString("inviteId");
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_INVITER_2);
        this.cancelInvite(inviteId, 403);
    }

    public void testInviteeResourcesDeletedUponRejectWhenNoInvitePending() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String inviteId = result.getString("inviteId");
        String inviteTicket = result.getString("inviteTicket");
        final String inviteeUserName = result.getString("inviteeUserName");
        this.rejectInvite(inviteId, inviteTicket, 200);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                InviteServiceTest.this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                    public Void execute() throws Throwable {
                        Assert.assertEquals((boolean)false, (boolean)InviteServiceTest.this.mutableAuthenticationDao.userExists(inviteeUserName));
                        Assert.assertEquals((boolean)false, (boolean)InviteServiceTest.this.personService.personExists(inviteeUserName));
                        return null;
                    }
                });
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void testInviteeResourcesNotDeletedUponRejectWhenInvitesPending() throws Exception {
        JSONObject result = this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 200);
        String invite1Id = result.getString("inviteId");
        String invite1Ticket = result.getString("inviteTicket");
        String inviteeEmail = result.getString("inviteeEmail");
        final String inviteeUserName = result.getString("inviteeUserName");
        this.startInvite(INVITEE_FIRSTNAME, INVITEE_LASTNAME, inviteeEmail, INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_2, 200);
        this.rejectInvite(invite1Id, invite1Ticket, 200);
        boolean inviteeUserExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                RetryingTransactionHelper tranHelper = InviteServiceTest.this.transactionService.getRetryingTransactionHelper();
                Boolean result = (Boolean)tranHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                    public Boolean execute() throws Throwable {
                        Boolean result = InviteServiceTest.this.mutableAuthenticationDao.userExists(inviteeUserName);
                        return result;
                    }
                });
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        InviteServiceTest.assertEquals((boolean)true, (boolean)inviteeUserExists);
        boolean inviteePersonExists = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                Boolean result = InviteServiceTest.this.personService.personExists(inviteeUserName);
                return result;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        InviteServiceTest.assertEquals((boolean)true, (boolean)inviteePersonExists);
    }

    public void testETHREEOH_520() throws Exception {
        final String userName = "userInviteServiceTest" + GUID.generate();
        String emailAddress = " ";
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                InviteServiceTest.this.createPerson(PERSON_FIRSTNAME, PERSON_LASTNAME, userName, " ");
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        this.startInvite(PERSON_FIRSTNAME, PERSON_LASTNAME, " ", INVITEE_SITE_ROLE, SITE_SHORT_NAME_INVITE_1, 400);
    }
}

