/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.links.LinksService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.json.JSONWriter;

public abstract class AbstractLinksWebScript
extends DeclarativeWebScript {
    public static final String LINKS_SERVICE_ACTIVITY_APP_NAME = "links";
    protected static final String PARAM_MESSAGE = "message";
    protected static final String PARAM_ITEM = "item";
    private static Log logger = LogFactory.getLog(AbstractLinksWebScript.class);
    protected NodeService nodeService;
    protected SiteService siteService;
    protected LinksService linksService;
    protected PersonService personService;
    protected ActivityService activityService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setLinksService(LinksService linksService) {
        this.linksService = linksService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    protected String getOrNull(JSONObject json, String key) {
        if (json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        return null;
    }

    protected List<String> getTags(JSONObject json) {
        ArrayList<String> tags = null;
        if (json.containsKey((Object)"tags")) {
            if (json.get((Object)"tags") instanceof String) {
                String tagsS = (String)json.get((Object)"tags");
                if ("".equals(tagsS)) {
                    return null;
                }
                logger.warn((Object)("Unexpected tag data: " + tagsS));
                return null;
            }
            tags = new ArrayList<String>();
            JSONArray jsTags = (JSONArray)json.get((Object)"tags");
            for (int i = 0; i < jsTags.size(); ++i) {
                tags.add((String)jsTags.get(i));
            }
        }
        return tags;
    }

    protected PagingRequest buildPagingRequest(WebScriptRequest req) {
        if (req.getParameter("page") == null || req.getParameter("pageSize") == null) {
            throw new WebScriptException(400, "Paging size parameters missing");
        }
        return new ScriptPagingDetails(req, 100);
    }

    protected void addActivityEntry(String event, LinkInfo link, SiteInfo site, WebScriptRequest req, JSONObject json) {
        String page = req.getParameter("page");
        if (page == null && json != null && json.containsKey((Object)"page")) {
            page = (String)json.get((Object)"page");
        }
        if (page == null) {
            page = LINKS_SERVICE_ACTIVITY_APP_NAME;
        }
        try {
            StringWriter activityJson = new StringWriter();
            JSONWriter activity = new JSONWriter((Writer)activityJson);
            activity.startObject();
            activity.writeValue("title", link.getTitle());
            activity.writeValue("page", page + "?linkId=" + link.getSystemName());
            activity.endObject();
            this.activityService.postActivity("org.alfresco.links.link-" + event, site.getShortName(), LINKS_SERVICE_ACTIVITY_APP_NAME, activityJson.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Error adding link " + event + " to activities feed"), (Throwable)e);
        }
    }

    protected Map<String, Object> renderLink(LinkInfo link) {
        String creatorO;
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("node", link.getNodeRef());
        res.put("name", link.getSystemName());
        res.put("title", link.getTitle());
        res.put("description", link.getDescription());
        res.put("url", link.getURL());
        res.put("createdOn", link.getCreatedAt());
        res.put("modifiedOn", link.getModifiedAt());
        res.put("tags", link.getTags());
        res.put("internal", link.isInternal());
        String creator = link.getCreator();
        if (creator == null) {
            creatorO = "";
        } else {
            NodeRef person = this.personService.getPerson(creator);
            creatorO = person;
        }
        res.put("creator", creatorO);
        for (String key : res.keySet()) {
            if (res.get(key) != null) continue;
            res.put(key, "");
        }
        return res;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String siteName;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        }
        if ((siteName = (String)templateVars.get("site")) == null) {
            siteName = req.getParameter("site");
        }
        if (siteName == null && json != null) {
            if (json.containsKey((Object)"siteid")) {
                siteName = (String)json.get((Object)"siteid");
            } else if (json.containsKey((Object)"site")) {
                siteName = (String)json.get((Object)"site");
            }
        }
        if (siteName == null) {
            String error = "No site given";
            throw new WebScriptException(400, error);
        }
        SiteInfo site = this.siteService.getSite(siteName);
        if (site == null) {
            String error = "Could not find site: " + siteName;
            throw new WebScriptException(404, error);
        }
        String linkName = (String)templateVars.get("path");
        return this.executeImpl(site, linkName, req, json, status, cache);
    }

    protected abstract Map<String, Object> executeImpl(SiteInfo var1, String var2, WebScriptRequest var3, JSONObject var4, Status var5, Cache var6);
}

