/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.links;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.links.AbstractLinksWebScript;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.site.SiteInfo;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class LinksDeletePost
extends AbstractLinksWebScript {
    private static final String MSG_NAME_NOT_FOUND = "links-delete.err.not.found";
    private static final String MSG_ACCESS_DENIED = "links-delete.access.denied";
    private static final String MSG_DELETED = "links-delete.msg.deleted";
    protected static final int RECENT_SEARCH_PERIOD_DAYS = 7;
    protected static final long ONE_DAY_MS = 86400000L;

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, String linkName, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        ResourceBundle rb = this.getResources();
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<LinkInfo> links = new ArrayList<LinkInfo>();
        if (json.containsKey((Object)"items")) {
            JSONArray items = (JSONArray)json.get((Object)"items");
            for (int i = 0; i < items.size(); ++i) {
                String name = (String)items.get(i);
                LinkInfo link = this.linksService.getLink(site.getShortName(), name);
                if (link == null) continue;
                links.add(link);
            }
        }
        if (links.size() == 0) {
            String message = "No valid link names supplied";
            status.setCode(404);
            status.setMessage(message);
            model.put("message", rb.getString(MSG_NAME_NOT_FOUND));
            return model;
        }
        for (LinkInfo link : links) {
            try {
                this.linksService.deleteLink(link);
            }
            catch (AccessDeniedException e) {
                String message = "You don't have permission to delete the link with name '" + link.getSystemName() + "'";
                status.setCode(403);
                status.setMessage(message);
                message = rb.getString(MSG_ACCESS_DENIED);
                model.put("message", MessageFormat.format(message, link.getSystemName()));
                return model;
            }
            this.addActivityEntry("deleted", link, site, req, json);
            String message = rb.getString(MSG_DELETED);
            model.put("message", MessageFormat.format(message, link.getNodeRef()));
        }
        model.put("siteId", site.getShortName());
        model.put("site", site);
        return model;
    }
}

