/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.node;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class NodeWebScripTest
extends BaseWebScriptTest {
    private static Log logger = LogFactory.getLog(NodeWebScripTest.class);
    private String TEST_SITE_NAME = "TestNodeSite";
    private SiteInfo TEST_SITE;
    private MutableAuthenticationService authenticationService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private PersonService personService;
    private SiteService siteService;
    private NodeService nodeService;
    private static final String USER_ONE = "UserOneSecondToo";
    private static final String USER_TWO = "UserTwoSecondToo";
    private static final String USER_THREE = "UserThreeStill";
    private static final String PASSWORD = "passwordTEST";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        AbstractRefreshableApplicationContext ctx = (AbstractRefreshableApplicationContext)this.getServer().getApplicationContext();
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("AuthenticationService");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.siteService = (SiteService)ctx.getBean("SiteService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.TEST_SITE = this.createSite(this.TEST_SITE_NAME);
        this.createUser(USER_ONE, true);
        this.createUser(USER_TWO, false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.siteService.deleteSite(this.TEST_SITE.getShortName());
        for (String user : new String[]{USER_ONE, USER_TWO, USER_THREE}) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            if (this.personService.personExists(user)) {
                this.personService.deletePerson(user);
            }
            if (!this.authenticationService.authenticationExists(user)) continue;
            this.authenticationService.deleteAuthentication(user);
        }
    }

    private SiteInfo createSite(final String shortName) {
        return (SiteInfo)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                if (NodeWebScripTest.this.siteService.getSite(shortName) != null) {
                    NodeWebScripTest.this.siteService.deleteSite(shortName);
                }
                SiteInfo site = NodeWebScripTest.this.siteService.createSite("Testing", shortName, shortName, null, SiteVisibility.PUBLIC);
                NodeWebScripTest.this.siteService.createContainer(shortName, "documentLibrary", ContentModel.TYPE_FOLDER, null);
                return site;
            }
        }, false, true);
    }

    private void createUser(String userName, boolean contributor) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
        if (this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.deleteAuthentication(userName);
        }
        this.authenticationService.createAuthentication(userName, PASSWORD.toCharArray());
        PropertyMap personProps = new PropertyMap();
        personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
        personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"First");
        personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"Last");
        personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
        personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
        this.personService.createPerson((Map)personProps);
        if (contributor) {
            this.siteService.setMembership(this.TEST_SITE_NAME, userName, "SiteContributor");
        } else {
            this.siteService.setMembership(this.TEST_SITE_NAME, userName, "SiteConsumer");
        }
    }

    private JSONObject asJSON(TestWebScriptServer.Response response) throws Exception {
        JSONParser p = new JSONParser();
        String json = response.getContentAsString();
        Object o = p.parse(json);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new IllegalArgumentException("Expected JSONObject, got " + o + " from " + json);
    }

    public void testFolderCreation() throws Exception {
        NodeRef siteDocLib = this.siteService.getContainer(this.TEST_SITE.getShortName(), "documentLibrary");
        String testFolderName = "testing";
        HashMap<QName, String> testFolderProps = new HashMap<QName, String>();
        testFolderProps.put(ContentModel.PROP_NAME, testFolderName);
        NodeRef testFolder = this.nodeService.createNode(siteDocLib, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"testing"), ContentModel.TYPE_FOLDER, testFolderProps).getChildRef();
        String testNodeName = "aNEWfolder";
        String testNodeTitle = "aTITLEforAfolder";
        String testNodeDescription = "DESCRIPTIONofAfolder";
        JSONObject jsonReq = null;
        JSONObject json = null;
        NodeRef folder = null;
        TestWebScriptServer.Request req = new TestWebScriptServer.Request("POST", "/api/node/folder/" + testFolder.getStoreRef().getProtocol() + "/" + testFolder.getStoreRef().getIdentifier() + "/" + testFolder.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals(null, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)testFolder, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/" + "documentLibrary");
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"description", (Object)testNodeDescription);
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals((Object)testNodeDescription, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)siteDocLib, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/" + "documentLibrary" + "/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"title", (Object)testNodeTitle);
        jsonReq.put((Object)"description", (Object)testNodeDescription);
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)testNodeTitle, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_TITLE));
        NodeWebScripTest.assertEquals((Object)testNodeDescription, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_DESCRIPTION));
        NodeWebScripTest.assertEquals((Object)testFolder, (Object)this.nodeService.getPrimaryParent(folder).getParentRef());
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/" + "documentLibrary" + "/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:folder");
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/" + "documentLibrary" + "/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:systemfolder");
        req.setBody(jsonReq.toString().getBytes());
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        NodeWebScripTest.assertEquals((Object)testNodeName, (Object)this.nodeService.getProperty(folder, ContentModel.PROP_NAME));
        NodeWebScripTest.assertEquals((Object)ContentModel.TYPE_SYSTEM_FOLDER, (Object)this.nodeService.getType(folder));
        this.nodeService.deleteNode(folder);
        req = new TestWebScriptServer.Request("POST", "/api/site/folder/" + this.TEST_SITE_NAME + "/" + "documentLibrary" + "/" + testFolderName);
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        jsonReq.put((Object)"type", (Object)"cm:content");
        req.setBody(jsonReq.toString().getBytes());
        this.sendRequest(req, 400);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        req = new TestWebScriptServer.Request("POST", "/api/node/folder/" + testFolder.getStoreRef().getProtocol() + "/" + testFolder.getStoreRef().getIdentifier() + "/" + testFolder.getId());
        jsonReq = new JSONObject();
        jsonReq.put((Object)"name", (Object)testNodeName);
        req.setBody(jsonReq.toString().getBytes());
        req.setType("application/json");
        json = this.asJSON(this.sendRequest(req, 200));
        NodeWebScripTest.assertNotNull((Object)json.get((Object)"nodeRef"));
        folder = new NodeRef((String)json.get((Object)"nodeRef"));
        NodeWebScripTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(folder));
        this.nodeService.deleteNode(folder);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        this.sendRequest(req, 403);
    }
}

