/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.nodelocator;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceInternal;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class NodeLocatorWebScriptTest
extends BaseWebScriptTest {
    private static final String baseURL = "api/nodelocator/";
    private SiteServiceInternal siteService;
    private NodeService nodeService;
    private Repository repositoryHelper;
    private NodeRef companyHome;
    private NamespaceService namespaceService;

    public void testCompanyHomeNodeLocator() throws Exception {
        String url = "api/nodelocator/companyhome";
        this.checkNodeLocator(url, this.companyHome);
    }

    public void testSitesHomeNodeLocator() throws Exception {
        String url = "api/nodelocator/siteshome";
        NodeRef sitesHome = this.siteService.getSiteRoot();
        this.checkNodeLocator(url, sitesHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDocLibNodeLocator() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        SiteInfo site = null;
        NodeRef companyChild = this.makeChildContentNode(this.companyHome);
        try {
            String siteName = "TestSite" + GUID.generate();
            site = this.siteService.createSite("", siteName, "Title", "Description", SiteVisibility.PUBLIC);
            NodeRef fooFolder = this.makeContainer(siteName, "Foo");
            NodeRef docLib = this.makeContainer(siteName, "documentLibrary");
            NodeRef fooChild = this.makeChildContentNode(fooFolder);
            NodeRef docLibChild = this.makeChildContentNode(docLib);
            String noNodeUrl = "api/nodelocator/doclib";
            this.checkNodeLocator(noNodeUrl, this.companyHome);
            String noSiteUrl = this.makeUrl(companyChild, "doclib");
            this.checkNodeLocator(noSiteUrl, this.companyHome);
            String docLibUrl = this.makeUrl(docLibChild, "doclib");
            this.checkNodeLocator(docLibUrl, docLib);
            String fooUrl = this.makeUrl(fooChild, "doclib");
            this.checkNodeLocator(fooUrl, docLib);
        }
        finally {
            this.nodeService.deleteNode(companyChild);
            if (site != null) {
                this.siteService.deleteSite(site.getShortName());
            }
        }
    }

    public void testUserHomeNodeLocator() throws Exception {
        String url = "api/nodelocator/userhome";
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        this.checkNodeLocator(url, null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef admin = this.repositoryHelper.getPerson();
        NodeRef userHome = this.repositoryHelper.getUserHome(admin);
        this.checkNodeLocator(url, userHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAncestorOfTypeNodeLocator() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef folder = this.makeChildFolderNode(this.companyHome);
        try {
            NodeRef sysFolder = this.makeChildSystemFolderNode(folder);
            NodeRef subFolder = this.makeChildFolderNode(sysFolder);
            NodeRef source = this.makeChildContentNode(subFolder);
            String ancestorUrl = this.makeUrl(source, "ancestor");
            this.checkNodeLocator(ancestorUrl, subFolder);
            String encodedContentType = URLEncoder.encode((String)ContentModel.TYPE_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            String contentAncestorUrl = ancestorUrl + "?type=" + encodedContentType;
            this.checkNodeLocator(contentAncestorUrl, null);
            String encodedSysFolderType = URLEncoder.encode((String)ContentModel.TYPE_SYSTEM_FOLDER.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            String sysFolderAncestorUrl = ancestorUrl + "?type=" + encodedSysFolderType;
            this.checkNodeLocator(sysFolderAncestorUrl, sysFolder);
            String encodedOwnableAspect = URLEncoder.encode((String)ContentModel.ASPECT_OWNABLE.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            String ownableAncestorUrl = ancestorUrl + "?aspect=" + encodedOwnableAspect;
            this.checkNodeLocator(ownableAncestorUrl, null);
            this.nodeService.addAspect(folder, ContentModel.ASPECT_OWNABLE, null);
            this.checkNodeLocator(ownableAncestorUrl, folder);
            String ownableSysFolderAncestorUrl = sysFolderAncestorUrl + "&aspect=" + encodedOwnableAspect;
            this.checkNodeLocator(ownableSysFolderAncestorUrl, null);
            String encodedFOlderType = URLEncoder.encode((String)ContentModel.TYPE_FOLDER.toPrefixString((NamespacePrefixResolver)this.namespaceService));
            String ownableFolderAncestorUrl = ownableAncestorUrl + "&type=" + encodedFOlderType;
            this.checkNodeLocator(ownableFolderAncestorUrl, folder);
        }
        finally {
            this.nodeService.deleteNode(folder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXPathNodeLocator() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        NodeRef first = this.makeChildFolderNode(this.companyHome);
        try {
            NodeRef second = this.makeChildFolderNode(first);
            NodeRef content = this.makeChildContentNode(second);
            String badPath = URLEncoder.encode((String)"cm:foo/cm:bar/cm:foobar");
            String badPathUrl = "api/nodelocator/xpath?query=" + badPath;
            this.checkNodeLocator(badPathUrl, null);
            String path = this.nodeService.getPath(content).toPrefixString((NamespacePrefixResolver)this.namespaceService);
            String encodedPath = URLEncoder.encode((String)path);
            String defaultStoreUrl = "api/nodelocator/xpath?query=" + encodedPath;
            this.checkNodeLocator(defaultStoreUrl, content);
            String storeIdUrl = defaultStoreUrl + "&store_type=workspace&store_id=SpacesStore";
            this.checkNodeLocator(storeIdUrl, content);
            String nodePathUrl = this.makeUrl(this.companyHome, "xpath") + "?query=" + encodedPath;
            this.checkNodeLocator(nodePathUrl, content);
        }
        finally {
            this.nodeService.deleteNode(first);
        }
    }

    private String makeUrl(NodeRef node, String locatorName) {
        StoreRef storeRef = node.getStoreRef();
        StringBuilder url = new StringBuilder("/api/");
        url.append(storeRef.getProtocol()).append("/").append(storeRef.getIdentifier()).append("/").append(node.getId()).append("/").append("nodelocator").append("/").append(locatorName);
        return url.toString();
    }

    private void checkNodeLocator(String url, NodeRef expNode) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        NodeLocatorWebScriptTest.assertNotNull((Object)result);
        String nodeRef = result.getString("nodeRef");
        String expResult = expNode == null ? "null" : expNode.toString();
        NodeLocatorWebScriptTest.assertEquals((String)expResult, (String)nodeRef);
    }

    private NodeRef makeChildContentNode(NodeRef parent) {
        return this.makeChildNode(parent, ContentModel.TYPE_CONTENT);
    }

    private NodeRef makeChildSystemFolderNode(NodeRef parent) {
        return this.makeChildNode(parent, ContentModel.TYPE_SYSTEM_FOLDER);
    }

    private NodeRef makeChildFolderNode(NodeRef parent) {
        return this.makeChildNode(parent, ContentModel.TYPE_FOLDER);
    }

    private NodeRef makeChildNode(NodeRef parent, QName type) {
        QName qName = QName.createQName((String)"", (String)GUID.generate());
        QName contains = ContentModel.ASSOC_CONTAINS;
        ChildAssociationRef result = this.nodeService.createNode(parent, contains, qName, type);
        return result.getChildRef();
    }

    private NodeRef makeContainer(String siteName, String containerId) {
        QName type = ContentModel.TYPE_FOLDER;
        return this.siteService.createContainer(siteName, containerId, type, null);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.siteService = (SiteServiceInternal)appContext.getBean("SiteService");
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.namespaceService = (NamespaceService)appContext.getBean("NamespaceService");
        this.repositoryHelper = (Repository)appContext.getBean("repositoryHelper");
        this.companyHome = this.repositoryHelper.getCompanyHome();
    }
}

