/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.person;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.lang.RandomStringUtils;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PersonServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "User.One";
    private static final String USER_TWO = "User.Two";
    private static final String USER_THREE = "User.Three";
    private static final String URL_PEOPLE = "/api/people";
    private List<String> createdPeople = new ArrayList<String>(5);

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.createUser(USER_THREE);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"myFirstName");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"myLastName");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"myFirstName.myLastName@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myJobTitle");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"myOrganisation");
            this.personService.createPerson((Map)personProps);
            this.createdPeople.add(userName);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        for (String userName : this.createdPeople) {
            this.personService.deletePerson(userName);
        }
        this.createdPeople.clear();
    }

    private JSONObject updatePerson(String userName, String title, String firstName, String lastName, String organisation, String jobTitle, String email, String bio, String avatarUrl, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)userName);
        person.put("title", (Object)title);
        person.put("firstName", (Object)firstName);
        person.put("lastName", (Object)lastName);
        person.put("organisation", (Object)organisation);
        person.put("jobtitle", (Object)jobTitle);
        person.put("email", (Object)email);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("/api/people/" + userName, person.toString(), "application/json"), expectedStatus);
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    private JSONObject createPerson(String userName, String title, String firstName, String lastName, String organisation, String jobTitle, String email, String bio, String avatarUrl, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        JSONObject person = new JSONObject();
        person.put("userName", (Object)userName);
        person.put("title", (Object)title);
        person.put("firstName", (Object)firstName);
        person.put("lastName", (Object)lastName);
        person.put("organisation", (Object)organisation);
        person.put("jobtitle", (Object)jobTitle);
        person.put("email", (Object)email);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_PEOPLE, person.toString(), "application/json"), expectedStatus);
        if (userName != null && userName.length() != 0) {
            this.createdPeople.add(userName);
        }
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    private JSONObject deletePerson(String userName, int expectedStatus) throws Exception {
        String currentUser = this.authenticationComponent.getCurrentUserName();
        String adminUser = this.authenticationComponent.getSystemUserName();
        this.authenticationComponent.setCurrentUser(adminUser);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("/api/people/" + userName), expectedStatus);
        this.createdPeople.remove(userName);
        this.authenticationComponent.setCurrentUser(currentUser);
        return new JSONObject(response.getContentAsString());
    }

    public void testGetPeople() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_PEOPLE), 200);
    }

    public void testGetPerson() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/nonExistantUser"), 404);
        String userName = RandomStringUtils.randomNumeric((int)6);
        JSONObject result = this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "myEmailAddress", "myBio", "images/avatar.jpg", 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/" + userName), 200);
    }

    public void testUpdatePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 200);
        JSONObject result = this.updatePerson(userName, "updatedTitle", "updatedFirstName", "updatedLastName", "updatedOrganisation", "updatedJobTitle", "updatedFN.updatedLN@email.com", "updatedBio", "images/updatedAvatar.jpg", 200);
        PersonServiceTest.assertEquals((Object)userName, (Object)result.get("userName"));
        PersonServiceTest.assertEquals((Object)"updatedFirstName", (Object)result.get("firstName"));
        PersonServiceTest.assertEquals((Object)"updatedLastName", (Object)result.get("lastName"));
        PersonServiceTest.assertEquals((Object)"updatedOrganisation", (Object)result.get("organization"));
        PersonServiceTest.assertEquals((Object)"updatedJobTitle", (Object)result.get("jobtitle"));
        PersonServiceTest.assertEquals((Object)"updatedFN.updatedLN@email.com", (Object)result.get("email"));
    }

    public void testDeletePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 200);
        this.deletePerson(userName, 200);
        this.deletePerson(userName, 404);
    }

    public void testCreatePerson() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        JSONObject result = this.createPerson(userName, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 200);
        PersonServiceTest.assertEquals((Object)userName, (Object)result.get("userName"));
        PersonServiceTest.assertEquals((Object)"myFirstName", (Object)result.get("firstName"));
        PersonServiceTest.assertEquals((Object)"myLastName", (Object)result.get("lastName"));
        PersonServiceTest.assertEquals((Object)"myOrganisation", (Object)result.get("organization"));
        PersonServiceTest.assertEquals((Object)"myJobTitle", (Object)result.get("jobtitle"));
        PersonServiceTest.assertEquals((Object)"firstName.lastName@email.com", (Object)result.get("email"));
        this.createPerson(userName, "myTitle", "myFirstName", "mylastName", "myOrganisation", "myJobTitle", "myEmail", "myBio", "images/avatar.jpg", 409);
    }

    public void testCreatePersonMissingUserName() throws Exception {
        this.createPerson(null, "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 400);
        this.createPerson("", "myTitle", "myFirstName", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 400);
    }

    public void testCreatePersonMissingFirstName() throws Exception {
        String userName = RandomStringUtils.randomNumeric((int)6);
        this.createPerson(userName, "myTitle", null, "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 400);
        this.createPerson(userName, "myTitle", "", "myLastName", "myOrganisation", "myJobTitle", "firstName.lastName@email.com", "myBio", "images/avatar.jpg", 400);
    }
}

