/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.preference;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PreferenceServiceTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private PersonService personService;
    private static final String USER_ONE = "PreferenceTestOne" + System.currentTimeMillis();
    private static final String USER_BAD = "PreferenceTestBad" + System.currentTimeMillis();
    private static final String URL = "/api/people/" + USER_ONE + "/preferences";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createUser(USER_ONE);
        this.createUser(USER_BAD);
        this.authenticationComponent.setCurrentUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
    }

    public void testPreferences() throws Exception {
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL), 200);
        JSONObject jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertFalse((boolean)jsonResult.keys().hasNext());
        JSONObject jsonObject = this.getPreferenceObj();
        jsonObject.put("comp1", (Object)this.getPreferenceObj());
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, jsonObject.toString(), "application/json"), 200);
        PreferenceServiceTest.assertEquals((int)0, (int)resp.getContentLength());
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL), 200);
        jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertTrue((boolean)jsonResult.keys().hasNext());
        this.checkJSONObject(jsonResult);
        this.checkJSONObject(jsonResult.getJSONObject("comp1"));
        jsonObject.put("stringValue", (Object)"updated");
        jsonObject.put("comp2", (Object)this.getPreferenceObj());
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL, jsonObject.toString(), "application/json"), 200);
        PreferenceServiceTest.assertEquals((int)0, (int)resp.getContentLength());
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL), 200);
        jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertTrue((boolean)jsonResult.keys().hasNext());
        jsonObject.put("stringValue", (Object)"updated");
        jsonObject.put("numberValue", 10);
        jsonObject.put("numberValue2", 3.142);
        this.checkJSONObject(jsonResult.getJSONObject("comp1"));
        this.checkJSONObject(jsonResult.getJSONObject("comp2"));
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL + "?pf=comp2"), 200);
        jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertTrue((boolean)jsonResult.keys().hasNext());
        this.checkJSONObject(jsonResult.getJSONObject("comp2"));
        PreferenceServiceTest.assertFalse((boolean)jsonResult.has("comp1"));
        PreferenceServiceTest.assertFalse((boolean)jsonResult.has("stringValue"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL + "?pf=comp1"), 200);
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL), 200);
        jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertTrue((boolean)jsonResult.keys().hasNext());
        this.checkJSONObject(jsonResult.getJSONObject("comp2"));
        PreferenceServiceTest.assertFalse((boolean)jsonResult.has("comp1"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL), 200);
        resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL), 200);
        jsonResult = new JSONObject(resp.getContentAsString());
        PreferenceServiceTest.assertNotNull((Object)jsonResult);
        PreferenceServiceTest.assertFalse((boolean)jsonResult.keys().hasNext());
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest("/api/people/" + USER_BAD + "/preferences", jsonObject.toString(), "application/json"), 401);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("/api/people/noExistUser/preferences"), 404);
    }

    private JSONObject getPreferenceObj() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("stringValue", (Object)"value");
        jsonObject.put("numberValue", 10);
        jsonObject.put("numberValue2", 3.142);
        return jsonObject;
    }

    private void checkJSONObject(JSONObject jsonObject) throws JSONException {
        PreferenceServiceTest.assertEquals((Object)"value", (Object)jsonObject.get("stringValue"));
        PreferenceServiceTest.assertEquals((Object)10, (Object)jsonObject.get("numberValue"));
        PreferenceServiceTest.assertEquals((Object)3.142, (Object)jsonObject.get("numberValue2"));
    }
}

