/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.web.scripts.publishing.ChannelAuthHelper;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AuthCallbackWebScript
extends DeclarativeWebScript {
    private static final Log log = LogFactory.getLog(AuthCallbackWebScript.class);
    private ChannelService channelService;
    private ChannelAuthHelper channelAuthHelper;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setChannelAuthHelper(ChannelAuthHelper channelAuthHelper) {
        this.channelAuthHelper = channelAuthHelper;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String channelNodeStoreId;
        Map templateVars = req.getServiceMatch().getTemplateVars();
        TreeMap<String, String[]> params = new TreeMap<String, String[]>();
        TreeMap<String, String[]> headers = new TreeMap<String, String[]>();
        for (String paramName : req.getParameterNames()) {
            params.put(paramName, req.getParameterValues(paramName));
        }
        for (String header : req.getHeaderNames()) {
            headers.put(header, req.getHeaderValues(header));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("templateVars = " + templateVars));
            log.debug((Object)("params = " + params));
            log.debug((Object)("headers = " + headers));
        }
        String channelNodeUuid = (String)templateVars.get("node_id");
        String channelNodeStoreProtocol = (String)templateVars.get("store_protocol");
        NodeRef channelNodeRef = new NodeRef(channelNodeStoreProtocol, channelNodeStoreId = (String)templateVars.get("store_id"), channelNodeUuid);
        Channel channel = this.channelService.getChannelById(channelNodeRef.toString());
        ChannelType.AuthStatus authStatus = channel.getChannelType().acceptAuthorisationCallback(channel, headers, params);
        if (ChannelType.AuthStatus.RETRY.equals((Object)authStatus)) {
            ChannelType.AuthUrlPair authoriseUrls = channel.getChannelType().getAuthorisationUrls(channel, this.channelAuthHelper.getAuthoriseCallbackUrl(channelNodeRef));
            String authRequestUrl = authoriseUrls.authorisationRequestUrl;
            if (authRequestUrl == null) {
                authRequestUrl = this.channelAuthHelper.getDefaultAuthoriseUrl(channelNodeRef);
            }
            status.setCode(302);
            status.setLocation(authRequestUrl);
        }
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        model.put("authStatus", authStatus.name());
        return model;
    }
}

