/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.UrlUtil;

public class ChannelAuthHelper {
    private String basePath = "/proxy/alfresco/api/publishing/channels/";
    private SysAdminParams sysAdminParams;

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBaseChannelApiUrl(NodeRef channelId) {
        StringBuilder urlBuilder = new StringBuilder(UrlUtil.getShareUrl((SysAdminParams)this.sysAdminParams));
        urlBuilder.append(this.basePath);
        urlBuilder.append(channelId.getStoreRef().getProtocol());
        urlBuilder.append('/');
        urlBuilder.append(channelId.getStoreRef().getIdentifier());
        urlBuilder.append('/');
        urlBuilder.append(channelId.getId());
        urlBuilder.append('/');
        return urlBuilder.toString();
    }

    public String getDefaultAuthoriseUrl(NodeRef channelId) {
        return this.getBaseChannelApiUrl(channelId) + "authform";
    }

    public String getAuthoriseCallbackUrl(NodeRef channelId) {
        return this.getBaseChannelApiUrl(channelId) + "authcallback";
    }

    public Map<String, Object> buildAuthorisationModel(Channel channel) {
        String alfrescoCallbackUrl = this.getAuthoriseCallbackUrl(channel.getNodeRef());
        ChannelType.AuthUrlPair authUrlPair = channel.getChannelType().getAuthorisationUrls(channel, alfrescoCallbackUrl);
        String authoriseUrl = authUrlPair.authorisationRequestUrl;
        if (authoriseUrl == null) {
            authoriseUrl = this.getDefaultAuthoriseUrl(channel.getNodeRef());
        }
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        model.put("authoriseUrl", authoriseUrl);
        model.put("channelId", channel.getId());
        model.put("authCallbackUrl", alfrescoCallbackUrl);
        model.put("authRedirectUrl", authUrlPair.authorisationRedirectUrl);
        return model;
    }
}

