/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.Map;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.publishing.PublishingJsonParser;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ChannelPut
extends AbstractWebScript {
    private static final String CHANNEL_ID = "channel_id";
    private final PublishingJsonParser parser = new PublishingJsonParser();
    private ChannelService channelService;

    public void execute(WebScriptRequest req, WebScriptResponse res) {
        Map params = req.getServiceMatch().getTemplateVars();
        String channelId = URLDecoder.decode((String)((String)params.get(CHANNEL_ID)));
        Channel channel = this.channelService.getChannelById(channelId);
        if (channel == null) {
            String msg = "No channel found for ID: " + channelId;
            throw new WebScriptException(400, msg);
        }
        String content = null;
        try {
            content = WebScriptUtil.getContent(req);
            if (content == null || content.isEmpty()) {
                throw new WebScriptException(400, "No publishing event was posted!");
            }
            this.parser.updateChannel(channel, content, this.channelService);
        }
        catch (Exception e) {
            String msg = "Failed to Rename Channel: " + channelId + ". POST body: " + content;
            throw new WebScriptException(500, msg, (Throwable)e);
        }
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }
}

