/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.springframework.core.io.Resource;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class ChannelTypeIconGetWebScript
extends AbstractWebScript {
    private ChannelService channelService;
    private MimetypeService mimetypeService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        res.setContentType("text/html");
        res.setContentEncoding("UTF-8");
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String channelTypeId = (String)templateVars.get("channelType");
        String iconSize = (String)templateVars.get("iconSize");
        if (channelTypeId == null || iconSize == null) {
            res.setStatus(400);
            return;
        }
        ChannelType channelType = this.channelService.getChannelType(channelTypeId);
        if (channelType == null) {
            res.setStatus(404);
            return;
        }
        Resource iconFile = channelType.getIcon(iconSize);
        if (iconFile == null || !iconFile.exists()) {
            res.setStatus(404);
            return;
        }
        res.setHeader("Content-Length", "" + iconFile.contentLength());
        String filename = iconFile.getFilename();
        int lastDot = filename.lastIndexOf(46);
        String ext = "bin";
        if (lastDot != -1 && lastDot < filename.length() - 1) {
            ext = filename.substring(lastDot);
        }
        String mimeType = this.mimetypeService.getMimetype(ext);
        res.setContentType(mimeType);
        OutputStream out = res.getOutputStream();
        InputStream in = iconFile.getInputStream();
        FileCopyUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
    }
}

