/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class ChannelsDeleteWebScript
extends AbstractWebScript {
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String channelNodeUuid = (String)templateVars.get("node_id");
        String channelNodeStoreProtocol = (String)templateVars.get("store_protocol");
        String channelNodeStoreId = (String)templateVars.get("store_id");
        if (channelNodeStoreId == null || channelNodeStoreProtocol == null || channelNodeUuid == null) {
            res.setStatus(400);
            return;
        }
        NodeRef channelNodeRef = new NodeRef(channelNodeStoreProtocol, channelNodeStoreId, channelNodeUuid);
        Channel channel = this.channelService.getChannelById(channelNodeRef.toString());
        if (channel == null) {
            res.setStatus(404);
            return;
        }
        try {
            this.channelService.deleteChannel(channel);
        }
        catch (AccessDeniedException ex) {
            res.setStatus(401);
        }
    }
}

