/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.publishing.PublishingModelBuilder;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.urlshortening.UrlShortener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ChannelsGet
extends DeclarativeWebScript {
    private final PublishingModelBuilder builder = new PublishingModelBuilder();
    private ChannelService channelService;
    private UrlShortener urlShortener;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        List statusUpdateChannels;
        List publishingChannels;
        Map params = req.getServiceMatch().getTemplateVars();
        NodeRef node = WebScriptUtil.getNodeRef(params);
        if (node == null) {
            publishingChannels = this.channelService.getPublishingChannels(false);
            statusUpdateChannels = this.channelService.getStatusUpdateChannels(false);
        } else {
            publishingChannels = this.channelService.getRelevantPublishingChannels(node);
            statusUpdateChannels = this.channelService.getStatusUpdateChannels(true);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("urlLength", this.urlShortener.getUrlLength() + 1);
        model.put("publishChannels", this.builder.buildChannels(publishingChannels));
        model.put("statusUpdateChannels", this.builder.buildChannels(statusUpdateChannels));
        return WebScriptUtil.createBaseModel(model);
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setUrlShortener(UrlShortener urlShortener) {
        this.urlShortener = urlShortener;
    }
}

