/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.publishing.PublishingWebScript;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class PublishingEventsGet
extends PublishingWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map params = req.getServiceMatch().getTemplateVars();
        NodeRef node = WebScriptUtil.getNodeRef(params);
        if (node == null) {
            String msg = "A valid NodeRef must be specified!";
            throw new WebScriptException(400, msg);
        }
        try {
            ArrayList<PublishingEvent> events = this.getSortedPublishingEvents(node);
            List<Map<String, Object>> model = this.builder.buildPublishingEventsForNode(events, node, this.channelService);
            return WebScriptUtil.createBaseModel(model);
        }
        catch (Exception e) {
            String msg = "Failed to query for publishing events for node: " + node;
            throw new WebScriptException(500, msg, (Throwable)e);
        }
    }

    private ArrayList<PublishingEvent> getSortedPublishingEvents(NodeRef node) {
        List publishedEvents = this.publishingService.getPublishEventsForNode(node);
        List unpublishedEvents = this.publishingService.getUnpublishEventsForNode(node);
        ArrayList<PublishingEvent> allEvents = new ArrayList<PublishingEvent>(publishedEvents);
        allEvents.addAll(unpublishedEvents);
        Collections.sort(allEvents);
        return allEvents;
    }
}

