/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.repo.node.NodeUtils;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.publishing.PublishingWebScriptConstants;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.collections.Function;
import org.alfresco.util.collections.JsonUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class PublishingJsonParser
implements PublishingWebScriptConstants {
    public JSONObject getJson(String jsonStr) throws JSONException {
        if (jsonStr != null && !jsonStr.isEmpty()) {
            return new JSONObject(new JSONTokener(jsonStr));
        }
        return new JSONObject();
    }

    public void updateChannel(Channel channel, String jsonStr, ChannelService channelService) throws JSONException {
        JSONObject json = this.getJson(jsonStr);
        String newName = json.optString("name");
        if (newName != null && !newName.isEmpty()) {
            channelService.renameChannel(channel, newName);
        }
    }

    public String schedulePublishingEvent(PublishingService publishingService, String jsonStr) throws ParseException, JSONException {
        JSONObject json = this.getJson(jsonStr);
        PublishingDetails details = publishingService.createPublishingDetails().setPublishChannelId(json.optString("channelId")).setComment(json.optString("comment")).setSchedule(WebScriptUtil.getCalendar(json.optJSONObject("scheduledTime"))).addNodesToPublish(this.toNodes(json.optJSONArray("publishNodes"))).addNodesToUnpublish(this.toNodes(json.optJSONArray("unpublishNodes")));
        details = this.setStatusUpdate(details, json.optJSONObject("statusUpdate"));
        return publishingService.scheduleNewEvent(details);
    }

    public PublishingDetails setStatusUpdate(PublishingDetails details, JSONObject json) {
        if (json != null) {
            details.setStatusMessage(json.optString("message"));
            String nodeStr = json.optString("nodeRef");
            if (nodeStr != null && !nodeStr.isEmpty()) {
                details.setStatusNodeToLinkTo(new NodeRef(nodeStr));
            }
            details.addStatusUpdateChannels(this.toStrings(json.optJSONArray("channelIds")));
        }
        return details;
    }

    public List<NodeRef> toNodes(JSONArray json) {
        Function transformer = NodeUtils.toNodeRef();
        return JsonUtils.transform((JSONArray)json, (Function)transformer);
    }

    private List<String> toStrings(JSONArray json) {
        if (json == null || json.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>(json.length());
        for (int i = 0; i < json.length(); ++i) {
            results.add(json.optString(i));
        }
        return results;
    }
}

