/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.web.scripts.WebScriptUtil;
import org.alfresco.repo.web.scripts.publishing.PublishingWebScriptConstants;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.springframework.extensions.surf.util.URLEncoder;

public class PublishingModelBuilder
implements PublishingWebScriptConstants {
    public Map<String, Object> buildPublishingEventForNode(PublishingEvent event, NodeRef node, ChannelService channelService) {
        Map<String, Object> model = this.buildPublishingEvent(event, channelService);
        boolean isPublish = event.getPackage().getNodesToPublish().contains(node);
        String type = isPublish ? "published" : "unpublished";
        model.put("eventType", type);
        return model;
    }

    public List<Map<String, Object>> buildPublishingEventsForNode(List<PublishingEvent> events, final NodeRef node, final ChannelService channelService) {
        return CollectionUtils.transform(events, (Function)new Function<PublishingEvent, Map<String, Object>>(){

            public Map<String, Object> apply(PublishingEvent event) {
                return PublishingModelBuilder.this.buildPublishingEventForNode(event, node, channelService);
            }
        });
    }

    public Map<String, Object> buildPublishingEvent(PublishingEvent event, ChannelService channelService) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", event.getId());
        model.put("url", PublishingModelBuilder.getUrl(event));
        model.put("status", event.getStatus().name());
        model.put("comment", event.getComment());
        model.put("scheduledTime", WebScriptUtil.buildCalendarModel(event.getScheduledTime()));
        model.put("creator", event.getCreator());
        model.put("createdTime", WebScriptUtil.buildDateModel(event.getCreatedTime()));
        model.put("publishNodes", this.buildNodes(event.getPackage(), true));
        model.put("unpublishNodes", this.buildNodes(event.getPackage(), false));
        String channelId = event.getChannelId();
        Channel channel = channelService.getChannelById(channelId);
        if (channel != null) {
            model.put("channel", this.buildChannel(channel));
        } else {
            model.put("channelId", channelId);
        }
        return model;
    }

    public List<Map<String, Object>> buildPublishingEvents(List<PublishingEvent> events, final ChannelService channelService) {
        return CollectionUtils.transform(events, (Function)new Function<PublishingEvent, Map<String, Object>>(){

            public Map<String, Object> apply(PublishingEvent event) {
                return PublishingModelBuilder.this.buildPublishingEvent(event, channelService);
            }
        });
    }

    public Map<String, Object> buildChannel(Channel channel) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", PublishingModelBuilder.getUrl(channel));
        model.put("id", channel.getId());
        model.put("name", channel.getName());
        model.put("title", channel.getName());
        model.put("canPublish", this.toString(channel.canPublish()));
        model.put("canUnpublish", this.toString(channel.canUnpublish()));
        model.put("canPublishStatusUpdates", this.toString(channel.canPublishStatusUpdates()));
        model.put("channelType", this.buildChannelType(channel.getChannelType()));
        model.put("authorised", this.toString(channel.isAuthorised()));
        return model;
    }

    public List<Map<String, Object>> buildChannels(List<Channel> channels) {
        return CollectionUtils.transform(channels, (Function)new Function<Channel, Map<String, Object>>(){

            public Map<String, Object> apply(Channel value) {
                return PublishingModelBuilder.this.buildChannel(value);
            }
        });
    }

    public Map<String, Object> buildChannelType(ChannelType type) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("id", type.getId());
        model.put("title", type.getTitle());
        model.put("url", PublishingModelBuilder.getUrl(type));
        model.put("channelNodeType", type.getChannelNodeType().toString());
        model.put("supportedContentTypes", CollectionUtils.toListOfStrings((Collection)type.getSupportedContentTypes()));
        model.put("supportedMimeTypes", type.getSupportedMimeTypes());
        model.put("canPublish", this.toString(type.canPublish()));
        model.put("canPublishStatusUpdates", this.toString(type.canPublishStatusUpdates()));
        model.put("canUnpublish", this.toString(type.canUnpublish()));
        model.put("maxStatusLength", type.getMaximumStatusLength());
        model.put("icon", PublishingModelBuilder.getUrl(type) + "/icon");
        return model;
    }

    public List<Map<String, Object>> buildChannelTypes(List<ChannelType> types) {
        return CollectionUtils.transform(types, (Function)new Function<ChannelType, Map<String, Object>>(){

            public Map<String, Object> apply(ChannelType value) {
                return PublishingModelBuilder.this.buildChannelType(value);
            }
        });
    }

    public static String getUrl(PublishingEvent event) {
        return "api/publishing/events/" + URLEncoder.encode((String)event.getId());
    }

    public static String getUrl(ChannelType type) {
        return "api/publishing/channel-types/" + URLEncoder.encode((String)type.getId());
    }

    public static String getUrl(Channel channel) {
        NodeRef node = channel.getNodeRef();
        StoreRef storeRef = node.getStoreRef();
        StringBuilder sb = new StringBuilder("api/publishing/channels/");
        sb.append(storeRef.getProtocol()).append("/").append(storeRef.getIdentifier()).append("/").append(node.getId());
        return sb.toString();
    }

    private String toString(boolean b) {
        return Boolean.toString(b);
    }

    private List<Map<String, Object>> buildNodes(PublishingPackage pckg, boolean isPublish) {
        Set nodes = isPublish ? pckg.getNodesToPublish() : pckg.getNodesToUnpublish();
        return this.buildNodes(pckg, nodes);
    }

    private List<Map<String, Object>> buildNodes(PublishingPackage pckg, Collection<NodeRef> nodes) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(nodes.size());
        Map entryMap = pckg.getEntryMap();
        for (NodeRef node : nodes) {
            PublishingPackageEntry entry = (PublishingPackageEntry)entryMap.get(node);
            results.add(this.buildPackageEntry(entry));
        }
        return results;
    }

    private Map<String, Object> buildPackageEntry(PublishingPackageEntry entry) {
        String name;
        HashMap<String, Object> model = new HashMap<String, Object>();
        NodeSnapshot snapshot = entry.getSnapshot();
        model.put("nodeRef", entry.getNodeRef().toString());
        String version = snapshot.getVersion();
        if (version != null && !version.isEmpty()) {
            model.put("version", version);
        }
        if ((name = (String)snapshot.getProperties().get(ContentModel.PROP_NAME)) != null && !name.isEmpty()) {
            model.put("name", name);
        }
        return model;
    }
}

