/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.publishing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.PublishingTestHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.NodeSnapshot;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingPackage;
import org.alfresco.service.cmr.publishing.PublishingPackageEntry;
import org.alfresco.service.cmr.publishing.PublishingService;
import org.alfresco.service.cmr.publishing.Status;
import org.alfresco.service.cmr.publishing.StatusUpdate;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Function;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class PublishingRestApiTest
extends BaseWebScriptTest {
    private static final String publishPdfType = "publishPdfForTest";
    private static final String publishAnyType = "publishAnyForTest";
    private static final String statusUpdateType = "statusUpdateForTest";
    private static final int maxStatusLength = 100;
    private static final String CHANNELS_URL = "api/publishing/channels";
    private static final String CHANNEL_URL = "api/publishing/channels/{0}";
    private static final String CHANNELS_NODE_URL = "api/publishing/{0}/{1}/{2}/channels";
    private static final String CHANNEL_TYPES_URL = "api/publishing/channel-types";
    private static final String PUBLISHING_QUEUE_URL = "api/publishing/queue";
    private static final String PUBLISHING_EVENTS_URL = "api/publishing/{0}/{1}/{2}/events";
    private static final String JSON = "application/json";
    private NodeService nodeService;
    private PermissionService permissionService;
    private ChannelService channelService;
    private PublishingService publishingService;
    private ChannelHelper channelHelper;
    private PublishingTestHelper testHelper;
    TestPersonManager personManager;
    private String userName = GUID.generate();

    public void testGetChannels() throws Exception {
        Channel publishAnyChannel = this.testHelper.createChannel(publishAnyType);
        Channel publishPdfChannel = this.testHelper.createChannel(publishPdfType);
        Channel statusUpdateChannel = this.testHelper.createChannel(statusUpdateType);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(CHANNELS_URL), 200);
        JSONObject data = this.getJsonData(response);
        PublishingRestApiTest.assertEquals((int)21, (int)data.getInt("urlLength"));
        JSONArray publishingChannels = data.getJSONArray("publishChannels");
        JSONArray statusChannels = data.getJSONArray("statusUpdateChannels");
        this.checkChannels(publishingChannels, publishAnyChannel, publishPdfChannel);
        this.checkChannels(statusChannels, statusUpdateChannel);
        this.personManager.setUser(this.userName);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(CHANNELS_URL), 200);
        data = this.getJsonData(response);
        publishingChannels = data.getJSONArray("publishChannels");
        statusChannels = data.getJSONArray("statusUpdateChannels");
        this.checkChannels(publishingChannels, publishAnyChannel, publishPdfChannel);
        this.checkChannels(statusChannels, statusUpdateChannel);
    }

    public void testGetChannelsForNode() throws Exception {
        NodeRef textNode = this.testHelper.createContentNode("plainContent", "Some plain text", "text/plain");
        this.permissionService.setPermission(textNode, this.userName, "Read", true);
        File pdfFile = AbstractContentTransformerTest.loadQuickTestFile((String)"pdf");
        PublishingRestApiTest.assertNotNull((String)"Failed to load required test file.", (Object)pdfFile);
        NodeRef xmlNode = this.testHelper.createContentNode("xmlContent", pdfFile, "application/pdf");
        StoreRef store = textNode.getStoreRef();
        String plainTextNodeUrl = MessageFormat.format(CHANNELS_NODE_URL, store.getProtocol(), store.getIdentifier(), textNode.getId());
        Channel publishAnyChannel = this.testHelper.createChannel(publishAnyType);
        Channel publishPdfChannel = this.testHelper.createChannel(publishPdfType);
        Channel statusUpdateChannel = this.testHelper.createChannel(statusUpdateType);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(plainTextNodeUrl), 200);
        JSONObject data = this.getJsonData(response);
        PublishingRestApiTest.assertEquals((int)21, (int)data.getInt("urlLength"));
        JSONArray publishingChannels = data.getJSONArray("publishChannels");
        JSONArray statusChannels = data.getJSONArray("statusUpdateChannels");
        this.checkChannels(publishingChannels, publishAnyChannel);
        this.checkChannels(statusChannels, statusUpdateChannel);
        String xmlNodeUrl = MessageFormat.format(CHANNELS_NODE_URL, store.getProtocol(), store.getIdentifier(), xmlNode.getId());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(xmlNodeUrl), 200);
        data = this.getJsonData(response);
        PublishingRestApiTest.assertEquals((int)21, (int)data.getInt("urlLength"));
        publishingChannels = data.getJSONArray("publishChannels");
        statusChannels = data.getJSONArray("statusUpdateChannels");
        this.checkChannels(publishingChannels, publishAnyChannel, publishPdfChannel);
        this.checkChannels(statusChannels, statusUpdateChannel);
        this.personManager.setUser(this.userName);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(plainTextNodeUrl), 200);
        data = this.getJsonData(response);
        publishingChannels = data.getJSONArray("publishChannels");
        statusChannels = data.getJSONArray("statusUpdateChannels");
        PublishingRestApiTest.assertEquals((int)0, (int)publishingChannels.length());
        PublishingRestApiTest.assertEquals((int)0, (int)statusChannels.length());
        this.testHelper.allowChannelAccess(this.userName, publishAnyChannel.getId());
        this.testHelper.allowChannelAccess(this.userName, publishPdfChannel.getId());
        this.testHelper.allowChannelAccess(this.userName, statusUpdateChannel.getId());
        this.personManager.setUser(this.userName);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(plainTextNodeUrl), 200);
        data = this.getJsonData(response);
        publishingChannels = data.getJSONArray("publishChannels");
        statusChannels = data.getJSONArray("statusUpdateChannels");
        this.checkChannels(publishingChannels, publishAnyChannel);
        this.checkChannels(statusChannels, statusUpdateChannel);
    }

    public void testChannelPut() throws Exception {
        Channel channel1 = this.testHelper.createChannel(publishAnyType);
        Channel channel2 = this.testHelper.createChannel(publishAnyType);
        String name1 = channel1.getName();
        String name2 = channel2.getName();
        String newName = name1 + "Foo";
        JSONObject json = new JSONObject();
        json.put("name", (Object)newName);
        String jsonStr = json.toString();
        String channel1Url = MessageFormat.format(CHANNEL_URL, URLEncoder.encode((String)channel1.getId()));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(channel1Url, jsonStr, JSON), 200);
        Channel renamedCH1 = this.channelService.getChannelById(channel1.getId());
        PublishingRestApiTest.assertEquals((String)"Channel1 was not renamed correctly!", (String)newName, (String)renamedCH1.getName());
        Channel renamedCH2 = this.channelService.getChannelById(channel2.getId());
        PublishingRestApiTest.assertEquals((String)"Channel2 name should not have changed!", (String)name2, (String)renamedCH2.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPublishingQueuePost() throws Exception {
        NodeRef textNode = this.testHelper.createContentNode("plainContent", "Some plain text", "text/plain");
        try {
            this.checkPublishingQueuePost(textNode);
        }
        catch (Throwable throwable) {
            List events = this.publishingService.getPublishEventsForNode(textNode);
            List ids = CollectionUtils.transform((Collection)events, (Function)new Function<PublishingEvent, String>(){

                public String apply(PublishingEvent value) {
                    return value.getId();
                }
            });
            this.testHelper.addEvents((Collection)ids);
            throw throwable;
        }
        List events = this.publishingService.getPublishEventsForNode(textNode);
        List ids = CollectionUtils.transform((Collection)events, (Function)new /* invalid duplicate definition of identical inner class */);
        this.testHelper.addEvents((Collection)ids);
    }

    private void checkPublishingQueuePost(NodeRef textNode) throws Exception {
        Channel publishChannel = this.testHelper.createChannel(publishAnyType);
        Channel statusChannel = this.testHelper.createChannel(statusUpdateType);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(PUBLISHING_QUEUE_URL, "", JSON), 400);
        String comment = "The comment";
        String statusMessage = "The status message";
        JSONObject json = this.buildScheduleEventJson(textNode, publishChannel, comment, statusMessage, true, statusChannel);
        String jsonStr = json.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(PUBLISHING_QUEUE_URL, jsonStr, JSON), 200);
        List publishedEvents = this.publishingService.getPublishEventsForNode(textNode);
        PublishingRestApiTest.assertEquals((int)1, (int)publishedEvents.size());
        PublishingEvent event = (PublishingEvent)publishedEvents.get(0);
        PublishingRestApiTest.assertEquals((String)publishChannel.getId(), (String)event.getChannelId());
        PublishingRestApiTest.assertEquals((String)comment, (String)event.getComment());
        PublishingRestApiTest.assertEquals((Object)Status.SCHEDULED, (Object)event.getStatus());
        PublishingPackage pckg = event.getPackage();
        Set toPublish = pckg.getNodesToPublish();
        PublishingRestApiTest.assertEquals((int)1, (int)toPublish.size());
        PublishingRestApiTest.assertTrue((boolean)toPublish.contains(textNode));
        PublishingRestApiTest.assertTrue((boolean)pckg.getNodesToUnpublish().isEmpty());
        StatusUpdate statusUpdate = event.getStatusUpdate();
        PublishingRestApiTest.assertEquals((String)statusMessage, (String)statusUpdate.getMessage());
        PublishingRestApiTest.assertEquals((Object)textNode, (Object)statusUpdate.getNodeToLinkTo());
        Set channelIds = statusUpdate.getChannelIds();
        PublishingRestApiTest.assertEquals((int)1, (int)channelIds.size());
        PublishingRestApiTest.assertTrue((boolean)channelIds.contains(statusChannel.getId()));
        Thread.sleep(5000L);
        AbstractChannelType publishAnyChannelType = (AbstractChannelType)this.channelService.getChannelType(publishAnyType);
        AbstractChannelType statusUpdateChannelType = (AbstractChannelType)this.channelService.getChannelType(statusUpdateType);
        NodeRef mappedTextNode = this.channelHelper.mapSourceToEnvironment(textNode, publishChannel.getNodeRef());
        ((AbstractChannelType)Mockito.verify((Object)publishAnyChannelType)).publish((NodeRef)Matchers.eq((Object)mappedTextNode), Matchers.anyMap());
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((AbstractChannelType)Mockito.verify((Object)statusUpdateChannelType)).sendStatusUpdate((Channel)Matchers.any(Channel.class), (String)captor.capture());
        String actualStatusMessage = (String)captor.getValue();
        PublishingRestApiTest.assertTrue((boolean)actualStatusMessage.startsWith(statusMessage));
        ((AbstractChannelType)Mockito.verify((Object)statusUpdateChannelType, (VerificationMode)Mockito.never())).publish((NodeRef)Matchers.any(NodeRef.class), Matchers.anyMap());
        ((AbstractChannelType)Mockito.verify((Object)publishAnyChannelType, (VerificationMode)Mockito.never())).sendStatusUpdate((Channel)Matchers.any(Channel.class), Matchers.anyString());
        JSONObject status = json.optJSONObject("statusUpdate");
        status.remove("nodeRef");
        jsonStr = json.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(PUBLISHING_QUEUE_URL, jsonStr, JSON), 200);
        json.remove("statusUpdate");
        jsonStr = json.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(PUBLISHING_QUEUE_URL, jsonStr, JSON), 200);
        Thread.sleep(5000L);
        PublishingRestApiTest.assertTrue((boolean)this.nodeService.exists(mappedTextNode));
        ((AbstractChannelType)Mockito.verify((Object)publishAnyChannelType, (VerificationMode)Mockito.never())).unpublish((NodeRef)Matchers.eq((Object)mappedTextNode), Matchers.anyMap());
        json = this.buildScheduleEventJson(textNode, publishChannel, comment, null, false, new Channel[0]);
        jsonStr = json.toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(PUBLISHING_QUEUE_URL, jsonStr, JSON), 200);
        Thread.sleep(5000L);
        PublishingRestApiTest.assertFalse((boolean)this.nodeService.exists(mappedTextNode));
        NodeRef remappedTextNode = this.channelHelper.mapSourceToEnvironment(textNode, publishChannel.getNodeRef());
        PublishingRestApiTest.assertNull((Object)remappedTextNode);
        ((AbstractChannelType)Mockito.verify((Object)publishAnyChannelType)).unpublish((NodeRef)Matchers.eq((Object)mappedTextNode), Matchers.anyMap());
        String protocol = textNode.getStoreRef().getProtocol();
        String storeId = textNode.getStoreRef().getIdentifier();
        String nodeId = textNode.getId();
        String textNodeUrl = MessageFormat.format(PUBLISHING_EVENTS_URL, protocol, storeId, nodeId);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNodeUrl), 200);
        JSONArray data = this.getDataArray(response);
        List unpublishEvents = this.publishingService.getUnpublishEventsForNode(textNode);
        PublishingRestApiTest.assertEquals((int)1, (int)unpublishEvents.size());
        PublishingEvent unpublishedEvent = (PublishingEvent)unpublishEvents.get(0);
        this.checkContainsEvent(data, unpublishedEvent.getId());
    }

    public void testPublishingEventsGet() throws Exception {
        Channel publishChannel = this.testHelper.createChannel(publishAnyType);
        NodeRef textNode1 = this.testHelper.createContentNode("plain1.txt", "This is some plain text", "text/plain");
        NodeRef textNode2 = this.testHelper.createContentNode("plain2.txt", "This is some more plain text", "text/plain");
        String protocol = textNode1.getStoreRef().getProtocol();
        String storeId = textNode1.getStoreRef().getIdentifier();
        String nodeId1 = textNode1.getId();
        String textNode1Url = MessageFormat.format(PUBLISHING_EVENTS_URL, protocol, storeId, nodeId1);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNode1Url), 200);
        JSONArray data = this.getDataArray(response);
        PublishingRestApiTest.assertEquals((int)0, (int)data.length());
        String comment = "This is a comment";
        PublishingDetails details = this.publishingService.createPublishingDetails().setPublishChannelId(publishChannel.getId()).addNodesToPublish(new NodeRef[]{textNode1}).setComment(comment);
        String event1Id = this.testHelper.scheduleEvent1Year(details);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNode1Url), 200);
        data = this.getDataArray(response);
        this.checkContainsEvents(data, event1Id);
        String nodeId2 = textNode2.getId();
        String textNode2Url = MessageFormat.format(PUBLISHING_EVENTS_URL, protocol, storeId, nodeId2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNode2Url), 200);
        data = this.getDataArray(response);
        PublishingRestApiTest.assertEquals((int)0, (int)data.length());
        this.personManager.setUser(this.userName);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNode1Url), 200);
        data = this.getDataArray(response);
        this.checkContainsEvents(data, event1Id);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(textNode2Url), 200);
        data = this.getDataArray(response);
        PublishingRestApiTest.assertEquals((int)0, (int)data.length());
    }

    public void testChannelTypesGet() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(CHANNEL_TYPES_URL), 200);
        JSONArray data = this.getDataArray(response);
        this.checkChannelTypes(data, this.channelService.getChannelTypes());
    }

    private void checkChannelTypes(JSONArray data, List<ChannelType> channelTypes) throws Exception {
        PublishingRestApiTest.assertEquals((int)channelTypes.size(), (int)data.length());
        for (ChannelType type : channelTypes) {
            this.checkContainsChannelType(data, type);
        }
    }

    private void checkContainsChannelType(JSONArray data, ChannelType type) throws Exception {
        String typeId = type.getId();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject json = data.optJSONObject(i);
            if (!typeId.equals(json.optString("id"))) continue;
            this.checkChannelType(json, type);
            return;
        }
        PublishingRestApiTest.fail((String)("Failed to find Channel Type: " + typeId));
    }

    private void checkContainsEvents(JSONArray data, String ... eventIds) throws Exception {
        PublishingRestApiTest.assertEquals((int)eventIds.length, (int)data.length());
        for (String eventId : eventIds) {
            this.checkContainsEvent(data, eventId);
        }
    }

    private void checkContainsEvent(JSONArray data, String eventId) throws Exception {
        for (int i = 0; i < data.length(); ++i) {
            JSONObject json = data.optJSONObject(i);
            if (!eventId.equals(json.optString("id"))) continue;
            PublishingEvent event = this.publishingService.getPublishingEvent(eventId);
            this.checkJsonEvent(event, json);
            return;
        }
        PublishingRestApiTest.fail((String)("Failed to find Publishing Event: " + eventId));
    }

    private void checkJsonEvent(PublishingEvent event, JSONObject json) throws Exception {
        String url = "api/publishing/events/" + URLEncoder.encode((String)event.getId());
        PublishingRestApiTest.assertEquals((String)url, (String)json.getString("url"));
        PublishingRestApiTest.assertEquals((String)event.getStatus().name(), (String)json.getString("status"));
        PublishingRestApiTest.assertEquals((String)event.getComment(), (String)json.optString("comment"));
        this.checkCalendar(event.getScheduledTime(), json.optJSONObject("scheduledTime"));
        PublishingRestApiTest.assertEquals((String)event.getCreator(), (String)json.getString("creator"));
        this.checkDate(event.getCreatedTime(), json.getJSONObject("createdTime"));
        PublishingPackage pckg = event.getPackage();
        this.checkContainsNodes(pckg, json.getJSONArray("publishNodes"), true);
        this.checkContainsNodes(pckg, json.getJSONArray("unpublishNodes"), false);
        Channel channel = this.channelService.getChannelById(event.getChannelId());
        this.checkChannel(json.getJSONObject("channel"), channel);
    }

    private void checkContainsNodes(PublishingPackage pckg, JSONArray json, boolean isPublish) throws JSONException {
        Set nodes = isPublish ? pckg.getNodesToPublish() : pckg.getNodesToUnpublish();
        this.checkContainsNodes(nodes, pckg.getEntryMap(), json);
    }

    private void checkContainsNodes(Collection<NodeRef> nodes, Map<NodeRef, PublishingPackageEntry> entryMap, JSONArray json) throws JSONException {
        PublishingRestApiTest.assertEquals((int)nodes.size(), (int)json.length());
        for (NodeRef node : nodes) {
            this.checkContainsNode(entryMap.get(node), json);
        }
    }

    private void checkContainsNode(PublishingPackageEntry entry, JSONArray jsonArray) throws JSONException {
        String nodeId = entry.getNodeRef().toString();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            if (!nodeId.equals(json.getString("nodeRef"))) continue;
            this.checkNode(entry, json);
            return;
        }
        PublishingRestApiTest.fail((String)"NodeRef was not found!");
    }

    private void checkNode(PublishingPackageEntry entry, JSONObject json) throws JSONException {
        String name;
        NodeSnapshot snapshot = entry.getSnapshot();
        String version = snapshot.getVersion();
        if (version != null && !version.isEmpty()) {
            PublishingRestApiTest.assertEquals((String)version, (String)json.getString("version"));
        }
        if ((name = (String)snapshot.getProperties().get(ContentModel.PROP_NAME)) != null && !name.isEmpty()) {
            PublishingRestApiTest.assertEquals((String)name, (String)json.getString("name"));
        }
    }

    private void checkCalendar(Calendar calendar, JSONObject json) throws JSONException {
        this.checkDate(calendar.getTime(), json);
        String timeZone = calendar.getTimeZone().getID();
        PublishingRestApiTest.assertEquals((String)timeZone, (String)json.getString("timeZone"));
    }

    private void checkDate(Date date, JSONObject json) throws JSONException {
        PublishingRestApiTest.assertEquals((String)"ISO8601", (String)json.getString("format"));
        String dateStr = json.getString("dateTime");
        Date actualDate = ISO8601DateFormat.parse((String)dateStr);
        PublishingRestApiTest.assertEquals((Object)date, (Object)actualDate);
    }

    private JSONObject buildScheduleEventJson(NodeRef node, Channel publishChannel, String comment, String statusMessage, boolean publish, Channel ... statusChannels) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("channelId", (Object)publishChannel.getId());
        json.put("comment", (Object)comment);
        Set<String> publishNodes = Collections.singleton(node.toString());
        if (publish) {
            json.put("publishNodes", publishNodes);
        } else {
            json.put("unpublishNodes", publishNodes);
        }
        if (statusMessage != null) {
            json.put("statusUpdate", (Object)this.buildStatusUpdate(statusMessage, node, statusChannels));
        }
        return json;
    }

    private JSONObject buildStatusUpdate(String message, NodeRef textNode, Channel ... theChannels) throws JSONException {
        Function<Channel, String> transformer = new Function<Channel, String>(){

            public String apply(Channel channel) {
                return channel.getId();
            }
        };
        List ids = CollectionUtils.transform((Function)transformer, (Object[])theChannels);
        JSONObject statusUpdate = new JSONObject();
        statusUpdate.put("message", (Object)message);
        statusUpdate.put("nodeRef", (Object)textNode.toString());
        statusUpdate.put("channelIds", (Collection)ids);
        return statusUpdate;
    }

    private void checkChannels(JSONArray json, Channel ... theChannels) throws Exception {
        for (Channel channel : theChannels) {
            this.checkContainsChannel(json, channel);
        }
    }

    private void checkContainsChannel(JSONArray json, Channel channel) throws Exception {
        for (int i = 0; i < json.length(); ++i) {
            JSONObject jsonChannel = json.getJSONObject(i);
            String name = jsonChannel.getString("name");
            if (!channel.getName().equals(name)) continue;
            this.checkChannel(jsonChannel, channel);
            return;
        }
        PublishingRestApiTest.fail((String)("Json did not contain channel: " + channel.getName()));
    }

    private void checkChannel(JSONObject jsonChannel, Channel channel) throws Exception {
        NodeRef node = channel.getNodeRef();
        StoreRef storeRef = node.getStoreRef();
        this.check("id", jsonChannel, channel.getId());
        String expUrl = "api/publishing/channels/" + storeRef.getProtocol() + "/" + storeRef.getIdentifier() + "/" + node.getId();
        this.check("url", jsonChannel, expUrl);
        this.check("title", jsonChannel, channel.getName());
        this.check("canPublish", jsonChannel, channel.canPublish());
        this.check("canUnpublish", jsonChannel, channel.canUnpublish());
        this.check("canPublishStatusUpdates", jsonChannel, channel.canPublishStatusUpdates());
        this.check("authorised", jsonChannel, channel.isAuthorised());
        JSONObject jsonType = jsonChannel.getJSONObject("channelType");
        PublishingRestApiTest.assertNotNull((String)"The channel type is null!", (Object)jsonType);
        this.checkChannelType(jsonType, channel.getChannelType());
    }

    private void checkChannelType(JSONObject jsonType, ChannelType channelType) throws Exception {
        this.check("id", jsonType, channelType.getId());
        this.check("title", jsonType, channelType.getId());
        String expUrl = "api/publishing/channel-types/" + URLEncoder.encode((String)channelType.getId());
        this.check("url", jsonType, expUrl);
        this.check("channelNodeType", jsonType, channelType.getChannelNodeType().toString());
        List contentTypes = CollectionUtils.toListOfStrings((Collection)channelType.getSupportedContentTypes());
        this.checkStrings(jsonType.getJSONArray("supportedContentTypes"), contentTypes);
        this.checkStrings(jsonType.getJSONArray("supportedMimeTypes"), channelType.getSupportedMimeTypes());
        this.check("canPublish", jsonType, channelType.canPublish());
        this.check("canPublishStatusUpdates", jsonType, channelType.canPublishStatusUpdates());
        this.check("canUnpublish", jsonType, channelType.canUnpublish());
        this.check("maxStatusLength", jsonType, channelType.getMaximumStatusLength());
        this.check("icon", jsonType, expUrl + "/icon");
    }

    private void check(String key, JSONObject json, Object exp) {
        PublishingRestApiTest.assertEquals((String)("Comparing " + key), (Object)exp, (Object)json.opt(key));
    }

    private void checkStrings(JSONArray json, Collection<String> strings) throws Exception {
        PublishingRestApiTest.assertEquals((int)strings.size(), (int)json.length());
        for (String string : strings) {
            this.checkContains(json, string);
        }
    }

    private void checkContains(JSONArray json, String string) throws Exception {
        for (int i = 0; i < json.length(); ++i) {
            if (!string.equals(json.getString(i))) continue;
            return;
        }
        PublishingRestApiTest.fail((String)("Did not contain " + string));
    }

    private JSONObject getJsonData(TestWebScriptServer.Response response) throws Exception {
        JSONObject json = this.getJson(response);
        JSONObject data = json.getJSONObject("data");
        PublishingRestApiTest.assertNotNull((String)"Data was null!", (Object)data);
        return data;
    }

    public JSONArray getDataArray(TestWebScriptServer.Response response) throws Exception {
        JSONObject json = this.getJson(response);
        JSONArray data = json.getJSONArray("data");
        PublishingRestApiTest.assertNotNull((String)"Data was null!", (Object)data);
        return data;
    }

    private JSONObject getJson(TestWebScriptServer.Response response) throws UnsupportedEncodingException, JSONException {
        String jsonStr = response.getContentAsString();
        PublishingRestApiTest.assertNotNull((String)"The JSON is null!", (Object)jsonStr);
        return new JSONObject(jsonStr);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext ctx = this.getServer().getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        SiteService siteService = serviceRegistry.getSiteService();
        FileFolderService fileFolderService = serviceRegistry.getFileFolderService();
        this.nodeService = serviceRegistry.getNodeService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.channelService = (ChannelService)ctx.getBean("ChannelService");
        this.publishingService = (PublishingService)ctx.getBean("PublishingService");
        this.channelHelper = (ChannelHelper)ctx.getBean("channelHelper");
        this.testHelper = new PublishingTestHelper(this.channelService, this.publishingService, siteService, fileFolderService, this.permissionService);
        MutableAuthenticationService authenticationService = serviceRegistry.getAuthenticationService();
        PersonService personService = serviceRegistry.getPersonService();
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.personManager.createPerson(this.userName);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        AbstractChannelType publishAny = this.testHelper.mockChannelType(publishAnyType);
        Mockito.when((Object)publishAny.canPublish()).thenReturn((Object)true);
        Mockito.when((Object)publishAny.canUnpublish()).thenReturn((Object)true);
        AbstractChannelType publishPdf = this.testHelper.mockChannelType(publishPdfType);
        Mockito.when((Object)publishPdf.canPublish()).thenReturn((Object)true);
        Mockito.when((Object)publishPdf.getSupportedMimeTypes()).thenReturn(Collections.singleton("application/pdf"));
        AbstractChannelType statusUpdate = this.testHelper.mockChannelType(statusUpdateType);
        Mockito.when((Object)statusUpdate.canPublishStatusUpdates()).thenReturn((Object)true);
        Mockito.when((Object)statusUpdate.getMaximumStatusLength()).thenReturn((Object)100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.testHelper.tearDown();
        }
        finally {
            super.tearDown();
        }
    }
}

