/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.io.IOException;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.web.scripts.content.ContentGet;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class QuickShareContentGet
extends ContentGet {
    private static final Log logger = LogFactory.getLog(QuickShareContentGet.class);
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private QuickShareService quickShareSerivce;
    private boolean enabled = true;

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
        super.setNodeService(nodeService);
    }

    @Override
    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
        super.setNamespaceService(namespaceService);
    }

    public void setQuickShareService(QuickShareService quickShareService) {
        this.quickShareSerivce = quickShareService;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void execute(final WebScriptRequest req, final WebScriptResponse res) throws IOException {
        if (!this.isEnabled()) {
            throw new WebScriptException(403, "QuickShare is disabled system-wide");
        }
        final Map params = req.getServiceMatch().getTemplateVars();
        String sharedId = (String)params.get("shared_id");
        if (sharedId == null) {
            throw new WebScriptException(400, "A valid sharedId must be specified !");
        }
        try {
            Pair pair = this.quickShareSerivce.getTenantNodeRefFromSharedId(sharedId);
            String tenantDomain = (String)pair.getFirst();
            final NodeRef nodeRef = (NodeRef)pair.getSecond();
            TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    if (!QuickShareContentGet.this.nodeService.getAspects(nodeRef).contains(QuickShareModel.ASPECT_QSHARE)) {
                        throw new InvalidNodeRefException(nodeRef);
                    }
                    QuickShareContentGet.this.executeImpl(nodeRef, params, req, res, null);
                    return null;
                }
            }, (String)tenantDomain);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("QuickShare - retrieved content: " + sharedId + " [" + nodeRef + "]"));
            }
        }
        catch (InvalidSharedIdException ex) {
            logger.error((Object)("Unable to find: " + sharedId));
            throw new WebScriptException(404, "Unable to find: " + sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.error((Object)("Unable to find: " + sharedId + " [" + inre.getNodeRef() + "]"));
            throw new WebScriptException(404, "Unable to find: " + sharedId);
        }
    }

    protected void executeImpl(NodeRef nodeRef, Map<String, String> templateVars, WebScriptRequest req, WebScriptResponse res, Map<String, Object> model) throws IOException {
        QName propertyQName = ContentModel.PROP_CONTENT;
        String contentPart = templateVars.get("property");
        if (contentPart.length() > 0 && contentPart.charAt(0) == ';') {
            if (contentPart.length() < 2) {
                throw new WebScriptException(400, "Content property malformed");
            }
            String propertyName = contentPart.substring(1);
            if (propertyName.length() > 0) {
                propertyQName = QName.createQName((String)propertyName, (NamespacePrefixResolver)this.namespaceService);
            }
        }
        boolean attach = Boolean.valueOf(req.getParameter("a"));
        this.streamContent(req, res, nodeRef, propertyQName, attach, model);
    }
}

