/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.quickshare.AbstractQuickShareContent;
import org.alfresco.repo.web.scripts.quickshare.ShareContentPost;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class ShareContentGet
extends AbstractQuickShareContent {
    private static final Log logger = LogFactory.getLog(ShareContentPost.class);
    protected SiteService siteService;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (!this.isEnabled()) {
            throw new WebScriptException(403, "QuickShare is disabled system-wide");
        }
        Map params = req.getServiceMatch().getTemplateVars();
        String sharedId = (String)params.get("shared_id");
        if (sharedId == null) {
            throw new WebScriptException(400, "A valid sharedId must be specified !");
        }
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String tenantDomain = (String)pair.getFirst();
            NodeRef nodeRef = (NodeRef)pair.getSecond();
            SiteInfo siteInfo = this.siteService.getSite(nodeRef);
            String siteId = null;
            if (siteInfo != null) {
                siteId = siteInfo.getShortName();
            }
            HashMap<String, Object> model = new HashMap<String, Object>(3);
            model.put("sharedId", sharedId);
            model.put("nodeRef", nodeRef.toString());
            model.put("siteId", siteId);
            model.put("tenantDomain", tenantDomain);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("QuickShare - get shared context: " + sharedId + " [" + model + "]"));
            }
            return model;
        }
        catch (InvalidNodeRefException inre) {
            logger.error((Object)("Unable to find: " + sharedId + " [" + inre.getNodeRef() + "]"));
            throw new WebScriptException(404, "Unable to find: " + sharedId);
        }
    }
}

