/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rating;

import java.text.MessageFormat;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.PropertyMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RatingRestApiTest
extends BaseWebScriptTest {
    private static final String FIVE_STAR_RATING_SCHEME = "fiveStarRatingScheme";
    private static final String LIKES_RATING_SCHEME = "likesRatingScheme";
    private static final String USER_ONE = "UserOne";
    private static final String USER_TWO = "UserTwo";
    private static final String RATING_SCHEMES = "ratingSchemes";
    private static final String NAME = "name";
    private static final String MIN_RATING = "minRating";
    private static final String MAX_RATING = "maxRating";
    private static final String RATINGS = "ratings";
    private static final String NODE_REF = "nodeRef";
    private static final String DATA = "data";
    private static final String RATINGS_TOTAL = "ratingsTotal";
    private static final String RATINGS_COUNT = "ratingsCount";
    private static final String AVERAGE_RATING = "averageRating";
    private static final String NODE_STATISTICS = "nodeStatistics";
    private static final String NODE_RATINGS_URL_FORMAT = "/api/node/{0}/ratings";
    private static final String GET_RATING_DEFS_URL = "/api/rating/schemedefinitions";
    private static final String APPLICATION_JSON = "application/json";
    private NodeRef testNode;
    private MutableAuthenticationService authenticationService;
    private NodeService nodeService;
    private PersonService personService;
    private Repository repositoryHelper;
    private RetryingTransactionHelper transactionHelper;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.testNode = (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                RatingRestApiTest.this.createUser(RatingRestApiTest.USER_ONE);
                RatingRestApiTest.this.createUser(RatingRestApiTest.USER_TWO);
                ChildAssociationRef result = RatingRestApiTest.this.nodeService.createNode(RatingRestApiTest.this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS, ContentModel.TYPE_CONTENT, null);
                return result.getChildRef();
            }
        });
    }

    public void tearDown() throws Exception {
        super.tearDown();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (RatingRestApiTest.this.testNode != null && RatingRestApiTest.this.nodeService.exists(RatingRestApiTest.this.testNode)) {
                    RatingRestApiTest.this.nodeService.deleteNode(RatingRestApiTest.this.testNode);
                    RatingRestApiTest.this.deleteUser(RatingRestApiTest.USER_ONE);
                    RatingRestApiTest.this.deleteUser(RatingRestApiTest.USER_TWO);
                }
                return null;
            }
        });
    }

    public void testGetRatingSchemeDefinitions() throws Exception {
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(GET_RATING_DEFS_URL), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray ratingSchemesArray = (JSONArray)dataObj.get(RATING_SCHEMES);
        RatingRestApiTest.assertNotNull((String)"JSON 'ratingSchemesArray' object was null", (Object)ratingSchemesArray);
        RatingRestApiTest.assertEquals((int)2, (int)ratingSchemesArray.length());
        JSONObject scheme1 = ratingSchemesArray.getJSONObject(0);
        JSONObject scheme2 = ratingSchemesArray.getJSONObject(1);
        RatingRestApiTest.assertEquals((String)LIKES_RATING_SCHEME, (String)scheme1.getString(NAME));
        RatingRestApiTest.assertEquals((Object)1.0, (Object)scheme1.getDouble(MIN_RATING));
        RatingRestApiTest.assertEquals((Object)1.0, (Object)scheme1.getDouble(MAX_RATING));
        RatingRestApiTest.assertTrue((boolean)scheme1.getBoolean("selfRatingAllowed"));
        RatingRestApiTest.assertEquals((String)FIVE_STAR_RATING_SCHEME, (String)scheme2.getString(NAME));
        RatingRestApiTest.assertEquals((Object)1.0, (Object)scheme2.getDouble(MIN_RATING));
        RatingRestApiTest.assertEquals((Object)5.0, (Object)scheme2.getDouble(MAX_RATING));
        RatingRestApiTest.assertFalse((boolean)scheme2.getBoolean("selfRatingAllowed"));
    }

    public void testGetRatingsFromUnratedNodeRef() throws Exception {
        String ratingUrl = this.getRatingUrl(this.testNode);
        int expectedStatus = 200;
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(ratingUrl), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        RatingRestApiTest.assertEquals((String)this.testNode.toString(), (String)dataObj.getString(NODE_REF));
        JSONObject ratingsObject = dataObj.getJSONObject(RATINGS);
        RatingRestApiTest.assertEquals((int)0, (int)ratingsObject.length());
        JSONObject statsObject = dataObj.getJSONObject(NODE_STATISTICS);
        JSONObject likesStats = statsObject.getJSONObject(LIKES_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)-1.0, (Object)likesStats.getDouble(AVERAGE_RATING));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)0, (int)likesStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)0.0, (Object)likesStats.getDouble(RATINGS_TOTAL));
        JSONObject fiveStarStats = statsObject.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)-1.0, (Object)fiveStarStats.getDouble(AVERAGE_RATING));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)0, (int)fiveStarStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)0.0, (Object)fiveStarStats.getDouble(RATINGS_TOTAL));
    }

    public void testApplyRatingsAsMultipleUsersAndRetrieve() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        String testNodeRatingUrl = this.getRatingUrl(this.testNode);
        float userOneRatingValue = 4.5f;
        String jsonString = new JSONStringer().object().key("rating").value(4.5).key("ratingScheme").value((Object)FIVE_STAR_RATING_SCHEME).endObject().toString();
        TestWebScriptServer.Response postRsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(testNodeRatingUrl, jsonString, APPLICATION_JSON), 200);
        String postRspString = postRsp.getContentAsString();
        JSONObject jsonRsp = new JSONObject(new JSONTokener(postRspString));
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        String returnedUrl = dataObj.getString("ratedNodeUrl");
        RatingRestApiTest.assertEquals((String)testNodeRatingUrl, (String)returnedUrl);
        RatingRestApiTest.assertEquals((String)FIVE_STAR_RATING_SCHEME, (String)dataObj.getString("ratingScheme"));
        RatingRestApiTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)dataObj.getDouble("rating")));
        RatingRestApiTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)dataObj.getDouble(AVERAGE_RATING)));
        RatingRestApiTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)dataObj.getDouble(RATINGS_TOTAL)));
        RatingRestApiTest.assertEquals((int)1, (int)dataObj.getInt(RATINGS_COUNT));
        jsonString = new JSONStringer().object().key("rating").value(1L).key("ratingScheme").value((Object)LIKES_RATING_SCHEME).endObject().toString();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(testNodeRatingUrl, jsonString, APPLICATION_JSON), 200);
        TestWebScriptServer.Response getRsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(testNodeRatingUrl), 200);
        String getRspString = getRsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(getRspString));
        dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONObject ratingsObject = dataObj.getJSONObject(RATINGS);
        RatingRestApiTest.assertEquals((int)2, (int)ratingsObject.length());
        JSONObject recoveredRating = ratingsObject.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)recoveredRating.getDouble("rating")));
        JSONObject statsObject = dataObj.getJSONObject(NODE_STATISTICS);
        JSONObject fiveStarStats = statsObject.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)fiveStarStats.getDouble(AVERAGE_RATING)));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)1, (int)fiveStarStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)fiveStarStats.getDouble(RATINGS_TOTAL)));
        JSONObject likesStats = statsObject.getJSONObject(LIKES_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf((float)likesStats.getDouble(AVERAGE_RATING)));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)1, (int)likesStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)Float.valueOf(1.0f), (Object)Float.valueOf((float)likesStats.getDouble(RATINGS_TOTAL)));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        float userTwoRatingValue = 3.5f;
        jsonString = new JSONStringer().object().key("rating").value(3.5).key("ratingScheme").value((Object)FIVE_STAR_RATING_SCHEME).endObject().toString();
        postRsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(testNodeRatingUrl, jsonString, APPLICATION_JSON), 200);
        postRspString = postRsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(postRspString));
        dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        returnedUrl = dataObj.getString("ratedNodeUrl");
        RatingRestApiTest.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf((float)dataObj.getDouble(AVERAGE_RATING)));
        RatingRestApiTest.assertEquals((Object)Float.valueOf(8.0f), (Object)Float.valueOf((float)dataObj.getDouble(RATINGS_TOTAL)));
        RatingRestApiTest.assertEquals((int)2, (int)dataObj.getInt(RATINGS_COUNT));
        getRsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(returnedUrl), 200);
        getRspString = getRsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(getRspString));
        dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONObject userTwoRatings = dataObj.getJSONObject(RATINGS);
        RatingRestApiTest.assertEquals((int)1, (int)userTwoRatings.length());
        JSONObject secondRating = userTwoRatings.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((Object)Float.valueOf(3.5f), (Object)Float.valueOf((float)secondRating.getDouble("rating")));
        statsObject = dataObj.getJSONObject(NODE_STATISTICS);
        fiveStarStats = statsObject.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)4.0, (Object)fiveStarStats.getDouble(AVERAGE_RATING));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)2, (int)fiveStarStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)Float.valueOf(8.0f), (Object)Float.valueOf((float)fiveStarStats.getDouble(RATINGS_TOTAL)));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(testNodeRatingUrl + "/" + FIVE_STAR_RATING_SCHEME), 200);
        getRsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(returnedUrl), 200);
        getRspString = getRsp.getContentAsString();
        jsonRsp = new JSONObject(new JSONTokener(getRspString));
        dataObj = (JSONObject)jsonRsp.get(DATA);
        RatingRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONObject remainingRatings = dataObj.getJSONObject(RATINGS);
        RatingRestApiTest.assertEquals((int)0, (int)remainingRatings.length());
        statsObject = dataObj.getJSONObject(NODE_STATISTICS);
        fiveStarStats = statsObject.getJSONObject(FIVE_STAR_RATING_SCHEME);
        RatingRestApiTest.assertEquals((String)"Average rating was wrong.", (Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)fiveStarStats.getDouble(AVERAGE_RATING)));
        RatingRestApiTest.assertEquals((String)"Ratings count rating was wrong.", (int)1, (int)fiveStarStats.getInt(RATINGS_COUNT));
        RatingRestApiTest.assertEquals((String)"Ratings total was wrong.", (Object)Float.valueOf(4.5f), (Object)Float.valueOf((float)fiveStarStats.getDouble(RATINGS_TOTAL)));
    }

    private String getRatingUrl(NodeRef nodeRef) {
        String nodeUrl = nodeRef.toString().replace("://", "/");
        String ratingUrl = MessageFormat.format(NODE_RATINGS_URL_FORMAT, nodeUrl);
        return ratingUrl;
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void deleteUser(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }
}

