/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.replication;

import java.util.Map;
import org.alfresco.repo.web.scripts.replication.ReplicationModelBuilder;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.scheduled.SchedulableAction;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ISO8601DateFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractReplicationWebscript
extends DeclarativeWebScript {
    protected NodeService nodeService;
    protected ReplicationService replicationService;
    protected ActionTrackingService actionTrackingService;

    public void setReplicationService(ReplicationService replicationService) {
        this.replicationService = replicationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActionTrackingService(ActionTrackingService actionTrackingService) {
        this.actionTrackingService = actionTrackingService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        ReplicationModelBuilder modelBuilder = new ReplicationModelBuilder(this.nodeService, this.replicationService, this.actionTrackingService);
        return this.buildModel(modelBuilder, req, status, cache);
    }

    protected void updateDefinitionProperties(ReplicationDefinition replicationDefinition, JSONObject json) throws JSONException {
        if (json.has("description")) {
            String description = json.getString("description");
            replicationDefinition.setDescription(description);
        }
        if (json.has("targetName")) {
            String targetName = json.getString("targetName");
            replicationDefinition.setTargetName(targetName);
        }
        if (json.has("enabled")) {
            boolean enabled = json.getBoolean("enabled");
            replicationDefinition.setEnabled(enabled);
        }
        if (json.has("payload")) {
            replicationDefinition.getPayload().clear();
            JSONArray payload = json.getJSONArray("payload");
            for (int i = 0; i < payload.length(); ++i) {
                String node = payload.getString(i);
                replicationDefinition.getPayload().add(new NodeRef(node));
            }
        }
        if (json.has("schedule") && !json.isNull("schedule")) {
            this.replicationService.enableScheduling(replicationDefinition);
            JSONObject schedule = json.getJSONObject("schedule");
            if (schedule.has("start") && !schedule.isNull("start")) {
                String startDate = schedule.getString("start");
                if (schedule.get("start") instanceof JSONObject) {
                    startDate = schedule.getJSONObject("start").getString("iso8601");
                }
                replicationDefinition.setScheduleStart(ISO8601DateFormat.parse((String)startDate));
            } else {
                replicationDefinition.setScheduleStart(null);
            }
            if (schedule.has("intervalPeriod") && !schedule.isNull("intervalPeriod")) {
                replicationDefinition.setScheduleIntervalPeriod(SchedulableAction.IntervalPeriod.valueOf((String)schedule.getString("intervalPeriod")));
            } else {
                replicationDefinition.setScheduleIntervalPeriod(null);
            }
            if (schedule.has("intervalCount") && !schedule.isNull("intervalCount")) {
                replicationDefinition.setScheduleIntervalCount(Integer.valueOf(schedule.getInt("intervalCount")));
            } else {
                replicationDefinition.setScheduleIntervalCount(null);
            }
        } else {
            this.replicationService.disableScheduling(replicationDefinition);
        }
    }

    protected abstract Map<String, Object> buildModel(ReplicationModelBuilder var1, WebScriptRequest var2, Status var3, Cache var4);
}

