/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rule;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RuleServiceTest
extends BaseWebScriptTest {
    private static final String URL_RULETYPES = "/api/ruletypes";
    private static final String URL_ACTIONDEFINITIONS = "/api/actiondefinitions";
    private static final String URL_ACTIONCONDITIONDEFINITIONS = "/api/actionconditiondefinitions";
    private static final String URL_ACTIONCONSTRAINTS = "/api/actionConstraints";
    private static final String URL_ACTIONCONSTRAINT = "/api/actionConstraints/{0}";
    private static final String URL_QUEUE_ACTION = "/api/actionQueue?async={0}";
    private static final String URL_RULES = "/api/node/{0}/{1}/{2}/ruleset/rules";
    private static final String URL_INHERITED_RULES = "/api/node/{0}/{1}/{2}/ruleset/inheritedrules";
    private static final String URL_RULESET = "/api/node/{0}/{1}/{2}/ruleset";
    private static final String URL_RULE = "/api/node/{0}/{1}/{2}/ruleset/rules/{3}";
    private static final String TEST_STORE_IDENTIFIER = "test_store-" + System.currentTimeMillis();
    private static final String TEST_FOLDER = "test_folder-" + System.currentTimeMillis();
    private static final String TEST_FOLDER_2 = "test_folder-2-" + System.currentTimeMillis();
    private TransactionService transactionService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private AuthenticationComponent authenticationComponent;
    private RuleService ruleService;
    private ActionService actionService;
    private NodeRef testNodeRef;
    private NodeRef testNodeRef2;
    private NodeRef testWorkNodeRef;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.transactionService = (TransactionService)this.getServer().getApplicationContext().getBean("TransactionService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.fileFolderService = (FileFolderService)this.getServer().getApplicationContext().getBean("FileFolderService");
        this.ruleService = (RuleService)this.getServer().getApplicationContext().getBean("RuleService");
        this.actionService = (ActionService)this.getServer().getApplicationContext().getBean("ActionService");
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.createTestFolders();
        RuleServiceTest.assertNotNull((Object)this.testWorkNodeRef);
        RuleServiceTest.assertNotNull((Object)this.testNodeRef);
        RuleServiceTest.assertNotNull((Object)this.testNodeRef2);
    }

    private void createTestFolders() {
        StoreRef testStore = new StoreRef("workspace", TEST_STORE_IDENTIFIER);
        if (!this.nodeService.exists(testStore)) {
            testStore = this.nodeService.createStore("workspace", TEST_STORE_IDENTIFIER);
        }
        NodeRef rootNodeRef = this.nodeService.getRootNode(testStore);
        this.testWorkNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), ContentModel.TYPE_FOLDER).getChildRef();
        this.testNodeRef = this.fileFolderService.create(this.testWorkNodeRef, TEST_FOLDER, ContentModel.TYPE_FOLDER).getNodeRef();
        this.testNodeRef2 = this.fileFolderService.create(this.testWorkNodeRef, TEST_FOLDER_2, ContentModel.TYPE_FOLDER).getNodeRef();
    }

    private String formatRulesUrl(NodeRef nodeRef, boolean inherited) {
        if (inherited) {
            return MessageFormat.format(URL_INHERITED_RULES, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId());
        }
        return MessageFormat.format(URL_RULES, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId());
    }

    private String formatRulesetUrl(NodeRef nodeRef) {
        return MessageFormat.format(URL_RULESET, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId());
    }

    private String formateRuleUrl(NodeRef nodeRef, String ruleId) {
        return MessageFormat.format(URL_RULE, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), ruleId);
    }

    private String formateActionConstraintUrl(String name) {
        return MessageFormat.format(URL_ACTIONCONSTRAINT, name);
    }

    private String formateQueueActionUrl(boolean async) {
        return MessageFormat.format(URL_QUEUE_ACTION, async);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                this.deleteNodeIfExists(RuleServiceTest.this.testNodeRef2);
                this.deleteNodeIfExists(RuleServiceTest.this.testNodeRef);
                this.deleteNodeIfExists(RuleServiceTest.this.testWorkNodeRef);
                return null;
            }

            private void deleteNodeIfExists(NodeRef nodeRef) {
                if (RuleServiceTest.this.nodeService.exists(nodeRef)) {
                    RuleServiceTest.this.nodeService.deleteNode(nodeRef);
                }
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteCallback);
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private JSONObject createRule(NodeRef ruleOwnerNodeRef) throws Exception {
        return this.createRule(ruleOwnerNodeRef, "test_rule");
    }

    private JSONObject createRule(NodeRef ruleOwnerNodeRef, String title) throws Exception {
        JSONObject jsonRule = this.buildTestRule(title);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(this.formatRulesUrl(ruleOwnerNodeRef, false), jsonRule.toString(), "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        return result;
    }

    private JSONArray getNodeRules(NodeRef nodeRef, boolean inherited) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formatRulesUrl(nodeRef, inherited)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONArray data = result.getJSONArray("data");
        return data;
    }

    private void checkRuleComplete(JSONObject result) throws Exception {
        RuleServiceTest.assertNotNull((String)"Response is null.", (Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("id"));
        RuleServiceTest.assertEquals((String)result.getString("title"), (String)"test_rule");
        RuleServiceTest.assertEquals((String)result.getString("description"), (String)"this is description for test_rule");
        JSONArray ruleType = result.getJSONArray("ruleType");
        RuleServiceTest.assertEquals((int)1, (int)ruleType.length());
        RuleServiceTest.assertEquals((String)"outbound", (String)ruleType.getString(0));
        RuleServiceTest.assertTrue((boolean)result.getBoolean("applyToChildren"));
        RuleServiceTest.assertFalse((boolean)result.getBoolean("executeAsynchronously"));
        RuleServiceTest.assertFalse((boolean)result.getBoolean("disabled"));
        RuleServiceTest.assertTrue((boolean)result.has("owningNode"));
        JSONObject owningNode = result.getJSONObject("owningNode");
        RuleServiceTest.assertTrue((boolean)owningNode.has("nodeRef"));
        RuleServiceTest.assertTrue((boolean)owningNode.has("name"));
        RuleServiceTest.assertTrue((boolean)result.has("url"));
        JSONObject jsonAction = result.getJSONObject("action");
        RuleServiceTest.assertTrue((boolean)jsonAction.has("id"));
        RuleServiceTest.assertEquals((String)jsonAction.getString("actionDefinitionName"), (String)"composite-action");
        RuleServiceTest.assertEquals((String)jsonAction.getString("description"), (String)"this is description for composite-action");
        RuleServiceTest.assertEquals((String)jsonAction.getString("title"), (String)"test_title");
        RuleServiceTest.assertTrue((boolean)jsonAction.getBoolean("executeAsync"));
        RuleServiceTest.assertTrue((boolean)jsonAction.has("actions"));
        RuleServiceTest.assertTrue((boolean)jsonAction.has("conditions"));
        RuleServiceTest.assertTrue((boolean)jsonAction.has("compensatingAction"));
        RuleServiceTest.assertTrue((boolean)jsonAction.has("url"));
    }

    private void checkRuleSummary(JSONObject result) throws Exception {
        RuleServiceTest.assertNotNull((String)"Response is null.", (Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONObject data = result.getJSONObject("data");
        RuleServiceTest.assertTrue((boolean)data.has("id"));
        RuleServiceTest.assertEquals((String)data.getString("title"), (String)"test_rule");
        RuleServiceTest.assertEquals((String)data.getString("description"), (String)"this is description for test_rule");
        JSONArray ruleType = data.getJSONArray("ruleType");
        RuleServiceTest.assertEquals((int)1, (int)ruleType.length());
        RuleServiceTest.assertEquals((String)"outbound", (String)ruleType.getString(0));
        RuleServiceTest.assertFalse((boolean)data.getBoolean("disabled"));
        RuleServiceTest.assertTrue((boolean)data.has("url"));
    }

    private void checkUpdatedRule(JSONObject before, JSONObject after) throws JSONException {
        RuleServiceTest.assertEquals((String)"It seams that 'id' is not correct", (String)before.getString("id"), (String)after.getString("id"));
        RuleServiceTest.assertEquals((String)"It seams that 'title' was not saved", (String)before.getString("title"), (String)after.getString("title"));
        RuleServiceTest.assertEquals((String)"It seams that 'description' was not saved", (String)before.getString("description"), (String)after.getString("description"));
        RuleServiceTest.assertEquals((String)"It seams that 'ruleType' was not saved", (int)before.getJSONArray("ruleType").length(), (int)after.getJSONArray("ruleType").length());
        RuleServiceTest.assertEquals((boolean)before.getBoolean("applyToChildren"), (boolean)after.getBoolean("applyToChildren"));
        RuleServiceTest.assertEquals((boolean)before.getBoolean("executeAsynchronously"), (boolean)after.getBoolean("executeAsynchronously"));
        RuleServiceTest.assertEquals((boolean)before.getBoolean("disabled"), (boolean)after.getBoolean("disabled"));
        JSONObject afterAction = after.getJSONObject("action");
        RuleServiceTest.assertEquals((int)1, (int)afterAction.getJSONArray("actions").length());
        RuleServiceTest.assertFalse((boolean)afterAction.has("conditions"));
        RuleServiceTest.assertEquals((boolean)before.has("url"), (boolean)after.has("url"));
    }

    private void checkRuleset(JSONObject result, int rulesCount, String[] ruleIds, int inhRulesCount, String[] parentRuleIds, boolean isLinkedFrom, boolean isLinkedTo) throws Exception {
        JSONObject owningNode;
        JSONObject ruleSum;
        int i;
        RuleServiceTest.assertNotNull((String)"Response is null.", (Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONObject data = result.getJSONObject("data");
        if (data.has("rules")) {
            JSONArray rulesArray = data.getJSONArray("rules");
            RuleServiceTest.assertEquals((int)rulesCount, (int)rulesArray.length());
            for (i = 0; i < rulesArray.length(); ++i) {
                ruleSum = rulesArray.getJSONObject(i);
                RuleServiceTest.assertTrue((boolean)ruleSum.has("id"));
                RuleServiceTest.assertEquals((String)ruleIds[i], (String)ruleSum.getString("id"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("title"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("ruleType"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("disabled"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("owningNode"));
                owningNode = ruleSum.getJSONObject("owningNode");
                RuleServiceTest.assertTrue((boolean)owningNode.has("nodeRef"));
                RuleServiceTest.assertTrue((boolean)owningNode.has("name"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("url"));
            }
        }
        if (data.has("inheritedRules")) {
            JSONArray inheritedRulesArray = data.getJSONArray("inheritedRules");
            RuleServiceTest.assertEquals((int)inhRulesCount, (int)inheritedRulesArray.length());
            for (i = 0; i < inheritedRulesArray.length(); ++i) {
                ruleSum = inheritedRulesArray.getJSONObject(i);
                RuleServiceTest.assertTrue((boolean)ruleSum.has("id"));
                RuleServiceTest.assertEquals((String)parentRuleIds[i], (String)ruleSum.getString("id"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("title"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("ruleType"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("disabled"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("owningNode"));
                owningNode = ruleSum.getJSONObject("owningNode");
                RuleServiceTest.assertTrue((boolean)owningNode.has("nodeRef"));
                RuleServiceTest.assertTrue((boolean)owningNode.has("name"));
                RuleServiceTest.assertTrue((boolean)ruleSum.has("url"));
            }
        }
        RuleServiceTest.assertEquals((boolean)isLinkedTo, (boolean)data.has("linkedToRuleSet"));
        RuleServiceTest.assertEquals((boolean)isLinkedFrom, (boolean)data.has("linkedFromRuleSets"));
        RuleServiceTest.assertTrue((boolean)data.has("url"));
    }

    public void testGetRuleTypes() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RULETYPES), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONArray data = result.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject ruleType = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)ruleType.has("name"));
            RuleServiceTest.assertTrue((boolean)ruleType.has("displayLabel"));
            RuleServiceTest.assertTrue((boolean)ruleType.has("url"));
        }
    }

    public void testGetActionDefinitions() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_ACTIONDEFINITIONS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONArray data = result.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject actionDefinition = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("name"));
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("displayLabel"));
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("description"));
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("adHocPropertiesAllowed"));
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("parameterDefinitions"));
            RuleServiceTest.assertTrue((boolean)actionDefinition.has("applicableTypes"));
        }
    }

    public void testGetActionConditionDefinitions() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_ACTIONCONDITIONDEFINITIONS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONArray data = result.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject actionConditionDefinition = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)actionConditionDefinition.has("name"));
            RuleServiceTest.assertTrue((boolean)actionConditionDefinition.has("displayLabel"));
            RuleServiceTest.assertTrue((boolean)actionConditionDefinition.has("description"));
            RuleServiceTest.assertTrue((boolean)actionConditionDefinition.has("adHocPropertiesAllowed"));
            RuleServiceTest.assertTrue((boolean)actionConditionDefinition.has("parameterDefinitions"));
        }
    }

    public void testGetActionConstraints() throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_ACTIONCONSTRAINTS), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONArray data = result.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject actionConstraint = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)actionConstraint.has("name"));
            RuleServiceTest.assertTrue((boolean)actionConstraint.has("values"));
            JSONArray values = actionConstraint.getJSONArray("values");
            for (int j = 0; j < values.length(); ++j) {
                JSONObject value = values.getJSONObject(j);
                RuleServiceTest.assertTrue((boolean)value.has("value"));
                RuleServiceTest.assertTrue((boolean)value.has("displayLabel"));
            }
        }
    }

    public void testGetActionConstraint() throws Exception {
        List constraints = this.actionService.getParameterConstraints();
        if (constraints.size() == 0) {
            return;
        }
        String name = ((ParameterConstraint)constraints.get(0)).getName();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formateActionConstraintUrl(name)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONObject data = result.getJSONObject("data");
        RuleServiceTest.assertTrue((boolean)data.has("name"));
        RuleServiceTest.assertTrue((boolean)data.has("values"));
        JSONArray values = data.getJSONArray("values");
        for (int i = 0; i < values.length(); ++i) {
            JSONObject value = values.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)value.has("value"));
            RuleServiceTest.assertTrue((boolean)value.has("displayLabel"));
        }
    }

    public void testQueueAction() throws Exception {
        String url = this.formateQueueActionUrl(false);
        JSONObject copyAction = this.buildCopyAction(this.testWorkNodeRef);
        copyAction.put("actionedUponNode", (Object)this.testNodeRef);
        TestWebScriptServer.Response successResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, copyAction.toString(), "application/json"), 200);
        JSONObject successResult = new JSONObject(successResponse.getContentAsString());
        RuleServiceTest.assertNotNull((Object)successResult);
        RuleServiceTest.assertTrue((boolean)successResult.has("data"));
        JSONObject successData = successResult.getJSONObject("data");
        RuleServiceTest.assertTrue((boolean)successData.has("status"));
        RuleServiceTest.assertEquals((String)"success", (String)successData.getString("status"));
        RuleServiceTest.assertTrue((boolean)successData.has("actionedUponNode"));
        RuleServiceTest.assertFalse((boolean)successData.has("exception"));
        RuleServiceTest.assertTrue((boolean)successData.has("action"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, copyAction.toString(), "application/json"), 500);
        String asyncUrl = this.formateQueueActionUrl(true);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(asyncUrl, copyAction.toString(), "application/json"), 200);
        Thread.sleep(1000L);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("data"));
        JSONObject data = result.getJSONObject("data");
        RuleServiceTest.assertTrue((boolean)data.has("status"));
        RuleServiceTest.assertEquals((String)"queued", (String)data.getString("status"));
        RuleServiceTest.assertTrue((boolean)data.has("actionedUponNode"));
        RuleServiceTest.assertFalse((boolean)data.has("exception"));
        RuleServiceTest.assertTrue((boolean)data.has("action"));
    }

    public void testCreateRule() throws Exception {
        JSONObject result = this.createRule(this.testNodeRef);
        this.checkRuleSummary(result);
        List rules = this.ruleService.getRules(this.testNodeRef);
        RuleServiceTest.assertEquals((int)1, (int)rules.size());
    }

    public void testGetRulesCollection() throws Exception {
        JSONArray data = this.getNodeRules(this.testNodeRef, false);
        RuleServiceTest.assertEquals((int)0, (int)data.length());
        this.createRule(this.testNodeRef);
        data = this.getNodeRules(this.testNodeRef, false);
        RuleServiceTest.assertEquals((int)1, (int)data.length());
        for (int i = 0; i < data.length(); ++i) {
            JSONObject ruleSum = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)ruleSum.has("id"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("title"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("ruleType"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("disabled"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("owningNode"));
            JSONObject owningNode = ruleSum.getJSONObject("owningNode");
            RuleServiceTest.assertTrue((boolean)owningNode.has("nodeRef"));
            RuleServiceTest.assertTrue((boolean)owningNode.has("name"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("url"));
        }
    }

    public void testGetInheritedRulesCollection() throws Exception {
        JSONArray data = this.getNodeRules(this.testNodeRef, true);
        RuleServiceTest.assertEquals((int)0, (int)data.length());
        this.createRule(this.testWorkNodeRef);
        data = this.getNodeRules(this.testNodeRef, true);
        RuleServiceTest.assertEquals((int)1, (int)data.length());
        for (int i = 0; i < data.length(); ++i) {
            JSONObject ruleSum = data.getJSONObject(i);
            RuleServiceTest.assertTrue((boolean)ruleSum.has("id"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("title"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("ruleType"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("disabled"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("owningNode"));
            JSONObject owningNode = ruleSum.getJSONObject("owningNode");
            RuleServiceTest.assertTrue((boolean)owningNode.has("nodeRef"));
            RuleServiceTest.assertTrue((boolean)owningNode.has("name"));
            RuleServiceTest.assertTrue((boolean)ruleSum.has("url"));
        }
    }

    public void testGetRuleset() throws Exception {
        JSONObject parentRule = this.createRule(this.testWorkNodeRef);
        String[] parentRuleIds = new String[]{parentRule.getJSONObject("data").getString("id")};
        JSONObject jsonRule = this.createRule(this.testNodeRef);
        String[] ruleIds = new String[]{jsonRule.getJSONObject("data").getString("id")};
        Action linkRulesAction = this.actionService.createAction("link-rules");
        linkRulesAction.setParameterValue("link_from_node", (Serializable)this.testNodeRef);
        this.actionService.executeAction(linkRulesAction, this.testNodeRef2);
        TestWebScriptServer.Response linkedFromResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formatRulesetUrl(this.testNodeRef)), 200);
        JSONObject linkedFromResult = new JSONObject(linkedFromResponse.getContentAsString());
        this.checkRuleset(linkedFromResult, 1, ruleIds, 1, parentRuleIds, true, false);
        TestWebScriptServer.Response linkedToResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formatRulesetUrl(this.testNodeRef2)), 200);
        JSONObject linkedToResult = new JSONObject(linkedToResponse.getContentAsString());
        this.checkRuleset(linkedToResult, 1, ruleIds, 1, parentRuleIds, false, true);
    }

    public void testGetRuleDetails() throws Exception {
        JSONObject jsonRule = this.createRule(this.testNodeRef);
        String ruleId = jsonRule.getJSONObject("data").getString("id");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formateRuleUrl(this.testNodeRef, ruleId)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        this.checkRuleComplete(result);
    }

    public void testUpdateRule() throws Exception {
        JSONObject jsonRule = this.createRule(this.testNodeRef);
        String ruleId = jsonRule.getJSONObject("data").getString("id");
        TestWebScriptServer.Response getResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.formateRuleUrl(this.testNodeRef, ruleId)), 200);
        JSONObject before = new JSONObject(getResponse.getContentAsString());
        before.put("description", (Object)"this is modified description for test_rule");
        JSONObject beforeAction = before.getJSONObject("action");
        beforeAction.remove("actions");
        beforeAction.put("conditions", (Object)new JSONArray());
        TestWebScriptServer.Response putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(this.formateRuleUrl(this.testNodeRef, ruleId), before.toString(), "application/json"), 200);
        JSONObject after = new JSONObject(putResponse.getContentAsString());
        this.checkUpdatedRule(before, after);
    }

    public void testDeleteRule() throws Exception {
        JSONObject jsonRule = this.createRule(this.testNodeRef);
        RuleServiceTest.assertEquals((int)1, (int)this.ruleService.getRules(this.testNodeRef).size());
        String ruleId = jsonRule.getJSONObject("data").getString("id");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(this.formateRuleUrl(this.testNodeRef, ruleId)), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        RuleServiceTest.assertNotNull((Object)result);
        RuleServiceTest.assertTrue((boolean)result.has("success"));
        boolean success = result.getBoolean("success");
        RuleServiceTest.assertTrue((boolean)success);
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(this.testNodeRef).size());
    }

    public void testRuleReorder() throws Exception {
        RuleServiceTest.assertEquals((int)0, (int)this.ruleService.getRules(this.testNodeRef).size());
        NodeRef rule1 = this.createRuleNodeRef(this.testNodeRef, "Rule 1");
        NodeRef rule2 = this.createRuleNodeRef(this.testNodeRef, "Rule 2");
        NodeRef rule3 = this.createRuleNodeRef(this.testNodeRef, "Rule 3");
        List rules = this.ruleService.getRules(this.testNodeRef);
        RuleServiceTest.assertEquals((int)3, (int)rules.size());
        RuleServiceTest.assertEquals((String)"Rule 1", (String)((Rule)rules.get(0)).getTitle());
        RuleServiceTest.assertEquals((String)"Rule 2", (String)((Rule)rules.get(1)).getTitle());
        RuleServiceTest.assertEquals((String)"Rule 3", (String)((Rule)rules.get(2)).getTitle());
        JSONObject action = new JSONObject();
        action.put("actionDefinitionName", (Object)"reorder-rules");
        action.put("actionedUponNode", (Object)this.testNodeRef.toString());
        JSONObject params = new JSONObject();
        JSONArray orderArray = new JSONArray();
        orderArray.put((Object)((Rule)rules.get(2)).getNodeRef().toString());
        orderArray.put((Object)((Rule)rules.get(1)).getNodeRef().toString());
        orderArray.put((Object)((Rule)rules.get(0)).getNodeRef().toString());
        params.put("rules", (Object)orderArray);
        action.put("parameterValues", (Object)params);
        String url = this.formateQueueActionUrl(false);
        TestWebScriptServer.Response successResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(url, action.toString(), "application/json"), 200);
        JSONObject successResult = new JSONObject(successResponse.getContentAsString());
        RuleServiceTest.assertNotNull((Object)successResult);
        RuleServiceTest.assertTrue((boolean)successResult.has("data"));
        JSONObject successData = successResult.getJSONObject("data");
        RuleServiceTest.assertTrue((boolean)successData.has("status"));
        RuleServiceTest.assertEquals((String)"success", (String)successData.getString("status"));
        RuleServiceTest.assertTrue((boolean)successData.has("actionedUponNode"));
        RuleServiceTest.assertFalse((boolean)successData.has("exception"));
        RuleServiceTest.assertTrue((boolean)successData.has("action"));
        rules = this.ruleService.getRules(this.testNodeRef);
        RuleServiceTest.assertEquals((int)3, (int)rules.size());
        RuleServiceTest.assertEquals((String)"Rule 3", (String)((Rule)rules.get(0)).getTitle());
        RuleServiceTest.assertEquals((String)"Rule 2", (String)((Rule)rules.get(1)).getTitle());
        RuleServiceTest.assertEquals((String)"Rule 1", (String)((Rule)rules.get(2)).getTitle());
    }

    private NodeRef createRuleNodeRef(NodeRef folder, String title) throws Exception {
        JSONObject jsonRule = this.createRule(folder, title);
        String id = jsonRule.getJSONObject("data").getString("id");
        return new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, id);
    }

    private JSONObject buildCopyAction(NodeRef destination) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("actionDefinitionName", (Object)"copy");
        JSONObject parameterValues = new JSONObject();
        parameterValues.put("destination-folder", (Object)destination);
        result.put("parameterValues", (Object)parameterValues);
        result.put("executeAsync", false);
        return result;
    }

    private JSONObject buildTestRule(String title) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("title", (Object)title);
        result.put("description", (Object)"this is description for test_rule");
        JSONArray ruleType = new JSONArray();
        ruleType.put((Object)"outbound");
        result.put("ruleType", (Object)ruleType);
        result.put("applyToChildren", true);
        result.put("executeAsynchronously", false);
        result.put("disabled", false);
        result.put("action", (Object)this.buildTestAction("composite-action", true, true));
        return result;
    }

    private JSONObject buildTestAction(String actionName, boolean addActions, boolean addCompensatingAction) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("actionDefinitionName", (Object)actionName);
        result.put("description", (Object)("this is description for " + actionName));
        result.put("title", (Object)"test_title");
        result.put("executeAsync", addActions);
        if (addActions) {
            JSONArray actions = new JSONArray();
            actions.put((Object)this.buildTestAction("counter", false, false));
            result.put("actions", (Object)actions);
        }
        JSONArray conditions = new JSONArray();
        conditions.put((Object)this.buildTestCondition("no-condition"));
        result.put("conditions", (Object)conditions);
        if (addCompensatingAction) {
            result.put("compensatingAction", (Object)this.buildTestAction("script", false, false));
        }
        return result;
    }

    private JSONObject buildTestCondition(String conditionName) throws JSONException {
        JSONObject result = new JSONObject();
        result.put("conditionDefinitionName", (Object)conditionName);
        result.put("invertCondition", false);
        return result;
    }
}

