/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.Authorization;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class BasicHttpAuthenticatorFactory
implements ServletAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(BasicHttpAuthenticator.class);
    private AuthenticationService authenticationService;

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new BasicHttpAuthenticator(req, res);
    }

    public class BasicHttpAuthenticator
    implements Authenticator {
        private WebScriptServletRequest servletReq;
        private WebScriptServletResponse servletRes;
        private String authorization;
        private String ticket;

        public BasicHttpAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res) {
            this.servletReq = req;
            this.servletRes = res;
            HttpServletRequest httpReq = this.servletReq.getHttpServletRequest();
            this.authorization = httpReq.getHeader("Authorization");
            this.ticket = httpReq.getParameter("alf_ticket");
        }

        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authorized = false;
            HttpServletResponse res = this.servletRes.getHttpServletResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HTTP Authorization provided: " + (this.authorization != null && this.authorization.length() > 0)));
                logger.debug((Object)("URL ticket provided: " + (this.ticket != null && this.ticket.length() > 0)));
            }
            if (isGuest && Description.RequiredAuthentication.guest == required) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Authenticating as Guest");
                }
                try {
                    BasicHttpAuthenticatorFactory.this.authenticationService.authenticateAsGuest();
                    authorized = true;
                }
                catch (AuthenticationException ex) {}
            } else if (this.ticket != null && this.ticket.length() > 0) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authenticating (URL argument) ticket " + this.ticket));
                    }
                    BasicHttpAuthenticatorFactory.this.authenticationService.validate(this.ticket);
                    authorized = true;
                }
                catch (AuthenticationException e) {}
            } else if (this.authorization != null && this.authorization.length() > 0) {
                try {
                    String[] authorizationParts = this.authorization.split(" ");
                    if (!authorizationParts[0].equalsIgnoreCase("basic")) {
                        throw new WebScriptException("Authorization '" + authorizationParts[0] + "' not supported.");
                    }
                    String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
                    Authorization auth = new Authorization(decodedAuthorisation);
                    if (auth.isTicket()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Authenticating (BASIC HTTP) ticket " + auth.getTicket()));
                        }
                        BasicHttpAuthenticatorFactory.this.authenticationService.validate(auth.getTicket());
                        authorized = true;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Authenticating (BASIC HTTP) user " + auth.getUserName()));
                        }
                        BasicHttpAuthenticatorFactory.this.authenticationService.authenticate(auth.getUserName(), auth.getPassword().toCharArray());
                        authorized = true;
                    }
                }
                catch (AuthenticationException e) {
                    // empty catch block
                }
            }
            if (!authorized) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Requesting authorization credentials");
                }
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"Alfresco\"");
            }
            return authorized;
        }

        public boolean emptyCredentials() {
            return !(this.ticket != null && this.ticket.length() != 0 || this.authorization != null && this.authorization.length() != 0);
        }
    }
}

