/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.management.subsystems.ChildApplicationContextManager;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.web.scripts.site.AbstractSiteWebScript;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class SiteExportGet
extends AbstractWebScript {
    private static final List<String> USERS_NOT_TO_EXPORT = Arrays.asList("admin", "guest");
    private SiteService siteService;
    private ExporterService exporterService;
    private MimetypeService mimetypeService;
    private AuthorityService authorityService;
    private ChildApplicationContextManager authenticationContextManager;

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String siteName = (String)req.getServiceMatch().getTemplateVars().get("shortname");
        SiteInfo site = this.siteService.getSite(siteName);
        if (site == null) {
            throw new WebScriptException(404, "No Site found with that short name");
        }
        res.setContentType("application/zip");
        res.setHeader("Content-Disposition", "attachment; fileName=" + siteName + "-export.zip");
        ZipOutputStream mainZip = new ZipOutputStream(res.getOutputStream());
        CloseIgnoringOutputStream outputForNesting = new CloseIgnoringOutputStream((OutputStream)mainZip);
        mainZip.putNextEntry(new ZipEntry("Contents.acp"));
        this.doSiteACPExport(site, outputForNesting);
        mainZip.putNextEntry(new ZipEntry("People.acp"));
        this.doPeopleACPExport(site, outputForNesting);
        mainZip.putNextEntry(new ZipEntry("Groups.txt"));
        this.doGroupExport(site, outputForNesting);
        RepositoryAuthenticationDao authenticationDao = null;
        for (String contextName : this.authenticationContextManager.getInstanceIds()) {
            ApplicationContext ctx = this.authenticationContextManager.getApplicationContext(contextName);
            try {
                authenticationDao = (RepositoryAuthenticationDao)ctx.getBean(RepositoryAuthenticationDao.class);
            }
            catch (NoSuchBeanDefinitionException e) {}
        }
        if (authenticationDao == null) {
            mainZip.putNextEntry(new ZipEntry("Users_Skipped_As_Wrong_Authentication.txt"));
            String text = "Users were not exported because the Authentication\nSubsystem you are using is not repository based";
            outputForNesting.write(text.getBytes("ASCII"));
        } else {
            mainZip.putNextEntry(new ZipEntry("Users.acp"));
            this.doUserACPExport(site, outputForNesting, authenticationDao);
        }
        mainZip.close();
    }

    protected void doSiteACPExport(SiteInfo site, CloseIgnoringOutputStream writeTo) throws IOException {
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(new Location(site.getNodeRef()));
        parameters.setCrawlChildNodes(true);
        parameters.setCrawlSelf(true);
        parameters.setCrawlContent(true);
        ACPExportPackageHandler handler = new ACPExportPackageHandler((OutputStream)writeTo, new File(site.getShortName() + ".xml"), new File(site.getShortName()), this.mimetypeService);
        this.exporterService.exportView((ExportPackageHandler)handler, parameters, null);
    }

    protected void doPeopleACPExport(SiteInfo site, CloseIgnoringOutputStream writeTo) throws IOException {
        String siteGroup = AbstractSiteWebScript.buildSiteGroup(site);
        Set siteUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, siteGroup, false);
        ArrayList<NodeRef> peopleNodes = new ArrayList<NodeRef>(siteUsers.size());
        for (String authority : siteUsers) {
            if (USERS_NOT_TO_EXPORT.contains(authority)) continue;
            peopleNodes.add(this.authorityService.getAuthorityNodeRef(authority));
        }
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(new Location(peopleNodes.toArray(new NodeRef[peopleNodes.size()])));
        parameters.setCrawlChildNodes(true);
        parameters.setCrawlSelf(true);
        parameters.setCrawlContent(true);
        ACPExportPackageHandler handler = new ACPExportPackageHandler((OutputStream)writeTo, new File(site.getShortName() + "-people.xml"), new File(site.getShortName() + "-people"), this.mimetypeService);
        this.exporterService.exportView((ExportPackageHandler)handler, parameters, null);
    }

    protected void doGroupExport(SiteInfo site, CloseIgnoringOutputStream writeTo) throws IOException {
        String siteGroup = AbstractSiteWebScript.buildSiteGroup(site);
        Set siteGroups = this.authorityService.getContainedAuthorities(AuthorityType.GROUP, siteGroup, true);
        HashMap memberships = new HashMap();
        for (String group : siteGroups) {
            Set groupUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, false);
            for (String user : groupUsers) {
                if (USERS_NOT_TO_EXPORT.contains(user)) continue;
                if (!memberships.containsKey(user)) {
                    memberships.put(user, new ArrayList());
                }
                ((List)memberships.get(user)).add(group);
            }
        }
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)writeTo, "UTF-8"));
        for (String user : memberships.keySet()) {
            out.print(user);
            out.print('=');
            boolean first = true;
            for (String group : (List)memberships.get(user)) {
                if (first) {
                    first = false;
                } else {
                    out.print(',');
                }
                out.print(group);
            }
            out.println();
        }
        out.close();
    }

    protected void doUserACPExport(SiteInfo site, CloseIgnoringOutputStream writeTo, RepositoryAuthenticationDao authenticationDao) throws IOException {
        ArrayList<NodeRef> exportNodes = new ArrayList<NodeRef>();
        String siteGroup = AbstractSiteWebScript.buildSiteGroup(site);
        Set siteUsers = this.authorityService.getContainedAuthorities(AuthorityType.USER, siteGroup, false);
        for (String user : siteUsers) {
            if (USERS_NOT_TO_EXPORT.contains(user)) continue;
            NodeRef userNodeRef = authenticationDao.getUserOrNull(user);
            exportNodes.add(userNodeRef);
        }
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(new Location(exportNodes.toArray(new NodeRef[exportNodes.size()])));
        parameters.setCrawlChildNodes(true);
        parameters.setCrawlSelf(true);
        parameters.setCrawlContent(true);
        ACPExportPackageHandler handler = new ACPExportPackageHandler((OutputStream)writeTo, new File(site.getShortName() + "-users.xml"), new File(site.getShortName() + "-users"), this.mimetypeService);
        this.exporterService.exportView((ExportPackageHandler)handler, parameters, null);
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAuthenticationContextManager(ChildApplicationContextManager authenticationContextManager) {
        this.authenticationContextManager = authenticationContextManager;
    }

    protected static class CloseIgnoringOutputStream
    extends FilterOutputStream {
        public CloseIgnoringOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

