/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.authority.script.ScriptAuthorityService;
import org.alfresco.repo.web.scripts.site.AbstractSiteWebScript;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteMemberInfo;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SiteMembershipsGet
extends AbstractSiteWebScript {
    private PersonService personService;
    private ScriptAuthorityService scriptAuthorityService;

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setScriptAuthorityService(ScriptAuthorityService scriptAuthorityService) {
        this.scriptAuthorityService = scriptAuthorityService;
    }

    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, WebScriptRequest req, Status status, Cache cache) {
        String nameFilter = req.getParameter("nf");
        if (nameFilter != null) {
            nameFilter = nameFilter.endsWith("*") ? nameFilter : nameFilter + "*";
        }
        String roleFilter = req.getParameter("rf");
        String authorityType = req.getParameter("authorityType");
        String sizeS = req.getParameter("size");
        boolean collapseGroups = false;
        if (authorityType != null) {
            if ("USER".equals(authorityType)) {
                collapseGroups = true;
            } else if (!"GROUP".equals(authorityType)) {
                throw new WebScriptException(400, "The Authority must be one of USER or GROUP");
            }
        }
        int limit = 0;
        if (sizeS != null) {
            try {
                limit = Integer.parseInt(sizeS);
            }
            catch (NumberFormatException e) {
                throw new WebScriptException(400, "Invalid size specified");
            }
        }
        List members = this.siteService.listMembersInfo(site.getShortName(), nameFilter, roleFilter, limit, collapseGroups);
        HashMap<String, Object> authorities = new HashMap<String, Object>(members.size());
        LinkedHashMap<String, SiteMemberInfo> memberInfo = new LinkedHashMap<String, SiteMemberInfo>(members.size());
        for (SiteMemberInfo authorityObj : members) {
            String ftlSafeName = "_" + authorityObj.getMemberName();
            if (authorityObj.getMemberName().startsWith("GROUP_")) {
                if (authorityType != null && !authorityType.equals("GROUP")) continue;
                authorities.put(ftlSafeName, this.scriptAuthorityService.getGroupForFullAuthorityName(authorityObj.getMemberName()));
                memberInfo.put(ftlSafeName, authorityObj);
                continue;
            }
            if (authorityType != null && !authorityType.equals("USER")) continue;
            authorities.put(ftlSafeName, this.personService.getPerson(authorityObj.getMemberName()));
            memberInfo.put(ftlSafeName, authorityObj);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("site", site);
        model.put("authorities", authorities);
        model.put("memberInfo", memberInfo);
        return model;
    }
}

