/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.DataListModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.UrlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SiteShareViewUrlGet
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(SiteShareViewUrlGet.class);
    protected NodeService nodeService;
    protected SiteService siteService;
    protected SysAdminParams sysAdminParams;
    protected DictionaryService dictionaryService;
    private static QName TYPE_LINK = QName.createQName((String)"http://www.alfresco.org/model/linksmodel/1.0", (String)"link");

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        String nodeRefS = req.getParameter("nodeRef");
        if (nodeRefS == null) {
            throw new WebScriptException(400, "NodeRef must be supplied");
        }
        if (!NodeRef.isNodeRef((String)nodeRefS)) {
            throw new WebScriptException(400, "Invalid NodeRef");
        }
        NodeRef nodeRef = new NodeRef(nodeRefS);
        if (!this.nodeService.exists(nodeRef)) {
            throw new WebScriptException(404, "Node Does Not Exist");
        }
        SiteInfo site = null;
        NodeRef siteContainer = null;
        NodeRef current = nodeRef;
        NodeRef prev = null;
        while (current != null) {
            QName type = this.nodeService.getType(current);
            if (this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE)) {
                siteContainer = prev;
                site = this.siteService.getSite(current);
                break;
            }
            prev = current;
            current = this.nodeService.getPrimaryParent(current).getParentRef();
        }
        if (site == null) {
            throw new WebScriptException(400, "Node isn't part of a site");
        }
        String baseUrl = this.getShareSiteRootStem(req, site);
        QName nodeType = this.nodeService.getType(nodeRef);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("node", nodeRef);
        model.put("site", site);
        model.put("type", nodeType);
        String page = this.identifySharePage(nodeRef, site, siteContainer, nodeType);
        model.put("url", baseUrl + page);
        return model;
    }

    protected String identifySharePage(NodeRef nodeRef, SiteInfo site, NodeRef siteContainer, QName nodeType) {
        String name = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        if (siteContainer != null && this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_CONTENT)) {
            QName containerName = this.nodeService.getPrimaryParent(siteContainer).getQName();
            if (containerName.equals((Object)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"blog"))) {
                return "wiki-page?title=" + name;
            }
            if (containerName.equals((Object)QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"wiki"))) {
                return "blog-postview?postId=" + name;
            }
        }
        if (this.dictionaryService.isSubClass(nodeType, DataListModel.TYPE_DATALIST)) {
            return "data-lists?list=" + name;
        }
        if (this.dictionaryService.isSubClass(nodeType, TYPE_LINK)) {
            return "links-view?linkId=" + name;
        }
        if (this.dictionaryService.isSubClass(nodeType, CalendarModel.TYPE_EVENT)) {
            Date date = (Date)this.nodeService.getProperty(nodeRef, CalendarModel.PROP_FROM_DATE);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            return "calendar?date=" + fmt.format(date);
        }
        if (this.dictionaryService.isSubClass(nodeType, ForumModel.TYPE_TOPIC)) {
            return "discussions-topicview?topicId=" + name;
        }
        if (this.dictionaryService.isSubClass(nodeType, ForumModel.TYPE_POST)) {
            NodeRef postTopic = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
            String topicName = (String)((Object)this.nodeService.getProperty(postTopic, ContentModel.PROP_NAME));
            return "discussions-topicview?topicId=" + topicName;
        }
        if (this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_CONTENT)) {
            return "document-details?nodeRef=" + nodeRef.toString();
        }
        if (this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_FOLDER)) {
            ArrayList<String> paths = new ArrayList<String>();
            NodeRef current = nodeRef;
            while (current != null && !current.equals((Object)siteContainer) && !current.equals((Object)site.getNodeRef())) {
                paths.add((String)((Object)this.nodeService.getProperty(current, ContentModel.PROP_NAME)));
                current = this.nodeService.getPrimaryParent(current).getParentRef();
            }
            StringBuilder path = new StringBuilder();
            for (int i = paths.size() - 1; i >= 0; --i) {
                path.append('/');
                path.append((String)paths.get(i));
            }
            if (path.length() > 0) {
                return "documentlibrary?path=" + path.toString();
            }
            return "documentlibrary";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("COuldn't identify specific URL for Node " + nodeRef + " of type " + nodeType));
        }
        return "dashboard";
    }

    protected String getShareSiteRootStem(WebScriptRequest req, SiteInfo site) {
        return this.getShareRootUrl(req) + "page/site/" + site.getShortName() + "/";
    }

    protected String getShareRootUrl(WebScriptRequest req) {
        return UrlUtil.getShareUrl((SysAdminParams)this.sysAdminParams) + "/";
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

