/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.solr.SOLRTrackingComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AclsReadersGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(AclsReadersGet.class);
    private SOLRTrackingComponent solrTrackingComponent;

    public void setSolrTrackingComponent(SOLRTrackingComponent solrTrackingComponent) {
        this.solrTrackingComponent = solrTrackingComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Map<String, Object> model = this.buildModel(req);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
            }
            return model;
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    private Map<String, Object> buildModel(WebScriptRequest req) throws JSONException, IOException {
        JSONArray aclIdsJSON;
        ArrayList<Long> aclIds = null;
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Request content is empty");
        }
        JSONObject o = new JSONObject(content.getContent());
        JSONArray jSONArray = aclIdsJSON = o.has("aclIds") ? o.getJSONArray("aclIds") : null;
        if (aclIdsJSON == null) {
            throw new WebScriptException(400, "Parameter 'aclIds' not provided in request content.");
        }
        if (aclIdsJSON.length() == 0 || aclIdsJSON.length() > 512) {
            throw new WebScriptException(400, "Parameter 'aclIds' must hold from 1 to 512 IDs.");
        }
        aclIds = new ArrayList<Long>(aclIdsJSON.length());
        for (int i = 0; i < aclIdsJSON.length(); ++i) {
            aclIds.add(aclIdsJSON.getLong(i));
        }
        List aclsReaders = this.solrTrackingComponent.getAclsReaders(aclIds);
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        model.put("aclsReaders", aclsReaders);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
        }
        return model;
    }
}

