/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.web.scripts.content.StreamContent;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class NodeContentGet
extends StreamContent {
    private static final String TRANSFORM_STATUS_HEADER = "X-Alfresco-transformStatus";
    private static final String TRANSFORM_EXCEPTION_HEADER = "X-Alfresco-transformException";
    private static final String TRANSFORM_DURATION_HEADER = "X-Alfresco-transformDuration";
    private static final Log logger = LogFactory.getLog(NodeContentGet.class);
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    private NodeDAO nodeDAO;
    private NodeService nodeService;
    private ContentService contentService;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    @Override
    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        ContentReader reader;
        ContentReader textReader = null;
        ContentIOException transformException = null;
        String nodeIDString = req.getParameter("nodeId");
        if (nodeIDString == null) {
            throw new WebScriptException("nodeID parameter is required for GetNodeContent");
        }
        long nodeId = Long.valueOf(nodeIDString);
        String propertyQName = req.getParameter("propertyQName");
        QName propertyName = null;
        propertyName = propertyQName == null ? ContentModel.PROP_CONTENT : QName.createQName((String)propertyQName);
        Pair pair = this.nodeDAO.getNodePair(Long.valueOf(nodeId));
        if (pair == null) {
            throw new WebScriptException("Node id does not exist");
        }
        NodeRef nodeRef = (NodeRef)pair.getSecond();
        Date modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
        if (modified == null) {
            modified = new Date();
        }
        long modifiedSince = -1L;
        String modifiedSinceStr = req.getHeader("If-Modified-Since");
        if (modifiedSinceStr != null) {
            long modDate;
            block14: {
                try {
                    modifiedSince = dateFormat.parse(modifiedSinceStr).getTime();
                }
                catch (Throwable e) {
                    if (!logger.isWarnEnabled()) break block14;
                    logger.warn((Object)("Browser sent badly-formatted If-Modified-Since header: " + modifiedSinceStr));
                }
            }
            if (modifiedSince > 0L && (modDate = modified.getTime() / 1000L * 1000L) <= modifiedSince) {
                res.setStatus(304);
                return;
            }
        }
        if ((reader = this.contentService.getReader(nodeRef, propertyName)) == null) {
            res.setStatus(204);
            return;
        }
        ContentTransformer transformer = this.contentService.getTransformer(reader.getMimetype(), "text/plain");
        if (transformer == null) {
            res.setHeader(TRANSFORM_STATUS_HEADER, "noTransform");
            res.setStatus(204);
            return;
        }
        ContentWriter writer = this.contentService.getTempWriter();
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        try {
            long start = System.currentTimeMillis();
            transformer.transform(reader, writer);
            long transformDuration = System.currentTimeMillis() - start;
            res.setHeader(TRANSFORM_DURATION_HEADER, String.valueOf(transformDuration));
        }
        catch (ContentIOException e) {
            transformException = e;
        }
        if (!(transformException != null || (textReader = writer.getReader()) != null && textReader.exists())) {
            transformException = new ContentIOException("The transformation did not write any content, yet: \n   transformer:     " + transformer + "\n" + "   temp writer:     " + writer);
        }
        if (transformException != null) {
            res.setHeader(TRANSFORM_STATUS_HEADER, "transformFailed");
            res.setHeader(TRANSFORM_EXCEPTION_HEADER, transformException.getMessage());
            res.setStatus(204);
        } else {
            res.setStatus(200);
            this.streamContentImpl(req, res, textReader, false, modified, String.valueOf(modified.getTime()), null);
        }
    }
}

