/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.SOLRTrackingComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodesGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(NodesGet.class);
    private SOLRTrackingComponent solrTrackingComponent;
    private TenantService tenantService;
    private QNameDAO qnameDAO;

    public void setSolrTrackingComponent(SOLRTrackingComponent solrTrackingComponent) {
        this.solrTrackingComponent = solrTrackingComponent;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Content content = req.getContent();
            if (content == null) {
                throw new WebScriptException("Failed to convert request to String");
            }
            JSONObject o = new JSONObject(content.getContent());
            JSONArray aTxnIds = o.has("txnIds") ? o.getJSONArray("txnIds") : null;
            Long fromTxnId = o.has("fromTxnId") ? Long.valueOf(o.getLong("fromTxnId")) : null;
            Long toTxnId = o.has("toTxnId") ? Long.valueOf(o.getLong("toTxnId")) : null;
            Long fromNodeId = o.has("fromNodeId") ? Long.valueOf(o.getLong("fromNodeId")) : null;
            Long toNodeId = o.has("toNodeId") ? Long.valueOf(o.getLong("toNodeId")) : null;
            HashSet<QName> excludeAspects = null;
            if (o.has("excludeAspects")) {
                JSONArray aExcludeAspects = o.getJSONArray("excludeAspects");
                excludeAspects = new HashSet<QName>(aExcludeAspects.length());
                for (int i = 0; i < aExcludeAspects.length(); ++i) {
                    excludeAspects.add(QName.createQName((String)aExcludeAspects.getString(i).trim()));
                }
            }
            HashSet<QName> includeAspects = null;
            if (o.has("includeAspects")) {
                JSONArray aIncludeAspects = o.getJSONArray("includeAspects");
                includeAspects = new HashSet<QName>(aIncludeAspects.length());
                for (int i = 0; i < aIncludeAspects.length(); ++i) {
                    includeAspects.add(QName.createQName((String)aIncludeAspects.getString(i).trim()));
                }
            }
            HashSet<QName> excludeNodeTypes = null;
            if (o.has("excludeNodeTypes")) {
                JSONArray aExcludeNodeTypes = o.getJSONArray("excludeNodeTypes");
                excludeNodeTypes = new HashSet<QName>(aExcludeNodeTypes.length());
                for (int i = 0; i < aExcludeNodeTypes.length(); ++i) {
                    excludeNodeTypes.add(QName.createQName((String)aExcludeNodeTypes.getString(i).trim()));
                }
            }
            HashSet<QName> includeNodeTypes = null;
            if (o.has("includeNodeTypes")) {
                JSONArray aIncludeNodeTypes = o.getJSONArray("includeNodeTypes");
                includeNodeTypes = new HashSet<QName>(aIncludeNodeTypes.length());
                for (int i = 0; i < aIncludeNodeTypes.length(); ++i) {
                    includeNodeTypes.add(QName.createQName((String)aIncludeNodeTypes.getString(i).trim()));
                }
            }
            int maxResults = o.has("maxResults") ? o.getInt("maxResults") : 0;
            String storeProtocol = o.has("storeProtocol") ? o.getString("storeProtocol") : null;
            String storeIdentifier = o.has("storeIdentifier") ? o.getString("storeIdentifier") : null;
            ArrayList<Long> txnIds = null;
            if (aTxnIds != null) {
                txnIds = new ArrayList<Long>(aTxnIds.length());
                for (int i = 0; i < aTxnIds.length(); ++i) {
                    txnIds.add(aTxnIds.getLong(i));
                }
            }
            NodeParameters nodeParameters = new NodeParameters();
            nodeParameters.setTransactionIds(txnIds);
            nodeParameters.setFromTxnId(fromTxnId);
            nodeParameters.setToTxnId(toTxnId);
            nodeParameters.setFromNodeId(fromNodeId);
            nodeParameters.setToNodeId(toNodeId);
            nodeParameters.setExcludeAspects(excludeAspects);
            nodeParameters.setIncludeAspects(includeAspects);
            nodeParameters.setExcludeNodeTypes(excludeNodeTypes);
            nodeParameters.setIncludeNodeTypes(includeNodeTypes);
            StoreRef storeRef = null;
            if (AuthenticationUtil.isMtEnabled()) {
                storeRef = new StoreRef(storeProtocol, storeIdentifier);
            } else {
                nodeParameters.setStoreProtocol(storeProtocol);
                nodeParameters.setStoreIdentifier(storeIdentifier);
            }
            nodeParameters.setMaxResults(maxResults);
            WebNodeQueryCallback nodeQueryCallback = new WebNodeQueryCallback(maxResults, storeRef, this.tenantService, this.qnameDAO);
            this.solrTrackingComponent.getNodes(nodeParameters, (SOLRTrackingComponent.NodeQueryCallback)nodeQueryCallback);
            HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
            List<NodeRecord> nodes = nodeQueryCallback.getNodes();
            model.put("nodes", nodes);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
            }
            return model;
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    private class WebNodeQueryCallback
    implements SOLRTrackingComponent.NodeQueryCallback {
        private ArrayList<NodeRecord> nodes;
        private StoreRef storeRef;
        private TenantService tenantService;
        private QNameDAO qnameDAO;

        public WebNodeQueryCallback(int count, StoreRef storeRef, TenantService tenantService, QNameDAO qnameDAO) {
            this.storeRef = storeRef;
            this.tenantService = tenantService;
            this.qnameDAO = qnameDAO;
            this.nodes = new ArrayList(count == 0 || count == Integer.MAX_VALUE ? 100 : count);
        }

        public boolean handleNode(Node node) {
            if (this.storeRef != null) {
                StoreRef tenantStoreRef = node.getStore().getStoreRef();
                StoreRef baseStoreRef = new StoreRef(tenantStoreRef.getProtocol(), this.tenantService.getBaseName(tenantStoreRef.getIdentifier(), true));
                if (this.storeRef.equals((Object)baseStoreRef)) {
                    this.nodes.add(new NodeRecord(node, this.qnameDAO));
                }
            } else {
                this.nodes.add(new NodeRecord(node, this.qnameDAO));
            }
            return true;
        }

        public List<NodeRecord> getNodes() {
            return this.nodes;
        }
    }

    public static class NodeRecord {
        private final Long id;
        private final Long txnId;
        private final boolean isDeleted;
        private final String nodeRef;

        public NodeRecord(Node node, QNameDAO qnameDAO) {
            this.id = node.getId();
            this.txnId = node.getTransaction().getId();
            this.isDeleted = node.getNodeStatus(qnameDAO).isDeleted();
            this.nodeRef = node.getNodeRef().toString();
        }

        public Long getId() {
            return this.id;
        }

        public Long getTxnId() {
            return this.txnId;
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public String getNodeRef() {
            return this.nodeRef;
        }
    }
}

