/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.solr.MetaDataResultsFilter;
import org.alfresco.repo.solr.NodeMetaData;
import org.alfresco.repo.solr.NodeMetaDataParameters;
import org.alfresco.repo.solr.SOLRTrackingComponent;
import org.alfresco.repo.web.scripts.solr.PropertyValue;
import org.alfresco.repo.web.scripts.solr.SOLRSerializer;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class NodesMetaDataGet
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(NodesMetaDataGet.class);
    private static final int INITIAL_DEFAULT_SIZE = 100;
    private static final int BATCH_SIZE = 50;
    private SOLRTrackingComponent solrTrackingComponent;
    private SOLRSerializer solrSerializer;

    public void setSolrTrackingComponent(SOLRTrackingComponent solrTrackingComponent) {
        this.solrTrackingComponent = solrTrackingComponent;
    }

    public void setSolrSerializer(SOLRSerializer solrSerializer) {
        this.solrSerializer = solrSerializer;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Content content = req.getContent();
            if (content == null) {
                throw new WebScriptException("Failed to convert request to String");
            }
            JSONObject o = new JSONObject(content.getContent());
            ArrayList<Long> nodeIds = null;
            if (o.has("nodeIds")) {
                JSONArray jsonNodeIds = o.getJSONArray("nodeIds");
                nodeIds = new ArrayList<Long>(jsonNodeIds.length());
                for (int i = 0; i < jsonNodeIds.length(); ++i) {
                    Long nodeId = jsonNodeIds.getLong(i);
                    nodeIds.add(nodeId);
                }
            }
            Long fromNodeId = o.has("fromNodeId") ? Long.valueOf(o.getLong("fromNodeId")) : null;
            Long toNodeId = o.has("toNodeId") ? Long.valueOf(o.getLong("toNodeId")) : null;
            int maxResults = o.has("maxResults") ? o.getInt("maxResults") : 0;
            int size = 0;
            if (maxResults != 0 && maxResults != Integer.MAX_VALUE) {
                size = maxResults;
            } else if (nodeIds != null) {
                size = nodeIds.size();
            } else if (fromNodeId != null && toNodeId != null) {
                if (toNodeId - fromNodeId > Integer.MAX_VALUE) {
                    throw new WebScriptException("Too many nodes expected, try changing the criteria");
                }
                size = (int)(toNodeId - fromNodeId);
            }
            final boolean noSizeCalculated = size == 0;
            MetaDataResultsFilter filter = new MetaDataResultsFilter();
            if (o.has("includeAclId")) {
                filter.setIncludeAclId(o.getBoolean("includeAclId"));
            }
            if (o.has("includeAspects")) {
                filter.setIncludeAspects(o.getBoolean("includeAspects"));
            }
            if (o.has("includeNodeRef")) {
                filter.setIncludeNodeRef(o.getBoolean("includeNodeRef"));
            }
            if (o.has("includeOwner")) {
                filter.setIncludeOwner(o.getBoolean("includeOwner"));
            }
            if (o.has("includeProperties")) {
                filter.setIncludeProperties(o.getBoolean("includeProperties"));
            }
            if (o.has("includePaths")) {
                filter.setIncludePaths(o.getBoolean("includePaths"));
            }
            if (o.has("includeType")) {
                filter.setIncludeType(o.getBoolean("includeType"));
            }
            if (o.has("includeParentAssociations")) {
                filter.setIncludeParentAssociations(o.getBoolean("includeChildIds"));
            }
            if (o.has("includeChildIds")) {
                filter.setIncludeChildIds(o.getBoolean("includeChildIds"));
            }
            if (o.has("includeTxnId")) {
                filter.setIncludeTxnId(o.getBoolean("includeTxnId"));
            }
            final ArrayList nodesMetaData = new ArrayList(size > 0 ? size : 100);
            NodeMetaDataParameters params = new NodeMetaDataParameters();
            params.setNodeIds(nodeIds);
            params.setFromNodeId(fromNodeId);
            params.setToNodeId(toNodeId);
            params.setMaxResults(maxResults);
            this.solrTrackingComponent.getNodesMetadata(params, filter, new SOLRTrackingComponent.NodeMetaDataQueryCallback(){
                private int counter = 50;
                private int numBatches = 0;

                public boolean handleNodeMetaData(NodeMetaData nodeMetaData) {
                    try {
                        FreemarkerNodeMetaData fNodeMetaData = new FreemarkerNodeMetaData(NodesMetaDataGet.this.solrSerializer, nodeMetaData);
                        nodesMetaData.add(fNodeMetaData);
                    }
                    catch (Exception e) {
                        throw new AlfrescoRuntimeException("Problem converting to Freemarker using node " + nodeMetaData.getNodeRef().toString(), (Throwable)e);
                    }
                    if (noSizeCalculated && --this.counter == 0) {
                        this.counter = 50;
                        nodesMetaData.ensureCapacity(++this.numBatches * 50);
                    }
                    return true;
                }
            });
            HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
            model.put("nodes", nodesMetaData);
            model.put("filter", filter);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
            }
            return model;
        }
        catch (IOException e) {
            throw new WebScriptException("IO exception parsing request", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException("Invalid JSON", (Throwable)e);
        }
    }

    public static class FreemarkerNodeMetaData {
        private Long nodeId;
        private NodeRef nodeRef;
        private QName nodeType;
        private Long aclId;
        private Map<String, PropertyValue> properties;
        private Set<QName> aspects;
        private List<String> paths;
        private List<ChildAssociationRef> childAssocs;
        private List<ChildAssociationRef> parentAssocs;
        private Long parentAssocsCrc;
        private List<Long> childIds;
        private String owner;
        private Long txnId;
        private Set<String> ancestors;
        private String tenantDomain;

        public FreemarkerNodeMetaData(SOLRSerializer solrSerializer, NodeMetaData nodeMetaData) throws IOException, JSONException {
            this.setNodeId(nodeMetaData.getNodeId());
            this.setTenantDomain(nodeMetaData.getTenantDomain());
            this.setAclId(nodeMetaData.getAclId());
            this.setNodeRef(nodeMetaData.getNodeRef());
            this.setNodeType(nodeMetaData.getNodeType());
            this.setTxnId(nodeMetaData.getTxnId());
            ArrayList<String> paths = new ArrayList<String>();
            HashSet<String> ancestors = new HashSet<String>();
            if (nodeMetaData.getPaths() != null) {
                for (Pair pair : nodeMetaData.getPaths()) {
                    JSONObject o = new JSONObject();
                    o.put("path", (Object)solrSerializer.serializeValue(String.class, pair.getFirst()));
                    o.put("qname", (Object)solrSerializer.serializeValue(String.class, pair.getSecond()));
                    paths.add(o.toString(3));
                    for (NodeRef ancestor : this.getAncestors((Path)pair.getFirst())) {
                        ancestors.add(ancestor.toString());
                    }
                }
            }
            this.setAncestors(ancestors);
            this.setPaths(paths);
            this.setChildAssocs(nodeMetaData.getChildAssocs());
            this.setChildIds(nodeMetaData.getChildIds());
            this.setParentAssocs(nodeMetaData.getParentAssocs());
            this.setParentAssocsCrc(nodeMetaData.getParentAssocsCrc());
            this.setAspects(nodeMetaData.getAspects());
            Map props = nodeMetaData.getProperties();
            if (props != null) {
                HashMap<String, PropertyValue> properties = props != null ? new HashMap<String, PropertyValue>(props.size()) : null;
                for (QName propName : props.keySet()) {
                    Serializable value = (Serializable)props.get(propName);
                    properties.put(solrSerializer.serializeValue(String.class, propName), solrSerializer.serialize(propName, value));
                }
                this.setProperties(properties);
            }
            this.setOwner(nodeMetaData.getOwner());
        }

        public NodeRef getNodeRef() {
            return this.nodeRef;
        }

        public void setNodeRef(NodeRef nodeRef) {
            this.nodeRef = nodeRef;
        }

        public List<String> getPaths() {
            return this.paths;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public QName getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(QName nodeType) {
            this.nodeType = nodeType;
        }

        public Long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(Long nodeId) {
            this.nodeId = nodeId;
        }

        public Long getAclId() {
            return this.aclId;
        }

        public void setAclId(Long aclId) {
            this.aclId = aclId;
        }

        public Map<String, PropertyValue> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, PropertyValue> properties) {
            this.properties = properties;
        }

        public Set<QName> getAspects() {
            return this.aspects;
        }

        public void setAspects(Set<QName> aspects) {
            this.aspects = aspects;
        }

        public List<ChildAssociationRef> getChildAssocs() {
            return this.childAssocs;
        }

        public void setChildAssocs(List<ChildAssociationRef> childAssocs) {
            this.childAssocs = childAssocs;
        }

        public List<ChildAssociationRef> getParentAssocs() {
            return this.parentAssocs;
        }

        public void setParentAssocs(List<ChildAssociationRef> parentAssocs) {
            this.parentAssocs = parentAssocs;
        }

        public Long getParentAssocsCrc() {
            return this.parentAssocsCrc;
        }

        public void setParentAssocsCrc(Long parentAssocsCrc) {
            this.parentAssocsCrc = parentAssocsCrc;
        }

        public void setAncestors(Set<String> ancestors) {
            this.ancestors = ancestors;
        }

        public Set<String> getAncestors() {
            return this.ancestors;
        }

        public List<Long> getChildIds() {
            return this.childIds;
        }

        public void setChildIds(List<Long> childIds) {
            this.childIds = childIds;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public Long getTxnId() {
            return this.txnId;
        }

        public void setTxnId(Long txnId) {
            this.txnId = txnId;
        }

        public String getTenantDomain() {
            return this.tenantDomain;
        }

        public void setTenantDomain(String tenantDomain) {
            this.tenantDomain = tenantDomain;
        }

        private ArrayList<NodeRef> getAncestors(Path path) {
            ArrayList<NodeRef> ancestors = new ArrayList<NodeRef>(8);
            for (Path.Element element : path) {
                if (!(element instanceof Path.ChildAssocElement)) {
                    throw new IndexerException("Confused path: " + path);
                }
                Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
                NodeRef parentRef = cae.getRef().getParentRef();
                if (parentRef == null) continue;
                ancestors.add(0, parentRef);
            }
            return ancestors;
        }
    }
}

